/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hive.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestProcedureCoordinator {
    private static final long WAKE_FREQUENCY = 1000L;
    private static final long TIMEOUT = 100000L;
    private static final long POOL_KEEP_ALIVE = 1L;
    private static final String nodeName = "node";
    private static final String procName = "some op";
    private static final byte[] procData = new byte[0];
    private static final List<String> expected = Lists.newArrayList("remote1", "remote2");
    private final ProcedureCoordinatorRpcs controller = (ProcedureCoordinatorRpcs)Mockito.mock(ProcedureCoordinatorRpcs.class);
    private final Procedure task = (Procedure)Mockito.mock(Procedure.class);
    private final ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
    private ProcedureCoordinator coordinator;

    @After
    public void resetTest() throws IOException {
        Mockito.reset((Object[])new Object[]{this.controller, this.task, this.monitor});
        if (this.coordinator != null) {
            this.coordinator.close();
        }
    }

    private ProcedureCoordinator buildNewCoordinator() {
        ThreadPoolExecutor pool = ProcedureCoordinator.defaultPool(nodeName, 1, 1L);
        return (ProcedureCoordinator)Mockito.spy((Object)new ProcedureCoordinator(this.controller, pool));
    }

    @Test
    public void testThreadPoolSize() throws Exception {
        ProcedureCoordinator coordinator = this.buildNewCoordinator();
        Procedure proc = new Procedure(coordinator, this.monitor, 1000L, 100000L, procName, procData, expected);
        Procedure procSpy = (Procedure)Mockito.spy((Object)proc);
        Procedure proc2 = new Procedure(coordinator, this.monitor, 1000L, 100000L, "some op2", procData, expected);
        Procedure procSpy2 = (Procedure)Mockito.spy((Object)proc2);
        Mockito.when((Object)coordinator.createProcedure((ForeignExceptionDispatcher)Matchers.any(ForeignExceptionDispatcher.class), (String)Matchers.eq((Object)procName), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class))).thenReturn((Object)procSpy, (Object[])new Procedure[]{procSpy2});
        coordinator.startProcedure(procSpy.getErrorMonitor(), procName, procData, expected);
        Assert.assertNull((String)"Coordinator successfully ran two tasks at once with a single thread pool.", (Object)coordinator.startProcedure(proc2.getErrorMonitor(), "another op", procData, expected));
    }

    @Test(timeout=60000L)
    public void testUnreachableControllerDuringPrepare() throws Exception {
        this.coordinator = this.buildNewCoordinator();
        List<String> expected = Arrays.asList("cohort");
        Procedure proc = new Procedure(this.coordinator, 1000L, 100000L, procName, procData, expected);
        Procedure procSpy = (Procedure)Mockito.spy((Object)proc);
        Mockito.when((Object)this.coordinator.createProcedure((ForeignExceptionDispatcher)Matchers.any(ForeignExceptionDispatcher.class), (String)Matchers.eq((Object)procName), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class))).thenReturn((Object)procSpy);
        IOException cause = new IOException("Failed to reach comms during acquire");
        ((ProcedureCoordinatorRpcs)Mockito.doThrow((Throwable)cause).when((Object)this.controller)).sendGlobalBarrierAcquire((Procedure)Matchers.eq((Object)procSpy), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class));
        proc = this.coordinator.startProcedure(proc.getErrorMonitor(), procName, procData, expected);
        while (!proc.completedLatch.await(1000L, TimeUnit.MILLISECONDS)) {
        }
        ((Procedure)Mockito.verify((Object)procSpy, (VerificationMode)Mockito.atLeastOnce())).receive((ForeignException)Matchers.any(ForeignException.class));
        ((ProcedureCoordinator)Mockito.verify((Object)this.coordinator, (VerificationMode)Mockito.times((int)1))).rpcConnectionFailure(Matchers.anyString(), (IOException)Matchers.eq((Object)cause));
        ((ProcedureCoordinatorRpcs)Mockito.verify((Object)this.controller, (VerificationMode)Mockito.times((int)1))).sendGlobalBarrierAcquire(procSpy, procData, expected);
        ((ProcedureCoordinatorRpcs)Mockito.verify((Object)this.controller, (VerificationMode)Mockito.never())).sendGlobalBarrierReached((Procedure)Matchers.any(Procedure.class), Matchers.anyListOf(String.class));
    }

    @Test(timeout=60000L)
    public void testUnreachableControllerDuringCommit() throws Exception {
        this.coordinator = this.buildNewCoordinator();
        List<String> expected = Arrays.asList("cohort");
        Procedure spy = (Procedure)Mockito.spy((Object)new Procedure(this.coordinator, 1000L, 100000L, procName, procData, expected));
        Mockito.when((Object)this.coordinator.createProcedure((ForeignExceptionDispatcher)Matchers.any(ForeignExceptionDispatcher.class), (String)Matchers.eq((Object)procName), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class))).thenReturn((Object)spy);
        IOException cause = new IOException("Failed to reach controller during prepare");
        ((ProcedureCoordinatorRpcs)Mockito.doAnswer((Answer)new AcquireBarrierAnswer(procName, "cohort")).when((Object)this.controller)).sendGlobalBarrierAcquire((Procedure)Matchers.eq((Object)spy), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class));
        ((ProcedureCoordinatorRpcs)Mockito.doThrow((Throwable)cause).when((Object)this.controller)).sendGlobalBarrierReached((Procedure)Matchers.eq((Object)spy), Matchers.anyListOf(String.class));
        Procedure task = this.coordinator.startProcedure(spy.getErrorMonitor(), procName, procData, expected);
        while (!task.completedLatch.await(1000L, TimeUnit.MILLISECONDS)) {
        }
        ((Procedure)Mockito.verify((Object)spy, (VerificationMode)Mockito.atLeastOnce())).receive((ForeignException)Matchers.any(ForeignException.class));
        ((ProcedureCoordinator)Mockito.verify((Object)this.coordinator, (VerificationMode)Mockito.times((int)1))).rpcConnectionFailure(Matchers.anyString(), (IOException)Matchers.eq((Object)cause));
        ((ProcedureCoordinatorRpcs)Mockito.verify((Object)this.controller, (VerificationMode)Mockito.times((int)1))).sendGlobalBarrierAcquire((Procedure)Matchers.eq((Object)spy), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class));
        ((ProcedureCoordinatorRpcs)Mockito.verify((Object)this.controller, (VerificationMode)Mockito.times((int)1))).sendGlobalBarrierReached((Procedure)Matchers.any(Procedure.class), Matchers.anyListOf(String.class));
    }

    @Test(timeout=60000L)
    public void testNoCohort() throws Exception {
        this.runSimpleProcedure(new String[0]);
    }

    @Test(timeout=60000L)
    public void testSingleCohortOrchestration() throws Exception {
        this.runSimpleProcedure("one");
    }

    @Test(timeout=60000L)
    public void testMultipleCohortOrchestration() throws Exception {
        this.runSimpleProcedure("one", "two", "three", "four");
    }

    public void runSimpleProcedure(String ... members) throws Exception {
        this.coordinator = this.buildNewCoordinator();
        Procedure task = new Procedure(this.coordinator, this.monitor, 1000L, 100000L, procName, procData, Arrays.asList(members));
        Procedure spy = (Procedure)Mockito.spy((Object)task);
        this.runCoordinatedProcedure(spy, members);
    }

    @Test(timeout=60000L)
    public void testEarlyJoiningBarrier() throws Exception {
        String[] cohort = new String[]{"one", "two", "three", "four"};
        final ProcedureCoordinator ref = this.coordinator = this.buildNewCoordinator();
        Procedure task = new Procedure(this.coordinator, this.monitor, 1000L, 100000L, procName, procData, Arrays.asList(cohort));
        Procedure spy = (Procedure)Mockito.spy((Object)task);
        AcquireBarrierAnswer prepare = new AcquireBarrierAnswer(procName, cohort){

            @Override
            public void doWork() {
                ref.memberAcquiredBarrier(this.opName, this.cohort[0]);
                ref.memberFinishedBarrier(this.opName, this.cohort[0], new byte[0]);
                ref.memberAcquiredBarrier(this.opName, this.cohort[1]);
                ref.memberAcquiredBarrier(this.opName, this.cohort[2]);
                ref.memberFinishedBarrier(this.opName, this.cohort[2], new byte[0]);
                ref.memberAcquiredBarrier(this.opName, this.cohort[3]);
            }
        };
        BarrierAnswer commit = new BarrierAnswer(procName, cohort){

            @Override
            public void doWork() {
                ref.memberFinishedBarrier(this.opName, this.cohort[1], new byte[0]);
                ref.memberFinishedBarrier(this.opName, this.cohort[3], new byte[0]);
            }
        };
        this.runCoordinatedOperation(spy, prepare, commit, cohort);
    }

    public void runCoordinatedProcedure(Procedure spy, String ... cohort) throws Exception {
        this.runCoordinatedOperation(spy, new AcquireBarrierAnswer(procName, cohort), new BarrierAnswer(procName, cohort), cohort);
    }

    public void runCoordinatedOperation(Procedure spy, AcquireBarrierAnswer prepare, String ... cohort) throws Exception {
        this.runCoordinatedOperation(spy, prepare, new BarrierAnswer(procName, cohort), cohort);
    }

    public void runCoordinatedOperation(Procedure spy, BarrierAnswer commit, String ... cohort) throws Exception {
        this.runCoordinatedOperation(spy, new AcquireBarrierAnswer(procName, cohort), commit, cohort);
    }

    public void runCoordinatedOperation(Procedure spy, AcquireBarrierAnswer prepareOperation, BarrierAnswer commitOperation, String ... cohort) throws Exception {
        List<String> expected = Arrays.asList(cohort);
        Mockito.when((Object)this.coordinator.createProcedure((ForeignExceptionDispatcher)Matchers.any(ForeignExceptionDispatcher.class), (String)Matchers.eq((Object)procName), (byte[])Matchers.eq((Object)procData), Matchers.anyListOf(String.class))).thenReturn((Object)spy);
        ((ProcedureCoordinatorRpcs)Mockito.doAnswer((Answer)prepareOperation).when((Object)this.controller)).sendGlobalBarrierAcquire(spy, procData, expected);
        ((ProcedureCoordinatorRpcs)Mockito.doAnswer((Answer)commitOperation).when((Object)this.controller)).sendGlobalBarrierReached((Procedure)Matchers.eq((Object)spy), Matchers.anyListOf(String.class));
        Procedure task = this.coordinator.startProcedure(spy.getErrorMonitor(), procName, procData, expected);
        task.waitForCompleted();
        prepareOperation.ensureRan();
        InOrder inorder = Mockito.inOrder((Object[])new Object[]{spy, this.controller});
        ((Procedure)inorder.verify((Object)spy)).sendGlobalBarrierStart();
        ((ProcedureCoordinatorRpcs)inorder.verify((Object)this.controller)).sendGlobalBarrierAcquire(task, procData, expected);
        ((Procedure)inorder.verify((Object)spy)).sendGlobalBarrierReached();
        ((ProcedureCoordinatorRpcs)inorder.verify((Object)this.controller)).sendGlobalBarrierReached((Procedure)Matchers.eq((Object)task), Matchers.anyListOf(String.class));
    }

    private class BarrierAnswer
    extends OperationAnswer {
        protected final String[] cohort;
        protected final String opName;

        public BarrierAnswer(String opName, String ... cohort) {
            this.cohort = cohort;
            this.opName = opName;
        }

        @Override
        public void doWork() {
            if (this.cohort == null) {
                return;
            }
            for (String member : this.cohort) {
                TestProcedureCoordinator.this.coordinator.memberFinishedBarrier(this.opName, member, new byte[0]);
            }
        }
    }

    private class AcquireBarrierAnswer
    extends OperationAnswer {
        protected final String[] cohort;
        protected final String opName;

        public AcquireBarrierAnswer(String opName, String ... cohort) {
            this.cohort = cohort;
            this.opName = opName;
        }

        @Override
        public void doWork() {
            if (this.cohort == null) {
                return;
            }
            for (String member : this.cohort) {
                TestProcedureCoordinator.this.coordinator.memberAcquiredBarrier(this.opName, member);
            }
        }
    }

    private abstract class OperationAnswer
    implements Answer<Void> {
        private boolean ran = false;

        private OperationAnswer() {
        }

        public void ensureRan() {
            Assert.assertTrue((String)"Prepare mocking didn't actually run!", (boolean)this.ran);
        }

        public final Void answer(InvocationOnMock invocation) throws Throwable {
            this.ran = true;
            this.doWork();
            return null;
        }

        protected abstract void doWork() throws Throwable;
    }
}

