/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSnapshotHFileCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @AfterClass
    public static void cleanup() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(rootDir, true);
    }

    @Test
    public void testFindsSnapshotFilesWhenCleaning() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        FSUtils.setRootDir(conf, TEST_UTIL.getDataTestDir());
        Path rootDir = FSUtils.getRootDir(conf);
        Path archivedHfileDir = new Path(TEST_UTIL.getDataTestDir(), "archive");
        FileSystem fs = FileSystem.get((Configuration)conf);
        SnapshotHFileCleaner cleaner = new SnapshotHFileCleaner();
        cleaner.setConf(conf);
        String snapshotName = "snapshot";
        byte[] snapshot = Bytes.toBytes(snapshotName);
        TableName tableName = TableName.valueOf("table");
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
        HRegionInfo mockRegion = new HRegionInfo(tableName);
        Path regionSnapshotDir = new Path(snapshotDir, mockRegion.getEncodedName());
        Path familyDir = new Path(regionSnapshotDir, "family");
        String hfile = "fd1e73e8a96c486090c5cec07b4894c4";
        Path refFile = new Path(familyDir, hfile);
        fs.create(refFile);
        fs.mkdirs(archivedHfileDir);
        fs.createNewFile(new Path(archivedHfileDir, hfile));
        Assert.assertFalse((boolean)cleaner.isFileDeletable(fs.getFileStatus(refFile)));
    }
}

