/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeleteTableProcedure {
    private static final Log LOG = LogFactory.getLog(TestDeleteTableProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestDeleteTableProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        Assert.assertTrue((String)"expected executor to be running", (boolean)procExec.isRunning());
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L, expected=TableNotFoundException.class)
    public void testDeleteNotExistentTable() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteNotExistentTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure(procExec.getEnvironment(), tableName, latch));
        ((ProcedurePrepareLatch)latch).await();
    }

    @Test(timeout=60000L, expected=TableNotDisabledException.class)
    public void testDeleteNotDisabledTable() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteNotDisabledTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        ProcedurePrepareLatch.CompatibilityLatch latch = new ProcedurePrepareLatch.CompatibilityLatch();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure(procExec.getEnvironment(), tableName, latch));
        ((ProcedurePrepareLatch)latch).await();
    }

    @Test(timeout=60000L)
    public void testDeleteDeletedTable() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteDeletedTable");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f");
        UTIL.getHBaseAdmin().disableTable(tableName);
        long procId1 = procExec.submitProcedure(new DeleteTableProcedure(procExec.getEnvironment(), tableName));
        long procId2 = procExec.submitProcedure(new DeleteTableProcedure(procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f");
        ProcedureResult result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(result.getException().getCause() instanceof TableNotFoundException));
    }

    @Test(timeout=60000L)
    public void testSimpleDelete() throws Exception {
        TableName tableName = TableName.valueOf("testSimpleDelete");
        byte[][] splitKeys = null;
        this.testSimpleDelete(tableName, splitKeys);
    }

    @Test(timeout=60000L)
    public void testSimpleDeleteWithSplits() throws Exception {
        TableName tableName = TableName.valueOf("testSimpleDeleteWithSplits");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("c")};
        this.testSimpleDelete(tableName, splitKeys);
    }

    private void testSimpleDelete(TableName tableName, byte[][] splitKeys) throws Exception {
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        long procId = ProcedureTestingUtility.submitAndWait(procExec, (Procedure)new DeleteTableProcedure(procExec.getEnvironment(), tableName));
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf("testRecoveryAndDoubleExecution");
        byte[][] splitKeys = null;
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(this.getMasterProcedureExecutor(), tableName, splitKeys, "f1", "f2");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteTableProcedure(procExec.getEnvironment(), tableName));
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, 6, MasterProcedureProtos.DeleteTableState.values());
        MasterProcedureTestingUtility.validateTableDeletion(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2");
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

