/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.DeleteColumnFamilyProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeleteColumnFamilyProcedure {
    private static final Log LOG = LogFactory.getLog(TestDeleteColumnFamilyProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestDeleteColumnFamilyProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(this.getMasterProcedureExecutor(), (boolean)false);
        for (HTableDescriptor htd : UTIL.getHBaseAdmin().listTables()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test(timeout=60000L)
    public void testDeleteColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteColumnFamily");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        String cf1 = "cf1";
        String cf2 = "cf2";
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "cf1", "cf2", "f3");
        long procId1 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf1".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf1");
        UTIL.getHBaseAdmin().disableTable(tableName);
        long procId2 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf2".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId2);
    }

    @Test(timeout=60000L)
    public void testDeleteColumnFamilyTwice() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteColumnFamilyTwice");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        String cf2 = "cf2";
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "cf2");
        long procId1 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf2".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId1);
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf2");
        long procId2 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf2".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId2);
        ProcedureResult result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete online failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(result.getException().getCause() instanceof InvalidFamilyOperationException));
        UTIL.getHBaseAdmin().disableTable(tableName);
        long procId3 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf2".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId3);
        result = procExec.getResult(procId2);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete offline failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(result.getException().getCause() instanceof InvalidFamilyOperationException));
    }

    @Test(timeout=60000L)
    public void testDeleteNonExistingColumnFamily() throws Exception {
        TableName tableName = TableName.valueOf("testDeleteNonExistingColumnFamily");
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        String cf3 = "cf3";
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2");
        long procId1 = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf3".getBytes()));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId1);
        ProcedureResult result = procExec.getResult(procId1);
        Assert.assertTrue((boolean)result.isFailed());
        LOG.debug("Delete failed with exception: " + result.getException());
        Assert.assertTrue((boolean)(result.getException().getCause() instanceof InvalidFamilyOperationException));
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOffline() throws Exception {
        TableName tableName = TableName.valueOf("testRecoveryAndDoubleExecutionOffline");
        String cf4 = "cf4";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3", "cf4");
        UTIL.getHBaseAdmin().disableTable(tableName);
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf4".getBytes()));
        int numberOfSteps = MasterProcedureProtos.DeleteColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf4");
    }

    @Test(timeout=60000L)
    public void testRecoveryAndDoubleExecutionOnline() throws Exception {
        TableName tableName = TableName.valueOf("testRecoveryAndDoubleExecutionOnline");
        String cf5 = "cf5";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3", "cf5");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf5".getBytes()));
        int numberOfSteps = MasterProcedureProtos.DeleteColumnFamilyState.values().length;
        MasterProcedureTestingUtility.testRecoveryAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf5");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecution() throws Exception {
        TableName tableName = TableName.valueOf("testRollbackAndDoubleExecution");
        String cf5 = "cf5";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3", "cf5");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf5".getBytes()));
        int numberOfSteps = 1;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecution(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteColumnFamilyState.values());
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, "f1", "f2", "f3", "cf5");
    }

    @Test(timeout=60000L)
    public void testRollbackAndDoubleExecutionAfterPONR() throws Exception {
        TableName tableName = TableName.valueOf("testRollbackAndDoubleExecutionAfterPONR");
        String cf5 = "cf5";
        ProcedureExecutor<MasterProcedureEnv> procExec = this.getMasterProcedureExecutor();
        HRegionInfo[] regions = MasterProcedureTestingUtility.createTable(procExec, tableName, null, "f1", "f2", "f3", "cf5");
        ProcedureTestingUtility.waitNoProcedureRunning(procExec);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure(new DeleteColumnFamilyProcedure(procExec.getEnvironment(), tableName, "cf5".getBytes()));
        int numberOfSteps = 4;
        MasterProcedureTestingUtility.testRollbackAndDoubleExecutionAfterPONR(procExec, procId, numberOfSteps, MasterProcedureProtos.DeleteColumnFamilyState.values());
        MasterProcedureTestingUtility.validateColumnFamilyDeletion(UTIL.getHBaseCluster().getMaster(), tableName, "cf5");
    }

    private ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
    }
}

