/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCreateTableProcedure2 {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestCreateTableProcedure2.class);

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testMasterRestartAfterNameSpaceEnablingNodeIsCreated() throws Exception {
        MiniZooKeeperCluster zkCluster = TEST_UTIL.startMiniZKCluster();
        TableName tableName = TableName.valueOf("hbase:namespace");
        ZooKeeperWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        String znode = ZKUtil.joinZNode(zkw.tableZNode, tableName.getNameAsString());
        ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
        builder.setState(ZooKeeperProtos.Table.State.ENABLED);
        byte[] data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
        ZKUtil.createSetData(zkw, znode, data);
        LOG.info("Create an orphaned Znode " + znode + " with data " + data);
        TEST_UTIL.setZkCluster(zkCluster);
        TEST_UTIL.startMiniCluster();
        Assert.assertTrue((TEST_UTIL.getHBaseCluster().getLiveMasterThreads().size() == 1 ? 1 : 0) != 0);
    }
}

