/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.net.URLEncoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestLogsCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        long ttl = 10000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttl);
        conf.setBoolean("hbase.replication", true);
        Replication.decorateMasterConfiguration(conf);
        DummyServer server = new DummyServer();
        ReplicationQueues repQueues = ReplicationFactory.getReplicationQueues(server.getZooKeeper(), conf, server);
        repQueues.init(server.getServerName().toString());
        final Path oldLogDir = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), "UTF8");
        final FileSystem fs = FileSystem.get((Configuration)conf);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + "a"));
        System.out.println("Now is: " + now);
        for (int i = 1; i < 31; ++i) {
            Path fileName = new Path(oldLogDir, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 1) continue;
            repQueues.addLog(fakeMachineName, fileName.getName());
            System.out.println("Replication log file: " + fileName);
        }
        Thread.sleep(ttl);
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + 10000L)));
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            System.out.println(stat.getPath().toString());
        }
        Assert.assertEquals((long)34L, (long)fs.listStatus(oldLogDir).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return 5 == fs.listStatus(oldLogDir).length;
            }
        });
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            System.out.println("Kept log files: " + file.getPath().getName());
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        @Override
        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("regionserver,60020,000000");
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

