/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestStochasticLoadBalancer
extends BalancerTestBase {
    public static final String REGION_KEY = "testRegion";
    private static StochasticLoadBalancer loadBalancer;
    private static final Log LOG;
    private static Configuration conf;
    int[] largeCluster = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56};
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {514, 1432}, {48, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {10, 7, 12, 8, 11, 10, 9, 14}, {13, 14, 6, 10, 10, 10, 8, 10}, {130, 14, 60, 10, 100, 10, 80, 10}, {130, 140, 60, 100, 100, 100, 80, 100}, this.largeCluster};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        conf = HBaseConfiguration.create();
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 0.75f);
        conf.setFloat("hbase.regions.slop", 0.0f);
        loadBalancer = new StochasticLoadBalancer();
        loadBalancer.setConf(conf);
    }

    @Test
    public void testKeepRegionLoad() throws Exception {
        RegionLoad rl;
        ServerName sn = ServerName.valueOf("test:8080", 100L);
        int numClusterStatusToAdd = 20000;
        for (int i = 0; i < numClusterStatusToAdd; ++i) {
            ServerLoad sl = (ServerLoad)Mockito.mock(ServerLoad.class);
            rl = (RegionLoad)Mockito.mock(RegionLoad.class);
            Mockito.when((Object)rl.getStores()).thenReturn((Object)i);
            TreeMap<byte[], RegionLoad> regionLoadMap = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);
            regionLoadMap.put(Bytes.toBytes(REGION_KEY), rl);
            Mockito.when(sl.getRegionsLoad()).thenReturn(regionLoadMap);
            ClusterStatus clusterStatus = (ClusterStatus)((Object)Mockito.mock(ClusterStatus.class));
            Mockito.when(clusterStatus.getServers()).thenReturn(Arrays.asList(sn));
            Mockito.when((Object)clusterStatus.getLoad(sn)).thenReturn((Object)sl);
            loadBalancer.setClusterStatus(clusterStatus);
        }
        Assert.assertTrue((TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY) != null ? 1 : 0) != 0);
        Assert.assertTrue((TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY).size() == 15 ? 1 : 0) != 0);
        Queue loads = TestStochasticLoadBalancer.loadBalancer.loads.get(REGION_KEY);
        int i = 0;
        while (loads.size() > 0) {
            rl = (RegionLoad)loads.remove();
            Assert.assertEquals((long)(i + (numClusterStatusToAdd - 15)), (long)rl.getStores());
            ++i;
        }
    }

    @Test
    public void testBalanceCluster() throws Exception {
        for (int[] mockCluster : this.clusterStateMocks) {
            TreeMap<ServerName, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            List<ServerAndLoad> list = this.convertToList(servers);
            LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
            List<RegionPlan> plans = loadBalancer.balanceCluster(servers);
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, servers);
            LOG.info("Mock Balance : " + this.printMock(balancedCluster));
            this.assertClusterAsBalanced(balancedCluster);
            List<RegionPlan> secondPlans = loadBalancer.balanceCluster(servers);
            Assert.assertNull(secondPlans);
            for (Map.Entry entry : servers.entrySet()) {
                this.returnRegions((List)entry.getValue());
                this.returnServer((ServerName)entry.getKey());
            }
        }
    }

    @Test
    public void testSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionCountSkewCostFunction costFunction = new StochasticLoadBalancer.RegionCountSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            costFunction.init(this.mockCluster(mockCluster));
            double cost = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 0, 1}));
        Assert.assertEquals((double)0.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 1, 1}));
        Assert.assertEquals((double)0.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 0, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{0, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{1, 1, 1, 1, 1}));
        Assert.assertEquals((double)0.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
        costFunction.init(this.mockCluster(new int[]{10000, 0, 0, 0, 0}));
        Assert.assertEquals((double)1.0, (double)((StochasticLoadBalancer.CostFunction)costFunction).cost(), (double)0.01);
    }

    @Test
    public void testTableSkewCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.TableSkewCostFunction costFunction = new StochasticLoadBalancer.TableSkewCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            costFunction.init(cluster);
            double cost = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCostFromArray() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.MemstoreSizeCostFunction costFunction = new StochasticLoadBalancer.MemstoreSizeCostFunction(conf);
        costFunction.init(this.mockCluster(new int[]{0, 0, 0, 0, 1}));
        double[] statOne = new double[100];
        for (int i = 0; i < 100; ++i) {
            statOne[i] = 10.0;
        }
        Assert.assertEquals((double)0.0, (double)costFunction.costFromArray(statOne), (double)0.01);
        double[] statTwo = new double[101];
        for (int i = 0; i < 100; ++i) {
            statTwo[i] = 0.0;
        }
        statTwo[100] = 100.0;
        Assert.assertEquals((double)1.0, (double)costFunction.costFromArray(statTwo), (double)0.01);
        double[] statThree = new double[200];
        for (int i = 0; i < 100; ++i) {
            statThree[i] = 0.0;
            statThree[i + 100] = 100.0;
        }
        Assert.assertEquals((double)0.5, (double)costFunction.costFromArray(statThree), (double)0.01);
    }

    @Test(timeout=60000L)
    public void testLosingRs() throws Exception {
        int numNodes = 3;
        int numRegions = 20;
        int numRegionsPerServer = 3;
        int replication = 1;
        int numTables = 2;
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        List<ServerAndLoad> list = this.convertToList(serverMap);
        List<RegionPlan> plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNotNull(plans);
        List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
        this.assertClusterAsBalanced(balancedCluster);
        ServerName sn = serverMap.keySet().toArray(new ServerName[serverMap.size()])[0];
        ServerName deadSn = ServerName.valueOf(sn.getHostname(), sn.getPort(), sn.getStartcode() - 100L);
        serverMap.put(deadSn, new ArrayList(0));
        plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNull(plans);
    }

    @Test
    public void testReplicaCost() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionReplicaHostCostFunction costFunction = new StochasticLoadBalancer.RegionReplicaHostCostFunction(conf);
        for (int[] mockCluster : this.clusterStateMocks) {
            BaseLoadBalancer.Cluster cluster = this.mockCluster(mockCluster);
            ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
            double cost = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
            Assert.assertTrue((cost >= 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((cost <= 1.01 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testReplicaCostForReplicas() {
        Configuration conf = HBaseConfiguration.create();
        StochasticLoadBalancer.RegionReplicaHostCostFunction costFunction = new StochasticLoadBalancer.RegionReplicaHostCostFunction(conf);
        int[] servers = new int[]{3, 3, 3, 3, 3};
        TreeMap<ServerName, List<HRegionInfo>> clusterState = this.mockClusterServers(servers);
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
        double costWithoutReplicas = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
        Assert.assertEquals((double)0.0, (double)costWithoutReplicas, (double)0.0);
        HRegionInfo replica1 = RegionReplicaUtil.getRegionInfoForReplica(clusterState.firstEntry().getValue().get(0), 1);
        clusterState.lastEntry().getValue().add(replica1);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
        double costWith1ReplicaDifferentServer = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
        Assert.assertEquals((double)0.0, (double)costWith1ReplicaDifferentServer, (double)0.0);
        HRegionInfo replica2 = RegionReplicaUtil.getRegionInfoForReplica(replica1, 2);
        clusterState.lastEntry().getValue().add(replica2);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
        double costWith1ReplicaSameServer = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
        Assert.assertTrue((costWith1ReplicaDifferentServer < costWith1ReplicaSameServer ? 1 : 0) != 0);
        clusterState = this.mockClusterServers(servers);
        Iterator<Map.Entry<ServerName, List<HRegionInfo>>> it = clusterState.entrySet().iterator();
        Map.Entry<ServerName, List<HRegionInfo>> entry = it.next();
        HRegionInfo hri = entry.getValue().get(0);
        replica1 = RegionReplicaUtil.getRegionInfoForReplica(hri, 1);
        replica2 = RegionReplicaUtil.getRegionInfoForReplica(hri, 2);
        HRegionInfo replica3 = RegionReplicaUtil.getRegionInfoForReplica(hri, 3);
        entry.getValue().add(replica1);
        entry.getValue().add(replica2);
        it.next().getValue().add(replica3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
        double costWith3ReplicasSameServer = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
        clusterState = this.mockClusterServers(servers);
        hri = clusterState.firstEntry().getValue().get(0);
        replica1 = RegionReplicaUtil.getRegionInfoForReplica(hri, 1);
        replica2 = RegionReplicaUtil.getRegionInfoForReplica(hri, 2);
        replica3 = RegionReplicaUtil.getRegionInfoForReplica(hri, 3);
        clusterState.firstEntry().getValue().add(replica1);
        clusterState.lastEntry().getValue().add(replica2);
        clusterState.lastEntry().getValue().add(replica3);
        cluster = new BaseLoadBalancer.Cluster(clusterState, null, null, null);
        ((StochasticLoadBalancer.CostFunction)costFunction).init(cluster);
        double costWith2ReplicasOnTwoServers = ((StochasticLoadBalancer.CostFunction)costFunction).cost();
        Assert.assertTrue((costWith2ReplicasOnTwoServers < costWith3ReplicasSameServer ? 1 : 0) != 0);
    }

    @Test
    public void testNeedsBalanceForColocatedReplicas() {
        List<HRegionInfo> regions = this.randomRegions(1);
        ServerName s1 = ServerName.valueOf("host1", 1000, 11111L);
        ServerName s2 = ServerName.valueOf("host11", 1000, 11111L);
        HashMap<ServerName, List<HRegionInfo>> map = new HashMap<ServerName, List<HRegionInfo>>();
        map.put(s1, regions);
        regions.add(RegionReplicaUtil.getRegionInfoForReplica(regions.get(0), 1));
        regions = this.randomRegions(1);
        map.put(s2, regions);
        Assert.assertTrue((boolean)loadBalancer.needsBalance(new BaseLoadBalancer.Cluster(map, null, null, null)));
        map.clear();
        regions = this.randomRegions(1);
        ArrayList<HRegionInfo> regionsOnS2 = new ArrayList<HRegionInfo>(1);
        regionsOnS2.add(RegionReplicaUtil.getRegionInfoForReplica(regions.get(0), 1));
        map.put(s1, regions);
        map.put(s2, regionsOnS2);
        map.put(ServerName.valueOf("host2", 1000, 11111L), this.randomRegions(1));
        Assert.assertTrue((boolean)loadBalancer.needsBalance(new BaseLoadBalancer.Cluster(map, null, null, new ForTestRackManagerOne())));
    }

    @Test(timeout=60000L)
    public void testSmallCluster() {
        int numNodes = 10;
        int numRegions = 1000;
        int numRegionsPerServer = 40;
        int replication = 1;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=60000L)
    public void testSmallCluster2() {
        int numNodes = 20;
        int numRegions = 2000;
        int numRegionsPerServer = 40;
        int replication = 1;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=60000L)
    public void testSmallCluster3() {
        int numNodes = 20;
        int numRegions = 2000;
        int numRegionsPerServer = 1;
        int replication = 1;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, false, false);
    }

    @Test(timeout=800000L)
    public void testMidCluster() {
        int numNodes = 100;
        int numRegions = 10000;
        int numRegionsPerServer = 60;
        int replication = 1;
        int numTables = 40;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testMidCluster2() {
        int numNodes = 200;
        int numRegions = 100000;
        int numRegionsPerServer = 40;
        int replication = 1;
        int numTables = 400;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, false, false);
    }

    @Test(timeout=800000L)
    public void testMidCluster3() {
        int numNodes = 100;
        int numRegions = 2000;
        int numRegionsPerServer = 9;
        int replication = 1;
        int numTables = 110;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test
    public void testLargeCluster() {
        int numNodes = 1000;
        int numRegions = 100000;
        int numRegionsPerServer = 80;
        int numTables = 100;
        int replication = 1;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnSmallCluster() {
        int numNodes = 10;
        int numRegions = 1000;
        int replication = 3;
        int numRegionsPerServer = 80;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnMidCluster() {
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 90000L);
        loadBalancer.setConf(conf);
        int numNodes = 200;
        int numRegions = 8000;
        int replication = 3;
        int numRegionsPerServer = 30;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnLargeCluster() {
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 90000L);
        loadBalancer.setConf(conf);
        int numNodes = 1000;
        int numRegions = 20 * numNodes;
        int numRegionsPerServer = 19;
        int numTables = 100;
        int replication = 3;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicasOnMidClusterHighReplication() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 4000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        loadBalancer.setConf(conf);
        int numNodes = 80;
        int numRegions = 6 * numNodes;
        int replication = 80;
        int numRegionsPerServer = 5;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, false, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicationOnMidClusterSameHosts() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 90000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        loadBalancer.setConf(conf);
        int numHosts = 100;
        int numRegions = 10000;
        int replication = 3;
        int numRegionsPerServer = 5;
        int numTables = 10;
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numHosts, numRegions, numRegionsPerServer, replication, numTables);
        int numNodesPerHost = 4;
        TreeMap<ServerName, List<HRegionInfo>> newServerMap = new TreeMap<ServerName, List<HRegionInfo>>(serverMap);
        for (Map.Entry<ServerName, List<HRegionInfo>> entry : serverMap.entrySet()) {
            for (int i = 1; i < numNodesPerHost; ++i) {
                ServerName s1 = entry.getKey();
                ServerName s2 = ServerName.valueOf(s1.getHostname(), s1.getPort() + i, 1L);
                newServerMap.put(s2, new ArrayList());
            }
        }
        this.testWithCluster(newServerMap, null, true, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicationOnMidClusterWithRacks() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 10000000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        loadBalancer.setConf(conf);
        int numNodes = 30;
        int numRegions = numNodes * 30;
        int replication = 3;
        int numRegionsPerServer = 28;
        int numTables = 10;
        int numRacks = 4;
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        ForTestRackManager rm = new ForTestRackManager(numRacks);
        this.testWithCluster(serverMap, rm, false, true);
    }

    @Test(timeout=800000L)
    public void testRegionReplicationOnMidClusterReplicationGreaterThanNumNodes() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 2000000L);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        loadBalancer.setConf(conf);
        int numNodes = 40;
        int numRegions = 300;
        int replication = 50;
        int numRegionsPerServer = 6;
        int numTables = 10;
        this.testWithCluster(numNodes, numRegions, numRegionsPerServer, replication, numTables, true, false);
    }

    protected void testWithCluster(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        Map<ServerName, List<HRegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        this.testWithCluster(serverMap, null, assertFullyBalanced, assertFullyBalancedForReplicas);
    }

    protected void testWithCluster(Map<ServerName, List<HRegionInfo>> serverMap, RackManager rackManager, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        List<ServerAndLoad> list = this.convertToList(serverMap);
        LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
        loadBalancer.setRackManager(rackManager);
        List<RegionPlan> plans = loadBalancer.balanceCluster(serverMap);
        Assert.assertNotNull(plans);
        if (assertFullyBalanced || assertFullyBalancedForReplicas) {
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
            LOG.info("Mock Balance : " + this.printMock(balancedCluster));
            if (assertFullyBalanced) {
                this.assertClusterAsBalanced(balancedCluster);
                List<RegionPlan> secondPlans = loadBalancer.balanceCluster(serverMap);
                Assert.assertNull(secondPlans);
            }
            if (assertFullyBalancedForReplicas) {
                this.assertRegionReplicaPlacement(serverMap, rackManager);
            }
        }
    }

    private Map<ServerName, List<HRegionInfo>> createServerMap(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables) {
        int[] cluster = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            cluster[i] = numRegionsPerServer;
        }
        cluster[cluster.length - 1] = numRegions - (cluster.length - 1) * numRegionsPerServer;
        TreeMap<ServerName, List<HRegionInfo>> clusterState = this.mockClusterServers(cluster, numTables);
        if (replication > 0) {
            for (List regions : clusterState.values()) {
                int length = regions.size();
                for (int i = 0; i < length; ++i) {
                    for (int r = 1; r < replication; ++r) {
                        regions.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)regions.get(i), r));
                    }
                }
            }
        }
        return clusterState;
    }

    static {
        LOG = LogFactory.getLog(TestStochasticLoadBalancer.class);
    }

    private static class ForTestRackManagerOne
    extends RackManager {
        private ForTestRackManagerOne() {
        }

        @Override
        public String getRack(ServerName server) {
            return server.getHostname().endsWith("1") ? "rack1" : "rack2";
        }
    }

    private static class ForTestRackManager
    extends RackManager {
        int numRacks;

        public ForTestRackManager(int numRacks) {
            this.numRacks = numRacks;
        }

        @Override
        public String getRack(ServerName server) {
            return "rack_" + server.hashCode() % this.numRacks;
        }
    }
}

