/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Triple;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestFavoredNodeAssignmentHelper {
    private static List<ServerName> servers = new ArrayList<ServerName>();
    private static Map<String, List<ServerName>> rackToServers = new HashMap<String, List<ServerName>>();
    private static RackManager rackManager = (RackManager)Mockito.mock(RackManager.class);

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        for (int i = 0; i < 40; ++i) {
            ArrayList servers;
            ServerName server = ServerName.valueOf("foo" + i + ":1234", -1L);
            if (i < 10) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack1");
                if (rackToServers.get("rack1") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack1", servers);
                }
                rackToServers.get("rack1").add(server);
            }
            if (i >= 10 && i < 20) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack2");
                if (rackToServers.get("rack2") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack2", servers);
                }
                rackToServers.get("rack2").add(server);
            }
            if (i >= 20 && i < 30) {
                Mockito.when((Object)rackManager.getRack(server)).thenReturn((Object)"rack3");
                if (rackToServers.get("rack3") == null) {
                    servers = new ArrayList();
                    rackToServers.put("rack3", servers);
                }
                rackToServers.get("rack3").add(server);
            }
            TestFavoredNodeAssignmentHelper.servers.add(server);
        }
    }

    private static List<ServerName> getServersFromRack(Map<String, Integer> rackToServerCount) {
        ArrayList<ServerName> chosenServers = new ArrayList<ServerName>();
        for (Map.Entry<String, Integer> entry : rackToServerCount.entrySet()) {
            List<ServerName> servers = rackToServers.get(entry.getKey());
            for (int i = 0; i < entry.getValue(); ++i) {
                chosenServers.add(servers.get(i));
            }
        }
        return chosenServers;
    }

    @Test
    public void testSmallCluster() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 2);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, new Configuration());
        Assert.assertFalse((boolean)helper.canPlaceFavoredNodes());
    }

    @Test
    public void testPlacePrimaryRSAsRoundRobin() {
        this.primaryRSPlacement(6, null, 10, 10, 10);
        this.primaryRSPlacement(600, null, 10, 10, 10);
    }

    @Test
    public void testRoundRobinAssignmentsWithUnevenSizedRacks() {
        this.primaryRSPlacement(6, null, 10, 10, 10);
        this.primaryRSPlacement(600, null, 10, 10, 5);
        this.primaryRSPlacement(600, null, 10, 5, 10);
        this.primaryRSPlacement(600, null, 5, 10, 10);
        this.primaryRSPlacement(500, null, 10, 10, 5);
        this.primaryRSPlacement(500, null, 10, 5, 10);
        this.primaryRSPlacement(500, null, 5, 10, 10);
        this.primaryRSPlacement(500, null, 9, 7, 8);
        this.primaryRSPlacement(500, null, 8, 7, 9);
        this.primaryRSPlacement(500, null, 7, 9, 8);
        this.primaryRSPlacement(459, null, 7, 9, 8);
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithSingleRack() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 10);
        Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(60000, rackToServerCount);
        FavoredNodeAssignmentHelper helper = primaryRSMapAndHelper.getSecond();
        Map<HRegionInfo, ServerName> primaryRSMap = primaryRSMapAndHelper.getFirst();
        List<HRegionInfo> regions = primaryRSMapAndHelper.getThird();
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (HRegionInfo region : regions) {
            ServerName[] secondaryAndTertiaryServers = secondaryAndTertiaryMap.get(region);
            Assert.assertTrue((!secondaryAndTertiaryServers[0].equals(primaryRSMap.get(region)) ? 1 : 0) != 0);
            Assert.assertTrue((!secondaryAndTertiaryServers[1].equals(primaryRSMap.get(region)) ? 1 : 0) != 0);
            Assert.assertTrue((!secondaryAndTertiaryServers[0].equals(secondaryAndTertiaryServers[1]) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithSingleServer() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 1);
        Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(1, rackToServerCount);
        FavoredNodeAssignmentHelper helper = primaryRSMapAndHelper.getSecond();
        Map<HRegionInfo, ServerName> primaryRSMap = primaryRSMapAndHelper.getFirst();
        List<HRegionInfo> regions = primaryRSMapAndHelper.getThird();
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertTrue((secondaryAndTertiaryMap.get(regions.get(0)) == null ? 1 : 0) != 0);
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithMultipleRacks() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 10);
        rackToServerCount.put("rack2", 10);
        Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(60000, rackToServerCount);
        FavoredNodeAssignmentHelper helper = primaryRSMapAndHelper.getSecond();
        Map<HRegionInfo, ServerName> primaryRSMap = primaryRSMapAndHelper.getFirst();
        Assert.assertTrue((primaryRSMap.size() == 60000 ? 1 : 0) != 0);
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        Assert.assertTrue((secondaryAndTertiaryMap.size() == 60000 ? 1 : 0) != 0);
        for (Map.Entry<HRegionInfo, ServerName[]> entry : secondaryAndTertiaryMap.entrySet()) {
            ServerName[] allServersForRegion = entry.getValue();
            String primaryRSRack = rackManager.getRack(primaryRSMap.get(entry.getKey()));
            String secondaryRSRack = rackManager.getRack(allServersForRegion[0]);
            String tertiaryRSRack = rackManager.getRack(allServersForRegion[1]);
            Assert.assertTrue((!primaryRSRack.equals(secondaryRSRack) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)secondaryRSRack.equals(tertiaryRSRack));
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithLessThanTwoServersInRacks() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 1);
        rackToServerCount.put("rack2", 1);
        Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(6, rackToServerCount);
        FavoredNodeAssignmentHelper helper = primaryRSMapAndHelper.getSecond();
        Map<HRegionInfo, ServerName> primaryRSMap = primaryRSMapAndHelper.getFirst();
        List<HRegionInfo> regions = primaryRSMapAndHelper.getThird();
        Assert.assertTrue((primaryRSMap.size() == 6 ? 1 : 0) != 0);
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (HRegionInfo region : regions) {
            Assert.assertTrue((secondaryAndTertiaryMap.get(region) == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSecondaryAndTertiaryPlacementWithMoreThanOneServerInPrimaryRack() {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", 2);
        rackToServerCount.put("rack2", 1);
        Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> primaryRSMapAndHelper = this.secondaryAndTertiaryRSPlacementHelper(6, rackToServerCount);
        FavoredNodeAssignmentHelper helper = primaryRSMapAndHelper.getSecond();
        Map<HRegionInfo, ServerName> primaryRSMap = primaryRSMapAndHelper.getFirst();
        List<HRegionInfo> regions = primaryRSMapAndHelper.getThird();
        Assert.assertTrue((primaryRSMap.size() == 6 ? 1 : 0) != 0);
        Map<HRegionInfo, ServerName[]> secondaryAndTertiaryMap = helper.placeSecondaryAndTertiaryRS(primaryRSMap);
        for (HRegionInfo region : regions) {
            ServerName s = primaryRSMap.get(region);
            ServerName secondaryRS = secondaryAndTertiaryMap.get(region)[0];
            ServerName tertiaryRS = secondaryAndTertiaryMap.get(region)[1];
            if (rackManager.getRack(s).equals("rack1")) {
                Assert.assertTrue((rackManager.getRack(secondaryRS).equals("rack2") && rackManager.getRack(tertiaryRS).equals("rack1") ? 1 : 0) != 0);
            }
            if (!rackManager.getRack(s).equals("rack2")) continue;
            Assert.assertTrue((rackManager.getRack(secondaryRS).equals("rack1") && rackManager.getRack(tertiaryRS).equals("rack1") ? 1 : 0) != 0);
        }
    }

    private Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>> secondaryAndTertiaryRSPlacementHelper(int regionCount, Map<String, Integer> rackToServerCount) {
        HashMap<HRegionInfo, ServerName> primaryRSMap = new HashMap<HRegionInfo, ServerName>();
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        HashMap<ServerName, List<HRegionInfo>> assignmentMap = new HashMap<ServerName, List<HRegionInfo>>();
        helper.initialize();
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            HRegionInfo region = new HRegionInfo(TableName.valueOf("foobar"), Bytes.toBytes(i), Bytes.toBytes(i + 1));
            regions.add(region);
        }
        helper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        return new Triple<Map<HRegionInfo, ServerName>, FavoredNodeAssignmentHelper, List<HRegionInfo>>(primaryRSMap, helper, regions);
    }

    private void primaryRSPlacement(int regionCount, Map<HRegionInfo, ServerName> primaryRSMap, int firstRackSize, int secondRackSize, int thirdRackSize) {
        HashMap<String, Integer> rackToServerCount = new HashMap<String, Integer>();
        rackToServerCount.put("rack1", firstRackSize);
        rackToServerCount.put("rack2", secondRackSize);
        rackToServerCount.put("rack3", thirdRackSize);
        List<ServerName> servers = TestFavoredNodeAssignmentHelper.getServersFromRack(rackToServerCount);
        FavoredNodeAssignmentHelper helper = new FavoredNodeAssignmentHelper(servers, rackManager);
        helper.initialize();
        Assert.assertTrue((boolean)helper.canPlaceFavoredNodes());
        HashMap<ServerName, List<HRegionInfo>> assignmentMap = new HashMap<ServerName, List<HRegionInfo>>();
        if (primaryRSMap == null) {
            primaryRSMap = new HashMap<HRegionInfo, ServerName>();
        }
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionCount);
        for (int i = 0; i < regionCount; ++i) {
            HRegionInfo region = new HRegionInfo(TableName.valueOf("foobar"), Bytes.toBytes(i), Bytes.toBytes(i + 1));
            regions.add(region);
        }
        helper.placePrimaryRSAsRoundRobin(assignmentMap, primaryRSMap, regions);
        int regionsOnRack1 = 0;
        int regionsOnRack2 = 0;
        int regionsOnRack3 = 0;
        for (HRegionInfo region : regions) {
            if (rackManager.getRack(primaryRSMap.get(region)).equals("rack1")) {
                ++regionsOnRack1;
                continue;
            }
            if (rackManager.getRack(primaryRSMap.get(region)).equals("rack2")) {
                ++regionsOnRack2;
                continue;
            }
            if (!rackManager.getRack(primaryRSMap.get(region)).equals("rack3")) continue;
            ++regionsOnRack3;
        }
        this.checkNumRegions(regionCount, firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3, assignmentMap);
    }

    private void checkNumRegions(int regionCount, int firstRackSize, int secondRackSize, int thirdRackSize, int regionsOnRack1, int regionsOnRack2, int regionsOnRack3, Map<ServerName, List<HRegionInfo>> assignmentMap) {
        TreeMap<Integer, Integer> rackMap = new TreeMap<Integer, Integer>();
        rackMap.put(firstRackSize, 1);
        rackMap.put(secondRackSize, 2);
        rackMap.put(thirdRackSize, 3);
        TreeMap<Integer, Integer> regionMap = new TreeMap<Integer, Integer>();
        regionMap.put(regionsOnRack1, 1);
        regionMap.put(regionsOnRack2, 2);
        regionMap.put(regionsOnRack3, 3);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(firstRackSize) == regionMap.get(regionsOnRack1) ? 1 : 0) != 0);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(secondRackSize) == regionMap.get(regionsOnRack2) ? 1 : 0) != 0);
        Assert.assertTrue((String)this.printProportions(firstRackSize, secondRackSize, thirdRackSize, regionsOnRack1, regionsOnRack2, regionsOnRack3), (rackMap.get(thirdRackSize) == regionMap.get(regionsOnRack3) ? 1 : 0) != 0);
    }

    private String printProportions(int firstRackSize, int secondRackSize, int thirdRackSize, int regionsOnRack1, int regionsOnRack2, int regionsOnRack3) {
        return "The rack sizes " + firstRackSize + " " + secondRackSize + " " + thirdRackSize + " " + regionsOnRack1 + " " + regionsOnRack2 + " " + regionsOnRack3;
    }
}

