/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.TestMasterAddressTracker;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.log4j.Level;
import org.apache.hive.org.apache.log4j.Logger;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestSplitLogManager {
    private static final Log LOG = LogFactory.getLog(TestSplitLogManager.class);
    private final ServerName DUMMY_MASTER = ServerName.valueOf("dummy-master,1,1");
    private final ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
    private final MasterServices master = (MasterServices)Mockito.mock(MasterServices.class);
    private ZooKeeperWatcher zkw;
    private DummyServer ds;
    private static boolean stopped;
    private SplitLogManager slm;
    private Configuration conf;
    private int to;
    private ZooKeeperProtos.SplitLogTask.RecoveryMode mode;
    private static HBaseTestingUtility TEST_UTIL;
    static Stoppable stopper;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        this.conf = TEST_UTIL.getConfiguration();
        this.zkw = new ZooKeeperWatcher(this.conf, "split-log-manager-tests" + UUID.randomUUID().toString(), null);
        this.ds = new DummyServer(this.zkw, this.conf);
        ZKUtil.deleteChildrenRecursively(this.zkw, this.zkw.baseZNode);
        ZKUtil.createAndFailSilent(this.zkw, this.zkw.baseZNode);
        Assert.assertTrue((ZKUtil.checkExists(this.zkw, this.zkw.baseZNode) != -1 ? 1 : 0) != 0);
        LOG.debug(this.zkw.baseZNode + " created");
        ZKUtil.createAndFailSilent(this.zkw, this.zkw.splitLogZNode);
        Assert.assertTrue((ZKUtil.checkExists(this.zkw, this.zkw.splitLogZNode) != -1 ? 1 : 0) != 0);
        LOG.debug(this.zkw.splitLogZNode + " created");
        stopped = false;
        SplitLogCounters.resetCounters();
        Mockito.when((Object)this.sm.isServerOnline((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)true);
        Mockito.when((Object)this.master.getServerManager()).thenReturn((Object)this.sm);
        this.to = 12000;
        this.conf.setInt("hbase.splitlog.manager.timeout", this.to);
        this.conf.setInt("hbase.splitlog.manager.unassigned.timeout", 2 * this.to);
        this.conf.setInt("hbase.splitlog.manager.timeoutmonitor.period", 100);
        this.to += 400;
        this.mode = this.conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
    }

    @After
    public void teardown() throws IOException, KeeperException {
        stopper.stop("");
        if (this.slm != null) {
            this.slm.stop();
        }
        TEST_UTIL.shutdownMiniZKCluster();
    }

    private void waitForCounter(final AtomicLong ctr, long oldval, long newval, long timems) throws Exception {
        Expr e = new Expr(){

            @Override
            public long eval() {
                return ctr.get();
            }
        };
        this.waitForCounter(e, oldval, newval, timems);
    }

    private void waitForCounter(final Expr e, final long oldval, long newval, long timems) throws Exception {
        TEST_UTIL.waitFor(timems, 10L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return e.eval() != oldval;
            }
        });
        Assert.assertEquals((long)newval, (long)e.eval());
    }

    private String submitTaskAndWait(SplitLogManager.TaskBatch batch, String name) throws KeeperException, InterruptedException {
        String tasknode = ZKSplitLog.getEncodedNodeName(this.zkw, name);
        TestMasterAddressTracker.NodeCreationListener listener = new TestMasterAddressTracker.NodeCreationListener(this.zkw, tasknode);
        this.zkw.registerListener(listener);
        ZKUtil.watchAndCheckExists(this.zkw, tasknode);
        this.slm.enqueueSplitTask(name, batch);
        Assert.assertEquals((long)1L, (long)batch.installed);
        Assert.assertTrue((this.slm.findOrCreateOrphanTask((String)tasknode).batch == batch ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)SplitLogCounters.tot_mgr_node_create_queued.get());
        LOG.debug("waiting for task node creation");
        listener.waitForCreation();
        LOG.debug("task created");
        return tasknode;
    }

    @Test(timeout=180000L)
    public void testTaskCreation() throws Exception {
        LOG.info("TestTaskCreation - test the creation of a task in zk");
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        byte[] data = ZKUtil.getData(this.zkw, tasknode);
        SplitLogTask slt = SplitLogTask.parseFrom(data);
        LOG.info("Task node created " + slt.toString());
        Assert.assertTrue((boolean)slt.isUnassigned(this.DUMMY_MASTER));
    }

    @Test(timeout=180000L)
    public void testOrphanTaskAcquisition() throws Exception {
        LOG.info("TestOrphanTaskAcquisition");
        String tasknode = ZKSplitLog.getEncodedNodeName(this.zkw, "orphan/test/slash");
        SplitLogTask.Owned slt = new SplitLogTask.Owned(this.DUMMY_MASTER, this.mode);
        this.zkw.getRecoverableZooKeeper().create(tasknode, slt.toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        this.waitForCounter(SplitLogCounters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((boolean)task.isOrphan());
        this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        Assert.assertFalse((boolean)task.isUnassigned());
        long curt = System.currentTimeMillis();
        Assert.assertTrue((task.last_update <= curt && task.last_update > curt - 1000L ? 1 : 0) != 0);
        LOG.info("waiting for manager to resubmit the orphan task");
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        Assert.assertTrue((boolean)task.isUnassigned());
        this.waitForCounter(SplitLogCounters.tot_mgr_rescan, 0L, 1L, (long)(this.to + this.to / 2));
    }

    @Test(timeout=180000L)
    public void testUnassignedOrphan() throws Exception {
        LOG.info("TestUnassignedOrphan - an unassigned task is resubmitted at startup");
        String tasknode = ZKSplitLog.getEncodedNodeName(this.zkw, "orphan/test/slash");
        SplitLogTask.Unassigned slt = new SplitLogTask.Unassigned(this.DUMMY_MASTER, this.mode);
        this.zkw.getRecoverableZooKeeper().create(tasknode, slt.toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int version = ZKUtil.checkExists(this.zkw, tasknode);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        this.waitForCounter(SplitLogCounters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((boolean)task.isOrphan());
        Assert.assertTrue((boolean)task.isUnassigned());
        this.waitForCounter(SplitLogCounters.tot_mgr_rescan, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.Task task2 = this.slm.findOrCreateOrphanTask(tasknode);
        Assert.assertTrue((task == task2 ? 1 : 0) != 0);
        LOG.debug("task = " + task);
        Assert.assertEquals((long)1L, (long)SplitLogCounters.tot_mgr_resubmit.get());
        Assert.assertEquals((long)1L, (long)task.incarnation);
        Assert.assertEquals((long)0L, (long)task.unforcedResubmits.get());
        Assert.assertTrue((boolean)task.isOrphan());
        Assert.assertTrue((boolean)task.isUnassigned());
        Assert.assertTrue((ZKUtil.checkExists(this.zkw, tasknode) > version ? 1 : 0) != 0);
    }

    @Test(timeout=180000L)
    public void testMultipleResubmits() throws Exception {
        LOG.info("TestMultipleResbmits - no indefinite resubmissions");
        this.conf.setInt("hbase.splitlog.max.resubmit", 2);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists(this.zkw, tasknode);
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        ServerName worker2 = ServerName.valueOf("worker2,1,1");
        ServerName worker3 = ServerName.valueOf("worker3,1,1");
        SplitLogTask.Owned slt = new SplitLogTask.Owned(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        int version1 = ZKUtil.checkExists(this.zkw, tasknode);
        Assert.assertTrue((version1 > version ? 1 : 0) != 0);
        slt = new SplitLogTask.Owned(worker2, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 1L, 2L, (long)(this.to / 2));
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 1L, 2L, (long)(this.to + this.to / 2));
        int version2 = ZKUtil.checkExists(this.zkw, tasknode);
        Assert.assertTrue((version2 > version1 ? 1 : 0) != 0);
        slt = new SplitLogTask.Owned(worker3, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 2L, 3L, (long)(this.to / 2));
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit_threshold_reached, 0L, 1L, (long)(this.to + this.to / 2));
        Thread.sleep(this.to + this.to / 2);
        Assert.assertEquals((long)2L, (long)(SplitLogCounters.tot_mgr_resubmit.get() - SplitLogCounters.tot_mgr_resubmit_force.get()));
    }

    @Test(timeout=180000L)
    public void testRescanCleanup() throws Exception {
        LOG.info("TestRescanCleanup - ensure RESCAN nodes are cleaned up");
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists(this.zkw, tasknode);
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask slt = new SplitLogTask.Owned(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        this.waitForCounter(new Expr(){

            @Override
            public long eval() {
                return SplitLogCounters.tot_mgr_resubmit.get() + SplitLogCounters.tot_mgr_resubmit_failed.get();
            }
        }, 0L, 1L, 300000L);
        Assert.assertEquals((String)"Could not run test. Lost ZK connection?", (long)0L, (long)SplitLogCounters.tot_mgr_resubmit_failed.get());
        int version1 = ZKUtil.checkExists(this.zkw, tasknode);
        Assert.assertTrue((version1 > version ? 1 : 0) != 0);
        byte[] taskstate = ZKUtil.getData(this.zkw, tasknode);
        slt = SplitLogTask.parseFrom(taskstate);
        Assert.assertTrue((boolean)slt.isUnassigned(this.DUMMY_MASTER));
        this.waitForCounter(SplitLogCounters.tot_mgr_rescan_deleted, 0L, 1L, (long)(this.to / 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testTaskDone() throws Exception {
        LOG.info("TestTaskDone - cleanup task node once in DONE state");
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask.Done slt = new SplitLogTask.Done(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        SplitLogManager.TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.installed != batch.done) {
                batch.wait();
            }
        }
        this.waitForCounter(SplitLogCounters.tot_mgr_task_deleted, 0L, 1L, (long)(this.to / 2));
        Assert.assertTrue((ZKUtil.checkExists(this.zkw, tasknode) == -1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testTaskErr() throws Exception {
        LOG.info("TestTaskErr - cleanup task node once in ERR state");
        this.conf.setInt("hbase.splitlog.max.resubmit", 0);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask.Err slt = new SplitLogTask.Err(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        SplitLogManager.TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.installed != batch.error) {
                batch.wait();
            }
        }
        this.waitForCounter(SplitLogCounters.tot_mgr_task_deleted, 0L, 1L, (long)(this.to / 2));
        Assert.assertTrue((ZKUtil.checkExists(this.zkw, tasknode) == -1 ? 1 : 0) != 0);
        this.conf.setInt("hbase.splitlog.max.resubmit", 3);
    }

    @Test(timeout=180000L)
    public void testTaskResigned() throws Exception {
        LOG.info("TestTaskResigned - resubmit task node once in RESIGNED state");
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)0L);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)0L);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)0L);
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)0L);
        SplitLogTask slt = new SplitLogTask.Resigned(worker1, this.mode);
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)0L);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        int version = ZKUtil.checkExists(this.zkw, tasknode);
        if (SplitLogCounters.tot_mgr_resubmit.get() == 0L) {
            this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 0L, 1L, (long)(this.to / 2));
        }
        Assert.assertEquals((long)SplitLogCounters.tot_mgr_resubmit.get(), (long)1L);
        byte[] taskstate = ZKUtil.getData(this.zkw, tasknode);
        slt = SplitLogTask.parseFrom(taskstate);
        Assert.assertTrue((boolean)slt.isUnassigned(this.DUMMY_MASTER));
    }

    @Test(timeout=180000L)
    public void testUnassignedTimeout() throws Exception {
        LOG.info("TestUnassignedTimeout - iff all tasks are unassigned then resubmit");
        String tasknode1 = ZKSplitLog.getEncodedNodeName(this.zkw, "orphan/1");
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask.Owned slt = new SplitLogTask.Owned(worker1, this.mode);
        this.zkw.getRecoverableZooKeeper().create(tasknode1, slt.toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        this.waitForCounter(SplitLogCounters.tot_mgr_orphan_task_acquired, 0L, 1L, (long)(this.to / 2));
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        this.submitTaskAndWait(batch, "foo/1");
        for (int i = 0; i < 3 * this.to / 100; ++i) {
            Thread.sleep(100L);
            ServerName worker2 = ServerName.valueOf("worker1,1,1");
            slt = new SplitLogTask.Owned(worker2, this.mode);
            ZKUtil.setData(this.zkw, tasknode1, slt.toByteArray());
        }
        LOG.info("waiting for manager to resubmit the orphan task");
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        this.waitForCounter(SplitLogCounters.tot_mgr_resubmit_unassigned, 0L, 1L, (long)(2 * this.to + this.to / 2));
    }

    @Test(timeout=180000L)
    public void testDeadWorker() throws Exception {
        int version1;
        LOG.info("testDeadWorker");
        this.conf.setLong("hbase.splitlog.max.resubmit", 0L);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        int version = ZKUtil.checkExists(this.zkw, tasknode);
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask slt = new SplitLogTask.Owned(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        if (SplitLogCounters.tot_mgr_heartbeat.get() == 0L) {
            this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        }
        this.slm.handleDeadWorker(worker1);
        if (SplitLogCounters.tot_mgr_resubmit.get() == 0L) {
            this.waitForCounter(SplitLogCounters.tot_mgr_resubmit, 0L, 1L, (long)(this.to + this.to / 2));
        }
        if (SplitLogCounters.tot_mgr_resubmit_dead_server_task.get() == 0L) {
            this.waitForCounter(SplitLogCounters.tot_mgr_resubmit_dead_server_task, 0L, 1L, (long)(this.to + this.to / 2));
        }
        Assert.assertTrue(((version1 = ZKUtil.checkExists(this.zkw, tasknode)) > version ? 1 : 0) != 0);
        byte[] taskstate = ZKUtil.getData(this.zkw, tasknode);
        slt = SplitLogTask.parseFrom(taskstate);
        Assert.assertTrue((boolean)slt.isUnassigned(this.DUMMY_MASTER));
    }

    @Test(timeout=180000L)
    public void testWorkerCrash() throws Exception {
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        SplitLogManager.TaskBatch batch = new SplitLogManager.TaskBatch();
        String tasknode = this.submitTaskAndWait(batch, "foo/1");
        ServerName worker1 = ServerName.valueOf("worker1,1,1");
        SplitLogTask.Owned slt = new SplitLogTask.Owned(worker1, this.mode);
        ZKUtil.setData(this.zkw, tasknode, slt.toByteArray());
        if (SplitLogCounters.tot_mgr_heartbeat.get() == 0L) {
            this.waitForCounter(SplitLogCounters.tot_mgr_heartbeat, 0L, 1L, (long)(this.to / 2));
        }
        Assert.assertEquals((long)0L, (long)SplitLogCounters.tot_mgr_resubmit.get());
        Mockito.when((Object)this.sm.isServerOnline(worker1)).thenReturn((Object)false);
        Thread.sleep(1300L);
        Assert.assertEquals((long)1L, (long)SplitLogCounters.tot_mgr_resubmit.get());
    }

    @Test(timeout=180000L)
    public void testEmptyLogDir() throws Exception {
        LOG.info("testEmptyLogDir");
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path emptyLogDirPath = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        fs.mkdirs(emptyLogDirPath);
        this.slm.splitLogDistributed(emptyLogDirPath);
        Assert.assertFalse((boolean)fs.exists(emptyLogDirPath));
    }

    @Test(timeout=60000L)
    public void testLogFilesAreArchived() throws Exception {
        LOG.info("testLogFilesAreArchived");
        final SplitLogManager slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path dir = TEST_UTIL.getDataTestDirOnTestFS("testLogFilesAreArchived");
        this.conf.set("hbase.rootdir", dir.toString());
        Path logDirPath = new Path(dir, UUID.randomUUID().toString());
        fs.mkdirs(logDirPath);
        String logFile = ServerName.valueOf("foo", 1, 1L).toString();
        fs.create(new Path(logDirPath, logFile)).close();
        new Thread(){

            @Override
            public void run() {
                boolean done = false;
                while (!done) {
                    for (Map.Entry entry : slm.getTasks().entrySet()) {
                        ServerName worker1 = ServerName.valueOf("worker1,1,1");
                        SplitLogTask.Done slt = new SplitLogTask.Done(worker1, ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING);
                        boolean encounteredZKException = false;
                        try {
                            ZKUtil.setData(TestSplitLogManager.this.zkw, (String)entry.getKey(), slt.toByteArray());
                        }
                        catch (KeeperException e) {
                            LOG.warn((Object)e);
                            encounteredZKException = true;
                        }
                        if (encounteredZKException) continue;
                        done = true;
                    }
                }
            }
        }.start();
        slm.splitLogDistributed(logDirPath);
        Assert.assertFalse((boolean)fs.exists(logDirPath));
    }

    @Test(timeout=300000L)
    public void testRecoveryRegionRemovedFromZK() throws Exception {
        LOG.info("testRecoveryRegionRemovedFromZK");
        this.conf.setBoolean("hbase.master.distributed.log.replay", false);
        String nodePath = ZKUtil.joinZNode(this.zkw.recoveringRegionsZNode, HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
        ZKUtil.createSetData(this.zkw, nodePath, ZKUtil.positionToByteArray(0L));
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        this.slm.removeStaleRecoveringRegions(null);
        List<String> recoveringRegions = this.zkw.getRecoverableZooKeeper().getChildren(this.zkw.recoveringRegionsZNode, false);
        Assert.assertTrue((String)"Recovery regions isn't cleaned", (boolean)recoveringRegions.isEmpty());
    }

    @Test(timeout=60000L)
    public void testGetPreviousRecoveryMode() throws Exception {
        LOG.info("testGetPreviousRecoveryMode");
        SplitLogCounters.resetCounters();
        this.conf.setBoolean("hbase.master.distributed.log.replay", true);
        this.zkw.getRecoverableZooKeeper().create(ZKSplitLog.getEncodedNodeName(this.zkw, "testRecovery"), new SplitLogTask.Unassigned(ServerName.valueOf("mgr,1,1"), ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING).toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.slm = new SplitLogManager(this.ds, this.conf, stopper, this.master, this.DUMMY_MASTER);
        LOG.info("Mode1=" + (Object)((Object)this.slm.getRecoveryMode()));
        Assert.assertTrue((boolean)this.slm.isLogSplitting());
        this.zkw.getRecoverableZooKeeper().delete(ZKSplitLog.getEncodedNodeName(this.zkw, "testRecovery"), -1);
        LOG.info("Mode2=" + (Object)((Object)this.slm.getRecoveryMode()));
        this.slm.setRecoveryMode(false);
        LOG.info("Mode3=" + (Object)((Object)this.slm.getRecoveryMode()));
        Assert.assertTrue((String)("Mode4=" + (Object)((Object)this.slm.getRecoveryMode())), (boolean)this.slm.isLogReplaying());
    }

    static {
        Logger.getLogger("org.apache.hadoop.hbase").setLevel(Level.DEBUG);
        stopped = false;
        stopper = new Stoppable(){

            @Override
            public void stop(String why) {
                stopped = true;
            }

            @Override
            public boolean isStopped() {
                return stopped;
            }
        };
    }

    private static interface Expr {
        public long eval();
    }

    class DummyServer
    implements Server {
        private ZooKeeperWatcher zkw;
        private Configuration conf;
        private CoordinatedStateManager cm;

        public DummyServer(ZooKeeperWatcher zkw, Configuration conf) {
            this.zkw = zkw;
            this.conf = conf;
            this.cm = CoordinatedStateManagerFactory.getCoordinatedStateManager(conf);
            this.cm.initialize(this);
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return this.zkw;
        }

        @Override
        public ServerName getServerName() {
            return null;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return this.cm;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

