/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestRestartCluster {
    private static final Log LOG = LogFactory.getLog(TestRestartCluster.class);
    private HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] TABLENAME = Bytes.toBytes("master_transitions");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("a")};
    private static final TableName[] TABLES = new TableName[]{TableName.valueOf("restartTableOne"), TableName.valueOf("restartTableTwo"), TableName.valueOf("restartTableThree")};
    private static final byte[] FAMILY = Bytes.toBytes("family");

    @After
    public void tearDown() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    @Test(timeout=300000L)
    public void testRestartClusterAfterKill() throws Exception {
        this.UTIL.getConfiguration().setBoolean("hbase.assignment.usezk", true);
        this.UTIL.startMiniZKCluster();
        ZooKeeperWatcher zooKeeper = new ZooKeeperWatcher(this.UTIL.getConfiguration(), "cluster1", null, true);
        String unassignedZNode = zooKeeper.assignmentZNode;
        ZKUtil.createAndFailSilent(zooKeeper, unassignedZNode);
        ServerName sn = ServerName.valueOf("master", 1, System.currentTimeMillis());
        ZKAssign.createNodeOffline(zooKeeper, HRegionInfo.FIRST_META_REGIONINFO, sn);
        LOG.debug("Created UNASSIGNED zNode for ROOT and hbase:meta regions in state " + (Object)((Object)EventType.M_ZK_REGION_OFFLINE));
        LOG.info("Starting HBase cluster...");
        this.UTIL.startMiniCluster(2);
        this.UTIL.createTable(TABLENAME, FAMILIES);
        LOG.info("Created a table, waiting for table to be available...");
        this.UTIL.waitTableAvailable(TABLENAME, 60000L);
        LOG.info("Master deleted unassigned region and started up successfully.");
    }

    @Test(timeout=300000L)
    public void testClusterRestart() throws Exception {
        this.UTIL.startMiniCluster(3);
        Connection connection = this.UTIL.getConnection();
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep(1L);
        }
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        List<HRegionInfo> allRegions = MetaScanner.listAllRegions(this.UTIL.getConfiguration(), connection, true);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nShutting down cluster");
        this.UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time");
        this.UTIL.restartHBaseCluster(3);
        allRegions = MetaScanner.listAllRegions(new Configuration(this.UTIL.getConfiguration()), connection, true);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nWaiting for tables to be available");
        for (TableName TABLE : TABLES) {
            try {
                this.UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info("Table already exists as expected");
            }
            this.UTIL.waitTableAvailable(TABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testRetainAssignmentOnRestart() throws Exception {
        boolean found;
        this.UTIL.startMiniCluster(2);
        while (!this.UTIL.getMiniHBaseCluster().getMaster().isInitialized()) {
            Threads.sleep(1L);
        }
        this.UTIL.getMiniHBaseCluster().getMaster().getMasterRpcServices().synchronousBalanceSwitch(false);
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        HMaster master = this.UTIL.getMiniHBaseCluster().getMaster();
        AssignmentManager am = master.getAssignmentManager();
        am.waitUntilNoRegionsInTransition(120000L);
        SnapshotOfRegionAssignmentFromMeta snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map<HRegionInfo, ServerName> regionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        MiniHBaseCluster cluster = this.UTIL.getHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> threads = cluster.getLiveRegionServerThreads();
        Assert.assertEquals((long)2L, (long)threads.size());
        int[] rsPorts = new int[2];
        for (int i = 0; i < 2; ++i) {
            rsPorts[i] = threads.get(i).getRegionServer().getServerName().getPort();
        }
        for (ServerName serverName : regionToRegionServerMap.values()) {
            found = false;
            for (int k = 0; k < 2 && !found; ++k) {
                found = serverName.getPort() == rsPorts[k];
            }
            Assert.assertTrue((boolean)found);
        }
        LOG.info("\n\nShutting down HBase cluster");
        cluster.shutdown();
        cluster.waitUntilShutDown();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time with the same ports");
        try {
            cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 2);
            master = cluster.startMaster().getMaster();
            for (int i = 0; i < 2; ++i) {
                cluster.getConf().setInt("hbase.regionserver.port", rsPorts[i]);
                cluster.startRegionServer();
            }
        }
        finally {
            cluster.getConf().setInt("hbase.regionserver.port", 0);
            cluster.getConf().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        }
        List<ServerName> localServers = master.getServerManager().getOnlineServersList();
        Assert.assertEquals((long)2L, (long)localServers.size());
        for (int i = 0; i < 2; ++i) {
            found = false;
            for (ServerName serverName : localServers) {
                if (serverName.getPort() != rsPorts[i]) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        int expectedRegions = regionToRegionServerMap.size() + 1;
        while (!master.isInitialized() || regionStates.getRegionAssignments().size() != expectedRegions) {
            Threads.sleep(100L);
        }
        snapshot = new SnapshotOfRegionAssignmentFromMeta(master.getConnection());
        snapshot.initialize();
        Map<HRegionInfo, ServerName> newRegionToRegionServerMap = snapshot.getRegionToRegionServerMap();
        Assert.assertEquals((long)regionToRegionServerMap.size(), (long)newRegionToRegionServerMap.size());
        for (Map.Entry<HRegionInfo, ServerName> entry : newRegionToRegionServerMap.entrySet()) {
            if (TableName.NAMESPACE_TABLE_NAME.equals(entry.getKey().getTable())) continue;
            ServerName oldServer = regionToRegionServerMap.get(entry.getKey());
            ServerName currentServer = entry.getValue();
            Assert.assertEquals((Object)oldServer.getHostAndPort(), (Object)currentServer.getHostAndPort());
            Assert.assertNotEquals((long)oldServer.getStartcode(), (long)currentServer.getStartcode());
        }
    }
}

