/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.master.RegionStateStore;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionStates {
    @Test
    public void testWeDontReturnDrainingServersForOurBalancePlans() throws Exception {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getServerName()).thenReturn((Object)ServerName.valueOf("master,1,1"));
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)configuration);
        TableStateManager tsm = (TableStateManager)Mockito.mock(TableStateManager.class);
        ServerManager sm = (ServerManager)Mockito.mock(ServerManager.class);
        Mockito.when((Object)sm.isServerOnline((ServerName)Matchers.isA(ServerName.class))).thenReturn((Object)true);
        RegionStateStore rss = (RegionStateStore)Mockito.mock(RegionStateStore.class);
        RegionStates regionStates = new RegionStates(server, tsm, sm, rss);
        ServerName one = this.mockServer("one", 1);
        ServerName two = this.mockServer("two", 1);
        ServerName three = this.mockServer("three", 1);
        Mockito.when(sm.getDrainingServersList()).thenReturn(Arrays.asList(three));
        regionStates.regionOnline(this.createFakeRegion(), one);
        regionStates.regionOnline(this.createFakeRegion(), two);
        regionStates.regionOnline(this.createFakeRegion(), three);
        Map<TableName, Map<ServerName, List<HRegionInfo>>> result = regionStates.getAssignmentsByTable();
        for (Map<ServerName, List<HRegionInfo>> map : result.values()) {
            Assert.assertFalse((boolean)map.keySet().contains(three));
        }
    }

    private HRegionInfo createFakeRegion() {
        HRegionInfo info = (HRegionInfo)Mockito.mock(HRegionInfo.class);
        Mockito.when((Object)info.getEncodedName()).thenReturn((Object)UUID.randomUUID().toString());
        return info;
    }

    private ServerName mockServer(String fakeHost, int fakePort) {
        ServerName serverName = (ServerName)Mockito.mock(ServerName.class);
        Mockito.when((Object)serverName.getHostname()).thenReturn((Object)fakeHost);
        Mockito.when((Object)serverName.getPort()).thenReturn((Object)fakePort);
        return serverName;
    }
}

