/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestProcedureConf {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcedureConfEnable() throws Exception {
        TableName tableName = TableName.valueOf("testProcedureConfEnable");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        MiniHBaseCluster cluster = null;
        try {
            TEST_UTIL.startMiniCluster();
            cluster = TEST_UTIL.getHBaseCluster();
            HMaster m = cluster.getMaster();
            long procid = m.createTable(htd, null);
            Assert.assertTrue((procid > 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                TEST_UTIL.shutdownMiniCluster();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcedureConfDisable() throws Exception {
        TableName tableName = TableName.valueOf("testProcedureConfDisable");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        MiniHBaseCluster cluster = null;
        try {
            TEST_UTIL.getConfiguration().set("hbase.master.procedure.tableddl", "disabled");
            TEST_UTIL.startMiniCluster();
            cluster = TEST_UTIL.getHBaseCluster();
            HMaster m = cluster.getMaster();
            long procid = m.createTable(htd, null);
            Assert.assertTrue((procid < 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                TEST_UTIL.shutdownMiniCluster();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProcedureConfUnused() throws Exception {
        TableName tableName = TableName.valueOf("testProcedureConfUnused");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        MiniHBaseCluster cluster = null;
        try {
            TEST_UTIL.getConfiguration().set("hbase.master.procedure.tableddl", "unused");
            TEST_UTIL.startMiniCluster();
            cluster = TEST_UTIL.getHBaseCluster();
            HMaster m = cluster.getMaster();
            long procid = m.createTable(htd, null);
            Assert.assertTrue((procid < 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                TEST_UTIL.shutdownMiniCluster();
            }
        }
    }
}

