/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestOpenedRegionHandler {
    private static final Log LOG = LogFactory.getLog(TestOpenedRegionHandler.class);
    private HBaseTestingUtility TEST_UTIL;
    private final int NUM_MASTERS = 1;
    private final int NUM_RS = 1;
    private Configuration conf;
    private Configuration resetConf;
    private ZooKeeperWatcher zkw;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.setBoolean("hbase.assignment.usezk", true);
        this.TEST_UTIL = HBaseTestingUtility.createLocalHTU(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
        this.TEST_UTIL = new HBaseTestingUtility(this.resetConf);
    }

    @Test
    public void testOpenedRegionHandlerOnMasterRestart() throws Exception {
        this.log("Starting cluster");
        this.conf = HBaseConfiguration.create();
        this.conf.setBoolean("hbase.assignment.usezk", true);
        this.resetConf = this.conf;
        this.TEST_UTIL = new HBaseTestingUtility(this.conf);
        this.TEST_UTIL.startMiniCluster(1, 1);
        String tableName = "testOpenedRegionHandlerOnMasterRestart";
        MiniHBaseCluster cluster = this.createRegions(tableName);
        this.abortMaster(cluster);
        HRegionServer regionServer = cluster.getRegionServer(0);
        Region region = this.getRegionBeingServed(cluster, regionServer);
        this.zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(this.TEST_UTIL, region, regionServer.getServerName());
        this.log("Starting up a new master");
        cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(this.zkw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches() throws Exception {
        HRegion region = null;
        try {
            int testIndex = 0;
            this.TEST_UTIL.startMiniZKCluster();
            MockServer server = new MockServer(this.TEST_UTIL);
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches"));
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), Bytes.toBytes(testIndex), Bytes.toBytes(testIndex + 1));
            region = HRegion.createHRegion(hri, this.TEST_UTIL.getDataTestDir(), this.TEST_UTIL.getConfiguration(), htd);
            Assert.assertNotNull((Object)region);
            AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
            RegionStates rsm = (RegionStates)Mockito.mock(RegionStates.class);
            ((AssignmentManager)Mockito.doReturn((Object)rsm).when((Object)am)).getRegionStates();
            Mockito.when((Object)rsm.isRegionInTransition(hri)).thenReturn((Object)false);
            Mockito.when((Object)rsm.getRegionState(hri)).thenReturn((Object)new RegionState(region.getRegionInfo(), RegionState.State.OPEN, System.currentTimeMillis(), server.getServerName()));
            this.zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(this.TEST_UTIL, region, server.getServerName());
            Mockito.when((Object)am.getTableStateManager()).thenReturn((Object)new ZKTableStateManager(this.zkw));
            Stat stat = new Stat();
            String nodeName = ZKAssign.getNodeName(this.zkw, region.getRegionInfo().getEncodedName());
            ZKUtil.getDataAndWatch(this.zkw, nodeName, stat);
            ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
            ((BaseCoordinatedStateManager)csm).initialize(server);
            csm.start();
            OpenRegionCoordination orc = ((BaseCoordinatedStateManager)csm).getOpenRegionCoordination();
            ZkOpenRegionCoordination.ZkOpenRegionDetails zkOrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
            zkOrd.setServerName(server.getServerName());
            zkOrd.setVersion(stat.getVersion());
            OpenedRegionHandler handler = new OpenedRegionHandler(server, am, region.getRegionInfo(), orc, zkOrd);
            ZKAssign.transitionNode(this.zkw, region.getRegionInfo(), server.getServerName(), EventType.RS_ZK_REGION_OPENED, EventType.RS_ZK_REGION_OPENED, stat.getVersion());
            boolean expectedException = false;
            try {
                handler.process();
            }
            catch (Exception e) {
                expectedException = true;
            }
            Assert.assertFalse((String)"The process method should not throw any exception.", (boolean)expectedException);
            List<String> znodes = ZKUtil.listChildrenAndWatchForNewChildren(this.zkw, this.zkw.assignmentZNode);
            String regionName = znodes.get(0);
            Assert.assertEquals((String)"The region should not be opened successfully.", (Object)regionName, (Object)region.getRegionInfo().getEncodedName());
        }
        catch (Throwable throwable) {
            HRegion.closeHRegion(region);
            this.TEST_UTIL.shutdownMiniZKCluster();
            throw throwable;
        }
        HRegion.closeHRegion(region);
        this.TEST_UTIL.shutdownMiniZKCluster();
    }

    private MiniHBaseCluster createRegions(String tableName) throws InterruptedException, ZooKeeperConnectionException, IOException, KeeperException {
        MiniHBaseCluster cluster = this.TEST_UTIL.getHBaseCluster();
        this.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        this.zkw = new ZooKeeperWatcher(this.conf, "testOpenedRegionHandler", null);
        byte[] table = Bytes.toBytes(tableName);
        byte[] family = Bytes.toBytes("family");
        this.TEST_UTIL.createTable(table, family);
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT(this.zkw);
        return cluster;
    }

    private void abortMaster(MiniHBaseCluster cluster) {
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
    }

    private Region getRegionBeingServed(MiniHBaseCluster cluster, HRegionServer regionServer) {
        Collection<Region> onlineRegionsLocalContext = regionServer.getOnlineRegionsLocalContext();
        Iterator<Region> iterator = onlineRegionsLocalContext.iterator();
        Region region = null;
        while (iterator.hasNext() && (region = iterator.next()).getRegionInfo().isMetaTable()) {
        }
        return region;
    }

    private void log(String msg) {
        LOG.debug("\n\nTRR: " + msg + "\n");
    }
}

