/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMetaShutdownHandler {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final Configuration conf = TEST_UTIL.getConfiguration();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1, 3, null, null, MyRegionServer.class);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testExpireMetaRegionServer() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        RegionStates regionStates = master.getAssignmentManager().getRegionStates();
        ServerName metaServerName = regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO);
        if (master.getServerName().equals(metaServerName) || metaServerName == null || !metaServerName.equals(cluster.getServerHoldingMeta())) {
            metaServerName = cluster.getLiveRegionServerThreads().get(0).getRegionServer().getServerName();
            master.move(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), Bytes.toBytes(metaServerName.getServerName()));
            master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
        }
        RegionState metaState = MetaTableLocator.getMetaRegionState(master.getZooKeeper());
        Assert.assertEquals((String)"Meta should be not in transition", (Object)((Object)metaState.getState()), (Object)((Object)RegionState.State.OPEN));
        Assert.assertNotEquals((String)"Meta should be moved off master", (Object)metaServerName, (Object)master.getServerName());
        String rsEphemeralNodePath = ZKUtil.joinZNode(master.getZooKeeper().rsZNode, metaServerName.toString());
        ZKUtil.deleteNode(master.getZooKeeper(), rsEphemeralNodePath);
        final ServerManager serverManager = master.getServerManager();
        final ServerName priorMetaServerName = metaServerName;
        TEST_UTIL.waitFor(120000L, 200L, new Waiter.Predicate<Exception>(){

            @Override
            public boolean evaluate() throws Exception {
                return !serverManager.isServerOnline(priorMetaServerName) && !serverManager.areDeadServersInProgress();
            }
        });
        Assert.assertTrue((String)"Meta should be assigned", (boolean)regionStates.isRegionOnline(HRegionInfo.FIRST_META_REGIONINFO));
        metaState = MetaTableLocator.getMetaRegionState(master.getZooKeeper());
        Assert.assertEquals((String)"Meta should be not in transition", (Object)((Object)metaState.getState()), (Object)((Object)RegionState.State.OPEN));
        Assert.assertEquals((String)"Meta should be assigned", (Object)metaState.getServerName(), (Object)regionStates.getRegionServerOfRegion(HRegionInfo.FIRST_META_REGIONINFO));
        Assert.assertNotEquals((String)"Meta should be assigned on a different server", (Object)metaState.getServerName(), (Object)metaServerName);
    }

    public static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyRegionServer(Configuration conf, CoordinatedStateManager cp) throws IOException, KeeperException, InterruptedException {
            super(conf, cp);
        }

        @Override
        public void abort(String reason, Throwable cause) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                return;
            }
            super.abort(reason, cause);
        }
    }
}

