/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMasterTransitions {
    private static final Log LOG = LogFactory.getLog(TestMasterTransitions.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLENAME = TableName.valueOf("master_transitions");
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("a"), Bytes.toBytes("b"), Bytes.toBytes("c")};

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.createMultiRegionTable(TABLENAME, FAMILIES);
        HTable t = (HTable)TEST_UTIL.getConnection().getTable(TABLENAME);
        int countOfRegions = -1;
        try (RegionLocator r = t.getRegionLocator();){
            countOfRegions = r.getStartKeys().length;
        }
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLENAME);
        TestMasterTransitions.addToEachStartKey(countOfRegions);
        t.close();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Ignore
    @Test(timeout=300000L)
    public void testRegionCloseWhenNoMetaHBase2428() throws Exception {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testAddingServerBeforeOldIsDead2413() throws IOException {
    }

    @Ignore
    @Test(timeout=300000L)
    public void testKillRSWithOpeningRegion2482() throws Exception {
    }

    private static int addToEachStartKey(int expected) throws IOException {
        HRegionInfo hri;
        HTable t = new HTable(TEST_UTIL.getConfiguration(), TABLENAME);
        HTable meta = new HTable(TEST_UTIL.getConfiguration(), TableName.META_TABLE_NAME);
        int rows = 0;
        Scan scan = new Scan();
        scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        ResultScanner s = meta.getScanner(scan);
        Result r = null;
        while ((r = s.next()) != null && (hri = HRegionInfo.getHRegionInfo(r)) != null) {
            if (!hri.getTable().equals(TABLENAME) || !hri.getTable().equals(TABLENAME)) continue;
            byte[] row = TestMasterTransitions.getStartKey(hri);
            Put p = new Put(row);
            p.setDurability(Durability.SKIP_WAL);
            p.add(TestMasterTransitions.getTestFamily(), TestMasterTransitions.getTestQualifier(), row);
            t.put(p);
            ++rows;
        }
        s.close();
        Assert.assertEquals((long)expected, (long)rows);
        t.close();
        meta.close();
        return rows;
    }

    private static byte[] getStartKey(HRegionInfo hri) {
        return Bytes.equals(HConstants.EMPTY_START_ROW, hri.getStartKey()) ? Bytes.toBytes("aaa") : hri.getStartKey();
    }

    private static byte[] getTestFamily() {
        return FAMILIES[0];
    }

    private static byte[] getTestQualifier() {
        return TestMasterTransitions.getTestFamily();
    }
}

