/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaMockingUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.SplitLogManagerCoordination;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.Triple;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestCatalogJanitor {
    private static final Log LOG = LogFactory.getLog(TestCatalogJanitor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanParent() throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        try {
            MockMasterServices services = new MockMasterServices(server);
            CatalogJanitor janitor = new CatalogJanitor(server, services);
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("table"));
            htd.addFamily(new HColumnDescriptor("f"));
            HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("eee"));
            HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("ccc"));
            HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), Bytes.toBytes("eee"));
            Result r = this.createResult(parent, splita, splitb);
            Path rootdir = services.getMasterFileSystem().getRootDir();
            Path tabledir = FSUtils.getTableDir(rootdir, htd.getTableName());
            Path storedir = HStore.getStoreHomedir(tabledir, splita, htd.getColumnFamilies()[0].getName());
            Reference ref = Reference.createTopReference(Bytes.toBytes("ccc"));
            long now = System.currentTimeMillis();
            Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
            FileSystem fs = services.getMasterFileSystem().getFileSystem();
            Path path = ref.write(fs, p);
            Assert.assertTrue((boolean)fs.exists(path));
            Assert.assertFalse((boolean)janitor.cleanParent(parent, r));
            Assert.assertTrue((boolean)fs.delete(p, true));
            Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        }
        finally {
            server.stop("shutdown");
        }
    }

    @Test
    public void testParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testParentCleanedEvenIfDaughterGoneFirst", Bytes.toBytes("eee"));
    }

    @Test
    public void testLastParentCleanedEvenIfDaughterGoneFirst() throws IOException, InterruptedException {
        this.parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst("testLastParentCleanedEvenIfDaughterGoneFirst", new byte[0]);
    }

    private void parentWithSpecifiedEndKeyCleanedEvenIfDaughterGoneFirst(String rootDir, byte[] lastEndKey) throws IOException, InterruptedException {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, rootDir);
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor(server, services);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("ccc"));
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("bbb"));
        HRegionInfo splitab = new HRegionInfo(htd.getTableName(), Bytes.toBytes("bbb"), Bytes.toBytes("ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), lastEndKey);
        Thread.sleep(1001L);
        HRegionInfo splitba = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), Bytes.toBytes("ddd"));
        HRegionInfo splitbb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ddd"), lastEndKey);
        TreeMap<HRegionInfo, Result> regions = new TreeMap<HRegionInfo, Result>(new CatalogJanitor.SplitParentFirstComparator());
        regions.put(parent, this.createResult(parent, splita, splitb));
        regions.put(splitb, this.createResult(splitb, splitba, splitbb));
        regions.put(splita, this.createResult(splita, splitaa, splitab));
        int index = 0;
        for (Map.Entry e : regions.entrySet()) {
            if (index == 0) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(parent.getEncodedName()));
            } else if (index == 1) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splita.getEncodedName()));
            } else if (index == 2) {
                Assert.assertTrue((boolean)((HRegionInfo)e.getKey()).getEncodedName().equals(splitb.getEncodedName()));
            }
            ++index;
        }
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes("ccc"), false);
        Assert.assertFalse((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        Assert.assertTrue((boolean)janitor.cleanParent(splitb, (Result)regions.get(splitb)));
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Path splitaaRef = this.createReferences(services, htd, splita, splitaa, Bytes.toBytes("bbb"), false);
        Path splitabRef = this.createReferences(services, htd, splita, splitab, Bytes.toBytes("bbb"), true);
        Assert.assertFalse((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)fs.delete(splitaaRef, true));
        Assert.assertTrue((boolean)fs.delete(splitabRef, true));
        Assert.assertTrue((boolean)janitor.cleanParent(splita, (Result)regions.get(splita)));
        Assert.assertTrue((boolean)janitor.cleanParent(parent, (Result)regions.get(parent)));
        services.stop("test finished");
        janitor.cancel(true);
    }

    @Test
    public void testScanDoesNotCleanRegionsWithExistingParents() throws Exception {
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testScanDoesNotCleanRegionsWithExistingParents");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), new byte[0], true);
        Thread.sleep(1001L);
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("ccc"), true);
        Thread.sleep(1001L);
        HRegionInfo splitaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("bbb"), false);
        HRegionInfo splitab = new HRegionInfo(htd.getTableName(), Bytes.toBytes("bbb"), Bytes.toBytes("ccc"), false);
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), new byte[0]);
        Thread.sleep(1001L);
        TreeMap<HRegionInfo, Result> splitParents = new TreeMap<HRegionInfo, Result>(new CatalogJanitor.SplitParentFirstComparator());
        splitParents.put(parent, this.createResult(parent, splita, splitb));
        splita.setOffline(true);
        splitParents.put(splita, this.createResult(splita, splitaa, splitab));
        TreeMap mergedRegions = new TreeMap();
        CatalogJanitor janitor = (CatalogJanitor)Mockito.spy((Object)new CatalogJanitor(server, services));
        ((CatalogJanitor)Mockito.doReturn(new Triple(10, mergedRegions, splitParents)).when((Object)janitor)).getMergedRegionsAndSplitParents();
        Path splitaRef = this.createReferences(services, htd, parent, splita, Bytes.toBytes("ccc"), false);
        Assert.assertEquals((long)0L, (long)janitor.scan());
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Assert.assertTrue((boolean)fs.delete(splitaRef, true));
        Assert.assertEquals((long)2L, (long)janitor.scan());
        services.stop("test finished");
        janitor.cancel(true);
    }

    @Test
    public void testSplitParentFirstComparator() {
        CatalogJanitor.SplitParentFirstComparator comp = new CatalogJanitor.SplitParentFirstComparator();
        HTableDescriptor htd = this.createHTableDescriptor();
        HRegionInfo rootRegion = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, true);
        HRegionInfo firstRegion = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes("bbb"), true);
        HRegionInfo lastRegion = new HRegionInfo(htd.getTableName(), Bytes.toBytes("bbb"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(rootRegion, rootRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegion) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegion) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, lastRegion) < 0 ? 1 : 0) != 0);
        HRegionInfo firstRegiona = new HRegionInfo(htd.getTableName(), HConstants.EMPTY_START_ROW, Bytes.toBytes("aaa"), true);
        HRegionInfo firstRegionb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("bbb"), true);
        HRegionInfo lastRegiona = new HRegionInfo(htd.getTableName(), Bytes.toBytes("bbb"), Bytes.toBytes("ddd"), true);
        HRegionInfo lastRegionb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ddd"), HConstants.EMPTY_END_ROW, true);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, firstRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegion, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, firstRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegiona) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionb, lastRegionb) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(rootRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegion, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegiona, lastRegionb) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegiona) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(firstRegionb, lastRegionb) < 0 ? 1 : 0) != 0);
        HRegionInfo lastRegionaa = new HRegionInfo(htd.getTableName(), Bytes.toBytes("bbb"), Bytes.toBytes("ccc"), false);
        HRegionInfo lastRegionab = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), Bytes.toBytes("ddd"), false);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionaa) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegiona, lastRegionab) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(lastRegionaa, lastRegionab) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testArchiveOldRegion() throws Exception {
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor(server, services);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(table));
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("eee"));
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), Bytes.toBytes("eee"));
        Result parentMetaRow = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir(fs.getConf(), rootdir);
        Path tabledir = FSUtils.getTableDir(rootdir, htd.getTableName());
        Path storedir = HStore.getStoreHomedir(tabledir, parent, htd.getColumnFamilies()[0].getName());
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath(services.getConfiguration(), parent, tabledir, htd.getColumnFamilies()[0].getName());
        LOG.debug("Table dir:" + tabledir);
        LOG.debug("Store dir:" + storedir);
        LOG.debug("Store archive dir:" + storeArchive);
        FileStatus[] mockFiles = this.addMockStoreFiles(2, services, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        int index = 0;
        for (FileStatus file : storeFiles) {
            LOG.debug("Have store file:" + file.getPath());
            Assert.assertEquals((String)"Got unexpected store file", (Object)mockFiles[index].getPath(), (Object)storeFiles[index].getPath());
            ++index;
        }
        Assert.assertTrue((boolean)janitor.cleanParent(parent, parentMetaRow));
        LOG.debug("Finished cleanup of parent region");
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        this.logFiles("archived files", storeFiles);
        this.logFiles("archived files", archivedStoreFiles);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        FSUtils.delete(fs, rootdir, true);
        services.stop("Test finished");
        server.stop("Test finished");
        janitor.cancel(true);
    }

    private void logFiles(String description, FileStatus[] storeFiles) {
        LOG.debug("Current " + description + ": ");
        for (FileStatus file : storeFiles) {
            LOG.debug(file.getPath());
        }
    }

    @Test
    public void testDuplicateHFileResolution() throws Exception {
        String table = "table";
        HBaseTestingUtility htu = new HBaseTestingUtility();
        this.setRootDirAndCleanIt(htu, "testCleanParent");
        MockServer server = new MockServer(htu);
        MockMasterServices services = new MockMasterServices(server);
        CatalogJanitor janitor = new CatalogJanitor(server, services);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf(table));
        htd.addFamily(new HColumnDescriptor("f"));
        HRegionInfo parent = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("eee"));
        HRegionInfo splita = new HRegionInfo(htd.getTableName(), Bytes.toBytes("aaa"), Bytes.toBytes("ccc"));
        HRegionInfo splitb = new HRegionInfo(htd.getTableName(), Bytes.toBytes("ccc"), Bytes.toBytes("eee"));
        Result r = this.createResult(parent, splita, splitb);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        Path rootdir = services.getMasterFileSystem().getRootDir();
        FSUtils.setRootDir(fs.getConf(), rootdir);
        Path tabledir = FSUtils.getTableDir(rootdir, parent.getTable());
        Path storedir = HStore.getStoreHomedir(tabledir, parent, htd.getColumnFamilies()[0].getName());
        System.out.println("Old root:" + rootdir);
        System.out.println("Old table:" + tabledir);
        System.out.println("Old store:" + storedir);
        Path storeArchive = HFileArchiveUtil.getStoreArchivePath(services.getConfiguration(), parent, tabledir, htd.getColumnFamilies()[0].getName());
        System.out.println("Old archive:" + storeArchive);
        this.addMockStoreFiles(2, services, storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        FileStatus[] archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs);
        this.addMockStoreFiles(2, services, storedir);
        Assert.assertTrue((boolean)janitor.cleanParent(parent, r));
        archivedStoreFiles = fs.listStatus(storeArchive);
        HFileArchiveTestingUtil.assertArchiveEqualToOriginal(storeFiles, archivedStoreFiles, fs, true);
        services.stop("Test finished");
        server.stop("shutdown");
        janitor.cancel(true);
    }

    private FileStatus[] addMockStoreFiles(int count, MasterServices services, Path storedir) throws IOException {
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        fs.mkdirs(storedir);
        for (int i = 0; i < count; ++i) {
            Path storeFile = new Path(storedir, "_store" + i);
            FSDataOutputStream dos = fs.create(storeFile, true);
            dos.writeBytes("Some data: " + i);
            dos.close();
        }
        LOG.debug("Adding " + count + " store files to the storedir:" + storedir);
        FileStatus[] storeFiles = fs.listStatus(storedir);
        Assert.assertEquals((String)"Didn't have expected store files", (long)count, (long)storeFiles.length);
        return storeFiles;
    }

    private String setRootDirAndCleanIt(HBaseTestingUtility htu, String subdir) throws IOException {
        Path testdir = htu.getDataTestDir(subdir);
        FileSystem fs = FileSystem.get((Configuration)htu.getConfiguration());
        if (fs.exists(testdir)) {
            Assert.assertTrue((boolean)fs.delete(testdir, true));
        }
        FSUtils.setRootDir(htu.getConfiguration(), testdir);
        return FSUtils.getRootDir(htu.getConfiguration()).toString();
    }

    private Path createReferences(MasterServices services, HTableDescriptor htd, HRegionInfo parent, HRegionInfo daughter, byte[] midkey, boolean top) throws IOException {
        Path rootdir = services.getMasterFileSystem().getRootDir();
        Path tabledir = FSUtils.getTableDir(rootdir, parent.getTable());
        Path storedir = HStore.getStoreHomedir(tabledir, daughter, htd.getColumnFamilies()[0].getName());
        Reference ref = top ? Reference.createTopReference(midkey) : Reference.createBottomReference(midkey);
        long now = System.currentTimeMillis();
        Path p = new Path(storedir, Long.toString(now) + "." + parent.getEncodedName());
        FileSystem fs = services.getMasterFileSystem().getFileSystem();
        ref.write(fs, p);
        return p;
    }

    private Result createResult(HRegionInfo parent, HRegionInfo a, HRegionInfo b) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(parent, null, a, b);
    }

    private HTableDescriptor createHTableDescriptor() {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf("t"));
        htd.addFamily(new HColumnDescriptor("f"));
        return htd;
    }

    private ClientProtos.MultiResponse buildMultiResponse(ClientProtos.MultiRequest req) {
        ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        ClientProtos.ResultOrException.Builder roeBuilder = ClientProtos.ResultOrException.newBuilder();
        for (ClientProtos.RegionAction regionAction : req.getRegionActionList()) {
            regionActionResultBuilder.clear();
            for (ClientProtos.Action action : regionAction.getActionList()) {
                roeBuilder.clear();
                roeBuilder.setResult(ClientProtos.Result.getDefaultInstance());
                roeBuilder.setIndex(action.getIndex());
                regionActionResultBuilder.addResultOrException(roeBuilder.build());
            }
            builder.addRegionActionResult(regionActionResultBuilder.build());
        }
        return builder.build();
    }

    class MockMasterServices
    implements MasterServices {
        private final MasterFileSystem mfs;
        private final AssignmentManager asm;
        private boolean stopped = false;

        MockMasterServices(Server server) throws IOException {
            this.mfs = new MasterFileSystem(server, this);
            this.asm = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        }

        @Override
        public void checkTableModifiable(TableName tableName) throws IOException {
        }

        @Override
        public boolean isMasterProcedureExecutorEnabled() {
            return true;
        }

        @Override
        public long createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
            return -1L;
        }

        @Override
        public AssignmentManager getAssignmentManager() {
            return this.asm;
        }

        @Override
        public ExecutorService getExecutorService() {
            return null;
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }

        @Override
        public MasterFileSystem getMasterFileSystem() {
            return this.mfs;
        }

        @Override
        public MasterCoprocessorHost getMasterCoprocessorHost() {
            return null;
        }

        @Override
        public MasterQuotaManager getMasterQuotaManager() {
            return null;
        }

        @Override
        public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
            return null;
        }

        @Override
        public ServerManager getServerManager() {
            return null;
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public ClusterConnection getConnection() {
            return null;
        }

        @Override
        public Configuration getConfiguration() {
            return this.mfs.conf;
        }

        @Override
        public ServerName getServerName() {
            return null;
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public void stop(String why) {
            this.stopped = true;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        @Override
        public TableDescriptors getTableDescriptors() {
            return new TableDescriptors(){

                @Override
                public HTableDescriptor remove(TableName tablename) throws IOException {
                    return null;
                }

                @Override
                public Map<String, HTableDescriptor> getAll() throws IOException {
                    return null;
                }

                @Override
                public HTableDescriptor get(TableName tablename) throws IOException {
                    return TestCatalogJanitor.this.createHTableDescriptor();
                }

                @Override
                public Map<String, HTableDescriptor> getByNamespace(String name) throws IOException {
                    return null;
                }

                @Override
                public void add(HTableDescriptor htd) throws IOException {
                }

                @Override
                public void setCacheOn() throws IOException {
                }

                @Override
                public void setCacheOff() throws IOException {
                }
            };
        }

        @Override
        public boolean isServerShutdownHandlerEnabled() {
            return true;
        }

        @Override
        public boolean registerService(Service instance) {
            return false;
        }

        @Override
        public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        }

        @Override
        public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        }

        @Override
        public void deleteNamespace(String name) throws IOException {
        }

        @Override
        public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
            return null;
        }

        @Override
        public List<NamespaceDescriptor> listNamespaceDescriptors() throws IOException {
            return null;
        }

        @Override
        public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
            return null;
        }

        @Override
        public List<TableName> listTableNamesByNamespace(String name) throws IOException {
            return null;
        }

        @Override
        public long deleteTable(TableName tableName) throws IOException {
            return -1L;
        }

        @Override
        public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        }

        @Override
        public void modifyTable(TableName tableName, HTableDescriptor descriptor) throws IOException {
        }

        @Override
        public long enableTable(TableName tableName) throws IOException {
            return -1L;
        }

        @Override
        public long disableTable(TableName tableName) throws IOException {
            return -1L;
        }

        @Override
        public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        }

        @Override
        public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        }

        @Override
        public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        }

        @Override
        public TableLockManager getTableLockManager() {
            return null;
        }

        @Override
        public void dispatchMergingRegions(HRegionInfo region_a, HRegionInfo region_b, boolean forcible) throws IOException {
        }

        @Override
        public boolean isInitialized() {
            return false;
        }

        @Override
        public long getLastMajorCompactionTimestamp(TableName table) throws IOException {
            return 0L;
        }

        @Override
        public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
            return 0L;
        }
    }

    class MockServer
    implements Server {
        private final ClusterConnection connection;
        private final Configuration c;

        MockServer(HBaseTestingUtility htu) throws NotAllMetaRegionsOnlineException, IOException, InterruptedException {
            this.c = htu.getConfiguration();
            ClientProtos.ClientService.BlockingInterface ri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
            ClientProtos.MutateResponse.Builder builder = ClientProtos.MutateResponse.newBuilder();
            builder.setProcessed(true);
            try {
                Mockito.when((Object)ri.mutate((RpcController)Mockito.any(), (ClientProtos.MutateRequest)Mockito.any())).thenReturn((Object)builder.build());
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            try {
                Mockito.when((Object)ri.multi((RpcController)Mockito.any(), (ClientProtos.MultiRequest)Mockito.any())).thenAnswer((Answer)new Answer<ClientProtos.MultiResponse>(){

                    public ClientProtos.MultiResponse answer(InvocationOnMock invocation) throws Throwable {
                        return TestCatalogJanitor.this.buildMultiResponse((ClientProtos.MultiRequest)invocation.getArguments()[1]);
                    }
                });
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            this.connection = HConnectionTestingUtility.getMockedConnectionAndDecorate(this.c, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class), ri, ServerName.valueOf("example.org,12345,6789"), HRegionInfo.FIRST_META_REGIONINFO);
            FileSystem fs = FileSystem.get((Configuration)this.c);
            Path rootdir = FSUtils.getRootDir(this.c);
            FSUtils.setRootDir(this.c, rootdir);
            AdminProtos.AdminService.BlockingInterface hri = (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class);
        }

        @Override
        public ClusterConnection getConnection() {
            return this.connection;
        }

        @Override
        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        @Override
        public Configuration getConfiguration() {
            return this.c;
        }

        @Override
        public ServerName getServerName() {
            return ServerName.valueOf("mockserver.example.org", 1234, -1L);
        }

        @Override
        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        @Override
        public CoordinatedStateManager getCoordinatedStateManager() {
            BaseCoordinatedStateManager m = (BaseCoordinatedStateManager)Mockito.mock(BaseCoordinatedStateManager.class);
            SplitLogManagerCoordination c = (SplitLogManagerCoordination)Mockito.mock(SplitLogManagerCoordination.class);
            Mockito.when((Object)m.getSplitLogManagerCoordination()).thenReturn((Object)c);
            SplitLogManagerCoordination.SplitLogManagerDetails d = (SplitLogManagerCoordination.SplitLogManagerDetails)Mockito.mock(SplitLogManagerCoordination.SplitLogManagerDetails.class);
            Mockito.when((Object)c.getDetails()).thenReturn((Object)d);
            return m;
        }

        @Override
        public void abort(String why, Throwable e) {
        }

        @Override
        public boolean isAborted() {
            return false;
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public void stop(String why) {
        }

        @Override
        public ChoreService getChoreService() {
            return null;
        }
    }
}

