/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.CellCreator;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TextSortReducer
extends Reducer<ImmutableBytesWritable, Text, ImmutableBytesWritable, KeyValue> {
    private long ts;
    private String separator;
    private boolean skipBadLines;
    private Counter badLineCount;
    private ImportTsv.TsvParser parser;
    private String cellVisibilityExpr;
    private long ttl;
    private CellCreator kvCreator;

    public long getTs() {
        return this.ts;
    }

    public boolean getSkipBadLines() {
        return this.skipBadLines;
    }

    public Counter getBadLineCount() {
        return this.badLineCount;
    }

    public void incrementBadLineCount(int count) {
        this.badLineCount.increment((long)count);
    }

    protected void setup(Reducer.Context context) {
        this.doSetup(context);
        Configuration conf = context.getConfiguration();
        this.parser = new ImportTsv.TsvParser(conf.get("importtsv.columns"), this.separator);
        if (this.parser.getRowKeyColumnIndex() == -1) {
            throw new RuntimeException("No row key column specified");
        }
        this.kvCreator = new CellCreator(conf);
    }

    protected void doSetup(Reducer.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("importtsv.separator");
        this.separator = this.separator == null ? "\t" : new String(Base64.decode(this.separator));
        this.ts = conf.getLong("importtsv.timestamp", 0L);
        this.skipBadLines = context.getConfiguration().getBoolean("importtsv.skip.bad.lines", true);
        this.badLineCount = context.getCounter("ImportTsv", "Bad Lines");
    }

    protected void reduce(ImmutableBytesWritable rowKey, Iterable<Text> lines, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("reducer.row.threshold", 0x40000000L);
        Iterator<Text> iter = lines.iterator();
        while (iter.hasNext()) {
            TreeSet<KeyValue> kvs = new TreeSet<KeyValue>((Comparator<KeyValue>)((Object)KeyValue.COMPARATOR));
            long curSize = 0L;
            while (iter.hasNext() && curSize < threshold) {
                Text line = iter.next();
                byte[] lineBytes = line.getBytes();
                try {
                    ImportTsv.TsvParser.ParsedLine parsed = this.parser.parse(lineBytes, line.getLength());
                    this.ts = parsed.getTimestamp(this.ts);
                    this.cellVisibilityExpr = parsed.getCellVisibility();
                    this.ttl = parsed.getCellTTL();
                    for (int i = 0; i < parsed.getColumnCount(); ++i) {
                        if (i == this.parser.getRowKeyColumnIndex() || i == this.parser.getTimestampKeyColumnIndex() || i == this.parser.getAttributesKeyColumnIndex() || i == this.parser.getCellVisibilityColumnIndex() || i == this.parser.getCellTTLColumnIndex()) continue;
                        ArrayList<Tag> tags = new ArrayList<Tag>();
                        if (this.cellVisibilityExpr != null) {
                            tags.addAll(this.kvCreator.getVisibilityExpressionResolver().createVisibilityExpTags(this.cellVisibilityExpr));
                        }
                        if (this.ttl > 0L) {
                            tags.add(new Tag(8, Bytes.toBytes(this.ttl)));
                        }
                        Cell cell = this.kvCreator.create(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength(), this.parser.getFamily(i), 0, this.parser.getFamily(i).length, this.parser.getQualifier(i), 0, this.parser.getQualifier(i).length, this.ts, lineBytes, parsed.getColumnOffset(i), parsed.getColumnLength(i), tags);
                        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                        kvs.add(kv);
                        curSize += kv.heapSize();
                    }
                }
                catch (ImportTsv.TsvParser.BadTsvLineException badLine) {
                    if (this.skipBadLines) {
                        System.err.println("Bad line." + badLine.getMessage());
                        this.incrementBadLineCount(1);
                        return;
                    }
                    throw new IOException(badLine);
                }
                catch (IllegalArgumentException e) {
                    if (this.skipBadLines) {
                        System.err.println("Bad line." + e.getMessage());
                        this.incrementBadLineCount(1);
                        return;
                    }
                    throw new IOException(e);
                }
            }
            context.setStatus("Read " + kvs.size() + " entries of " + kvs.getClass() + "(" + StringUtils.humanReadableInt((long)curSize) + ")");
            int index = 0;
            for (KeyValue kv : kvs) {
                context.write((Object)rowKey, (Object)kv);
                if (++index <= 0 || index % 100 != 0) continue;
                context.setStatus("Wrote " + index + " key values.");
            }
            if (!iter.hasNext()) continue;
            context.write(null, null);
        }
    }
}

