/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestWALRecordReader {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static FileSystem fs;
    private static Path hbaseDir;
    static final TableName tableName;
    private static final byte[] rowName;
    static final HRegionInfo info;
    private static final byte[] family;
    private static final byte[] value;
    private static HTableDescriptor htd;
    private static Path logDir;

    private static String getName() {
        return "TestWALRecordReader";
    }

    @Before
    public void setUp() throws Exception {
        FileStatus[] entries;
        for (FileStatus dir : entries = fs.listStatus(hbaseDir)) {
            fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("dfs.blocksize", 0x100000);
        conf.setInt("dfs.replication", 1);
        TEST_UTIL.startMiniDFSCluster(1);
        conf = TEST_UTIL.getConfiguration();
        fs = TEST_UTIL.getDFSCluster().getFileSystem();
        hbaseDir = TEST_UTIL.createRootDir();
        logDir = new Path(hbaseDir, "WALs");
        htd = new HTableDescriptor(tableName);
        htd.addFamily(new HColumnDescriptor(family));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPartialRead() throws Exception {
        WALFactory walfactory = new WALFactory(conf, null, TestWALRecordReader.getName());
        WAL log = walfactory.getWAL(info.getEncodedNameAsBytes());
        long ts = System.currentTimeMillis();
        WALEdit edit = new WALEdit();
        AtomicLong sequenceId = new AtomicLong(0L);
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("1"), ts, value));
        log.append(htd, info, this.getWalKey(ts), edit, sequenceId, true, null);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("2"), ts + 1L, value));
        log.append(htd, info, this.getWalKey(ts + 1L), edit, sequenceId, true, null);
        log.sync();
        this.LOG.info("Before 1st WAL roll " + log.toString());
        log.rollWriter();
        this.LOG.info("Past 1st WAL roll " + log.toString());
        Thread.sleep(1L);
        long ts1 = System.currentTimeMillis();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("3"), ts1 + 1L, value));
        log.append(htd, info, this.getWalKey(ts1 + 1L), edit, sequenceId, true, null);
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("4"), ts1 + 2L, value));
        log.append(htd, info, this.getWalKey(ts1 + 2L), edit, sequenceId, true, null);
        log.sync();
        log.shutdown();
        walfactory.shutdown();
        this.LOG.info("Closed WAL " + log.toString());
        WALInputFormat input = new WALInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", logDir.toString());
        jobConf.setLong("wal.end.time", ts);
        List<InputSplit> splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit(splits.get(0), new byte[][]{Bytes.toBytes("1")});
        jobConf.setLong("wal.start.time", ts + 1L);
        jobConf.setLong("wal.end.time", ts1 + 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit(splits.get(0), new byte[][]{Bytes.toBytes("2")});
        this.testSplit(splits.get(1), new byte[][]{Bytes.toBytes("3")});
    }

    @Test
    public void testWALRecordReader() throws Exception {
        WALFactory walfactory = new WALFactory(conf, null, TestWALRecordReader.getName());
        WAL log = walfactory.getWAL(info.getEncodedNameAsBytes());
        byte[] value = Bytes.toBytes("value");
        AtomicLong sequenceId = new AtomicLong(0L);
        WALEdit edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("1"), System.currentTimeMillis(), value));
        long txid = log.append(htd, info, this.getWalKey(System.currentTimeMillis()), edit, sequenceId, true, null);
        log.sync(txid);
        Thread.sleep(1L);
        long secondTs = System.currentTimeMillis();
        log.rollWriter();
        edit = new WALEdit();
        edit.add(new KeyValue(rowName, family, Bytes.toBytes("2"), System.currentTimeMillis(), value));
        txid = log.append(htd, info, this.getWalKey(System.currentTimeMillis()), edit, sequenceId, true, null);
        log.sync(txid);
        log.shutdown();
        walfactory.shutdown();
        long thirdTs = System.currentTimeMillis();
        WALInputFormat input = new WALInputFormat();
        Configuration jobConf = new Configuration(conf);
        jobConf.set("mapreduce.input.fileinputformat.inputdir", logDir.toString());
        List<InputSplit> splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit(splits.get(0), new byte[][]{Bytes.toBytes("1")});
        this.testSplit(splits.get(1), new byte[][]{Bytes.toBytes("2")});
        jobConf.setLong("wal.end.time", secondTs - 1L);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)1L, (long)splits.size());
        this.testSplit(splits.get(0), new byte[][]{Bytes.toBytes("1")});
        jobConf.setLong("wal.end.time", Long.MAX_VALUE);
        jobConf.setLong("wal.start.time", thirdTs);
        splits = input.getSplits(MapreduceTestingShim.createJobContext(jobConf));
        Assert.assertEquals((long)2L, (long)splits.size());
        this.testSplit(splits.get(0), new byte[0][]);
        this.testSplit(splits.get(1), new byte[0][]);
    }

    protected WALKey getWalKey(long sequenceid) {
        return new WALKey(info.getEncodedNameAsBytes(), tableName, sequenceid);
    }

    protected WALInputFormat.WALRecordReader getReader() {
        return new WALInputFormat.WALKeyRecordReader();
    }

    private void testSplit(InputSplit split, byte[] ... columns) throws Exception {
        WALInputFormat.WALRecordReader reader = this.getReader();
        reader.initialize(split, MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)conf));
        for (byte[] column : columns) {
            Assert.assertTrue((boolean)reader.nextKeyValue());
            Cell cell = reader.getCurrentValue().getCells().get(0);
            if (Bytes.equals(column, cell.getQualifier())) continue;
            Assert.assertTrue((String)("expected [" + Bytes.toString(column) + "], actual [" + Bytes.toString(cell.getQualifier()) + "]"), (boolean)false);
        }
        Assert.assertFalse((boolean)reader.nextKeyValue());
        reader.close();
    }

    static {
        tableName = TableName.valueOf(TestWALRecordReader.getName());
        rowName = tableName.getName();
        info = new HRegionInfo(tableName, Bytes.toBytes(""), Bytes.toBytes(""), false);
        family = Bytes.toBytes("column");
        value = Bytes.toBytes("value");
    }
}

