/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.mapreduce.TestImportTsv;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestImportTSVWithOperationAttributes
implements Configurable {
    protected static final Log LOG = LogFactory.getLog(TestImportTSVWithOperationAttributes.class);
    protected static final String NAME = TestImportTsv.class.getSimpleName();
    protected static HBaseTestingUtility util = new HBaseTestingUtility();
    protected static final String DELETE_AFTER_LOAD_CONF = NAME + ".deleteAfterLoad";
    protected static final String FORCE_COMBINER_CONF = NAME + ".forceCombiner";
    private static Configuration conf;
    private static final String TEST_ATR_KEY = "test";
    private final String FAMILY = "FAM";

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        conf = util.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", OperationAttributesTestController.class.getName());
        conf.set("hbase.coprocessor.region.classes", OperationAttributesTestController.class.getName());
        util.startMiniCluster();
        HBaseAdmin admin = new HBaseAdmin(util.getConfiguration());
        util.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.shutdownMiniMapReduceCluster();
        util.shutdownMiniCluster();
    }

    @Test
    public void testMROnTable() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterCustomTestMapperForOprAttr", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_ATTRIBUTES_KEY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001btest=>myvalue\n";
        util.createTable(TableName.valueOf(tableName), "FAM");
        this.doMROnTableTest(util, "FAM", data, args, 1, true);
        util.deleteTable(tableName);
    }

    @Test
    public void testMROnTableWithInvalidOperationAttr() throws Exception {
        String tableName = "test-" + UUID.randomUUID();
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterCustomTestMapperForOprAttr", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_ATTRIBUTES_KEY", "-Dimporttsv.separator=\u001b", tableName};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001btest1=>myvalue\n";
        util.createTable(TableName.valueOf(tableName), "FAM");
        this.doMROnTableTest(util, "FAM", data, args, 1, false);
        util.deleteTable(tableName);
    }

    private Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args, int valueMultiplier, boolean dataAvailable) throws Exception {
        String table = args[args.length - 1];
        Configuration conf = new Configuration(util.getConfiguration());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(util.getDataTestDirOnTestFS(table), "input.dat"));
        FSDataOutputStream op = fs.create(inputPath, true);
        op.write(Bytes.toBytes(data));
        op.close();
        LOG.debug(String.format("Wrote test data to file: %s", inputPath));
        if (conf.getBoolean(FORCE_COMBINER_CONF, true)) {
            LOG.debug("Forcing combiner.");
            conf.setInt("mapreduce.map.combine.minspills", 1);
        }
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        argv.add(inputPath.toString());
        ImportTsv tool = new ImportTsv();
        LOG.debug("Running ImportTsv with arguments: " + argv);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)tool, (String[])argv.toArray(args)));
        TestImportTSVWithOperationAttributes.validateTable(conf, TableName.valueOf(table), family, valueMultiplier, dataAvailable);
        if (conf.getBoolean(DELETE_AFTER_LOAD_CONF, true)) {
            LOG.debug("Deleting test subdirectory");
            util.cleanupDataTestDirOnTestFS(table);
        }
        return tool;
    }

    private static void validateTable(Configuration conf, TableName tableName, String family, int valueMultiplier, boolean dataAvailable) throws IOException {
        LOG.debug("Validating table.");
        HTable table = new HTable(conf, tableName);
        boolean verified = false;
        long pause = conf.getLong("hbase.client.pause", 5000L);
        int numRetries = conf.getInt("hbase.client.retries.number", 5);
        for (int i = 0; i < numRetries; ++i) {
            try {
                Scan scan = new Scan();
                scan.addFamily(Bytes.toBytes(family));
                if (dataAvailable) {
                    ResultScanner resScanner = table.getScanner(scan);
                    for (Result res : resScanner) {
                        LOG.debug("Getting results " + res.size());
                        Assert.assertTrue((res.size() == 2 ? 1 : 0) != 0);
                        List<Cell> kvs = res.listCells();
                        Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(0), Bytes.toBytes("KEY")));
                        Assert.assertTrue((boolean)CellUtil.matchingRow(kvs.get(1), Bytes.toBytes("KEY")));
                        Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(0), Bytes.toBytes("VALUE" + valueMultiplier)));
                        Assert.assertTrue((boolean)CellUtil.matchingValue(kvs.get(1), Bytes.toBytes("VALUE" + 2 * valueMultiplier)));
                        verified = true;
                    }
                    break;
                }
                ResultScanner resScanner = table.getScanner(scan);
                Result[] next = resScanner.next(2);
                Assert.assertEquals((long)0L, (long)next.length);
                verified = true;
                break;
            }
            catch (NullPointerException e) {
                try {
                    Thread.sleep(pause);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        table.close();
        Assert.assertTrue((boolean)verified);
    }

    public static class OperationAttributesTestController
    extends BaseRegionObserver {
        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            Region region = e.getEnvironment().getRegion();
            if (!region.getRegionInfo().isMetaTable() && !region.getRegionInfo().getTable().isSystemTable()) {
                if (put.getAttribute(TestImportTSVWithOperationAttributes.TEST_ATR_KEY) != null) {
                    LOG.debug("allow any put to happen " + region.getRegionInfo().getRegionNameAsString());
                } else {
                    e.bypass();
                }
            }
        }
    }
}

