/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSizeCalculator;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class TableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    public static final String MAPREDUCE_INPUT_AUTOBALANCE = "hbase.mapreduce.input.autobalance";
    public static final String INPUT_AUTOBALANCE_MAXSKEWRATIO = "hbase.mapreduce.input.autobalance.maxskewratio";
    public static final String TABLE_ROW_TEXTKEY = "hbase.table.row.textkey";
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private static final String NOT_INITIALIZED = "The input format instance has not been properly initialized. Ensure you call initializeTable either in your constructor or initialize method";
    private static final String INITIALIZATION_ERROR = "Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.";
    private Scan scan = null;
    private Admin admin;
    private Table table;
    private RegionLocator regionLocator;
    private TableRecordReader tableRecordReader = null;
    private Connection connection;
    private HashMap<InetAddress, String> reverseDNSCacheMap = new HashMap();

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        if (this.table == null) {
            this.initialize((JobContext)context);
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        TableSplit tSplit = (TableSplit)split;
        this.LOG.info("Input split length: " + StringUtils.humanReadableInt((long)tSplit.getLength()) + " bytes.");
        final TableRecordReader trr = this.tableRecordReader != null ? this.tableRecordReader : new TableRecordReader();
        Scan sc = new Scan(this.scan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setTable(this.getTable());
        return new RecordReader<ImmutableBytesWritable, Result>(){

            public void close() throws IOException {
                trr.close();
                TableInputFormatBase.this.closeTable();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return trr.getCurrentKey();
            }

            public Result getCurrentValue() throws IOException, InterruptedException {
                return trr.getCurrentValue();
            }

            public float getProgress() throws IOException, InterruptedException {
                return trr.getProgress();
            }

            public void initialize(InputSplit inputsplit, TaskAttemptContext context) throws IOException, InterruptedException {
                trr.initialize(inputsplit, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return trr.nextKeyValue();
            }
        };
    }

    protected Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getRegionLocator().getStartEndKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        boolean closeOnFinish = false;
        if (this.table == null) {
            this.initialize(context);
            closeOnFinish = true;
        }
        try {
            if (this.getTable() == null) {
                throw new IOException(INITIALIZATION_ERROR);
            }
        }
        catch (IllegalStateException exception) {
            throw new IOException(INITIALIZATION_ERROR, exception);
        }
        try {
            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(this.regionLocator, this.admin);
            Pair<byte[][], byte[][]> keys = this.getStartEndKeys();
            if (keys == null || keys.getFirst() == null || keys.getFirst().length == 0) {
                HRegionLocation regLoc = this.regionLocator.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY, false);
                if (null == regLoc) {
                    throw new IOException("Expecting at least one region.");
                }
                ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
                long regionSize = sizeCalculator.getRegionSize(regLoc.getRegionInfo().getRegionName());
                TableSplit split = new TableSplit(this.table.getName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, regLoc.getHostnamePort().split(":")[0], regionSize);
                splits.add(split);
                ArrayList<InputSplit> arrayList = splits;
                return arrayList;
            }
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(keys.getFirst().length);
            for (int i = 0; i < keys.getFirst().length; ++i) {
                String regionLocation;
                if (!this.includeRegionInSplit(keys.getFirst()[i], keys.getSecond()[i])) continue;
                HRegionLocation location = this.regionLocator.getRegionLocation(keys.getFirst()[i], false);
                InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
                if (isa.isUnresolved()) {
                    this.LOG.warn("Failed resolve " + isa);
                }
                InetAddress regionAddress = isa.getAddress();
                try {
                    regionLocation = this.reverseDNS(regionAddress);
                }
                catch (NamingException e) {
                    this.LOG.warn("Cannot resolve the host name for " + regionAddress + " because of " + e);
                    regionLocation = location.getHostname();
                }
                byte[] startRow = this.scan.getStartRow();
                byte[] stopRow = this.scan.getStopRow();
                if (startRow.length != 0 && keys.getSecond()[i].length != 0 && Bytes.compareTo(startRow, keys.getSecond()[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo(stopRow, keys.getFirst()[i]) <= 0) continue;
                byte[] splitStart = startRow.length == 0 || Bytes.compareTo(keys.getFirst()[i], startRow) >= 0 ? keys.getFirst()[i] : startRow;
                byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo(keys.getSecond()[i], stopRow) <= 0) && keys.getSecond()[i].length > 0 ? keys.getSecond()[i] : stopRow;
                byte[] regionName = location.getRegionInfo().getRegionName();
                long regionSize = sizeCalculator.getRegionSize(regionName);
                TableSplit split = new TableSplit(this.table.getName(), splitStart, splitStop, regionLocation, regionSize);
                splits.add(split);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("getSplits: split -> " + i + " -> " + split);
            }
            boolean enableAutoBalance = context.getConfiguration().getBoolean(MAPREDUCE_INPUT_AUTOBALANCE, false);
            if (enableAutoBalance) {
                long totalRegionSize = 0L;
                for (int i = 0; i < splits.size(); ++i) {
                    TableSplit ts = (TableSplit)splits.get(i);
                    totalRegionSize += ts.getLength();
                }
                long averageRegionSize = totalRegionSize / (long)splits.size();
                if (averageRegionSize <= 0L) {
                    this.LOG.warn("The averageRegionSize is not positive: " + averageRegionSize + ", " + "set it to 1.");
                    averageRegionSize = 1L;
                }
                List<InputSplit> list = this.calculateRebalancedSplits(splits, context, averageRegionSize);
                return list;
            }
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        finally {
            if (closeOnFinish) {
                this.closeTable();
            }
        }
    }

    @Deprecated
    public String reverseDNS(InetAddress ipAddress) throws NamingException, UnknownHostException {
        String hostName = this.reverseDNSCacheMap.get(ipAddress);
        if (hostName == null) {
            String ipAddressString = null;
            try {
                ipAddressString = DNS.reverseDns((InetAddress)ipAddress, null);
            }
            catch (Exception e) {
                ipAddressString = InetAddress.getByName(ipAddress.getHostAddress()).getHostName();
            }
            if (ipAddressString == null) {
                throw new UnknownHostException("No host found for " + ipAddress);
            }
            hostName = Strings.domainNamePointerToHostName(ipAddressString);
            this.reverseDNSCacheMap.put(ipAddress, hostName);
        }
        return hostName;
    }

    public List<InputSplit> calculateRebalancedSplits(List<InputSplit> list, JobContext context, long average) throws IOException {
        ArrayList<InputSplit> resultList = new ArrayList<InputSplit>();
        Configuration conf = context.getConfiguration();
        long dataSkewRatio = conf.getLong(INPUT_AUTOBALANCE_MAXSKEWRATIO, 3L);
        boolean isTextKey = context.getConfiguration().getBoolean(TABLE_ROW_TEXTKEY, true);
        long dataSkewThreshold = dataSkewRatio * average;
        int count = 0;
        while (count < list.size()) {
            TableSplit nextRegion;
            long nextRegionSize;
            TableSplit ts = (TableSplit)list.get(count);
            String regionLocation = ts.getRegionLocation();
            long regionSize = ts.getLength();
            if (regionSize >= dataSkewThreshold) {
                byte[] splitKey = TableInputFormatBase.getSplitKey(ts.getStartRow(), ts.getEndRow(), isTextKey);
                TableSplit t1 = new TableSplit(this.table.getName(), ts.getStartRow(), splitKey, regionLocation, regionSize / 2L);
                TableSplit t2 = new TableSplit(this.table.getName(), splitKey, ts.getEndRow(), regionLocation, regionSize - regionSize / 2L);
                resultList.add(t1);
                resultList.add(t2);
                ++count;
                continue;
            }
            if (regionSize >= average) {
                resultList.add(ts);
                ++count;
                continue;
            }
            long totalSize = regionSize;
            byte[] splitStartKey = ts.getStartRow();
            byte[] splitEndKey = ts.getEndRow();
            ++count;
            while (count < list.size() && totalSize + (nextRegionSize = (nextRegion = (TableSplit)list.get(count)).getLength()) <= dataSkewThreshold) {
                totalSize += nextRegionSize;
                splitEndKey = nextRegion.getEndRow();
                ++count;
            }
            TableSplit t = new TableSplit(this.table.getName(), splitStartKey, splitEndKey, regionLocation, totalSize);
            resultList.add(t);
        }
        return resultList;
    }

    public static byte[] getSplitKey(byte[] start, byte[] end, boolean isText) {
        int lowerLimitByte;
        int upperLimitByte;
        if (isText) {
            upperLimitByte = 126;
            lowerLimitByte = 32;
        } else {
            upperLimitByte = 127;
            lowerLimitByte = -128;
        }
        if (start.length == 0 && end.length == 0) {
            return new byte[]{(byte)((lowerLimitByte + upperLimitByte) / 2)};
        }
        if (start.length == 0 && end.length != 0) {
            return new byte[]{end[0]};
        }
        if (start.length != 0 && end.length == 0) {
            byte[] result = new byte[start.length];
            result[0] = start[0];
            for (int k = 1; k < start.length; ++k) {
                result[k] = upperLimitByte;
            }
            return result;
        }
        ArrayList<Byte> resultBytesList = new ArrayList<Byte>();
        int maxLength = start.length > end.length ? start.length : end.length;
        for (int i = 0; i < maxLength; ++i) {
            if (start[i] == end[i]) {
                resultBytesList.add(start[i]);
                if (i + 1 != start.length) continue;
                resultBytesList.add((byte)((lowerLimitByte + end[i + 1]) / 2));
                break;
            }
            if (end[i] - start[i] == 1) {
                int endNextByte;
                int byteRange;
                int halfRange;
                int startNextByte = i + 1 < start.length ? start[i + 1] : lowerLimitByte;
                if (startNextByte + (halfRange = (byteRange = upperLimitByte - startNextByte + ((endNextByte = i + 1 < end.length ? end[i + 1] : lowerLimitByte) - lowerLimitByte) + 1) / 2) > upperLimitByte) {
                    resultBytesList.add(end[i]);
                    resultBytesList.add((byte)(startNextByte + halfRange - upperLimitByte + lowerLimitByte));
                    break;
                }
                resultBytesList.add(start[i]);
                resultBytesList.add((byte)(startNextByte + halfRange));
                break;
            }
            resultBytesList.add((byte)((start[i] + end[i]) / 2));
            break;
        }
        byte[] result = new byte[resultBytesList.size()];
        for (int k = 0; k < resultBytesList.size(); ++k) {
            result[k] = (Byte)resultBytesList.get(k);
        }
        return result;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    @Deprecated
    protected HTable getHTable() {
        return (HTable)this.getTable();
    }

    protected RegionLocator getRegionLocator() {
        if (this.regionLocator == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.regionLocator;
    }

    protected Table getTable() {
        if (this.table == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.table;
    }

    protected Admin getAdmin() {
        if (this.admin == null) {
            throw new IllegalStateException(NOT_INITIALIZED);
        }
        return this.admin;
    }

    @Deprecated
    protected void setHTable(HTable table) throws IOException {
        this.table = table;
        this.connection = table.getConnection();
        try {
            this.regionLocator = table.getRegionLocator();
            this.admin = this.connection.getAdmin();
        }
        catch (NeedUnmanagedConnectionException exception) {
            this.LOG.warn("You are using an HTable instance that relies on an HBase-managed Connection. This is usually due to directly creating an HTable, which is deprecated. Instead, you should create a Connection object and then request a Table instance from it. If you don't need the Table instance for your own use, you should instead use the TableInputFormatBase.initalizeTable method directly.");
            this.LOG.info("Creating an additional unmanaged connection because user provided one can't be used for administrative actions. We'll close it when we close out the table.");
            this.LOG.debug("Details about our failure to request an administrative interface.", exception);
            this.connection = ConnectionFactory.createConnection(this.connection.getConfiguration());
            this.regionLocator = this.connection.getRegionLocator(table.getName());
            this.admin = this.connection.getAdmin();
        }
    }

    protected void initializeTable(Connection connection, TableName tableName) throws IOException {
        if (this.table != null || this.connection != null) {
            this.LOG.warn("initializeTable called multiple times. Overwriting connection and table reference; TableInputFormatBase will not close these old references when done.");
        }
        this.table = connection.getTable(tableName);
        this.regionLocator = connection.getRegionLocator(tableName);
        this.admin = connection.getAdmin();
        this.connection = connection;
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void initialize(JobContext context) throws IOException {
    }

    protected void closeTable() throws IOException {
        this.close(this.admin, this.table, this.regionLocator, this.connection);
        this.admin = null;
        this.table = null;
        this.regionLocator = null;
        this.connection = null;
    }

    private void close(Closeable ... closables) throws IOException {
        for (Closeable c : closables) {
            if (c == null) continue;
            c.close();
        }
    }
}

