/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultiTableOutputFormat
extends OutputFormat<ImmutableBytesWritable, Mutation> {
    public static final String WAL_PROPERTY = "hbase.mapreduce.multitableoutputformat.wal";
    public static final boolean WAL_ON = true;
    public static final boolean WAL_OFF = false;

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public RecordWriter<ImmutableBytesWritable, Mutation> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        return new MultiTableRecordWriter(HBaseConfiguration.create(conf), conf.getBoolean(WAL_PROPERTY, true));
    }

    protected static class MultiTableRecordWriter
    extends RecordWriter<ImmutableBytesWritable, Mutation> {
        private static final Log LOG = LogFactory.getLog(MultiTableRecordWriter.class);
        Connection connection;
        Map<ImmutableBytesWritable, BufferedMutator> mutatorMap = new HashMap<ImmutableBytesWritable, BufferedMutator>();
        Configuration conf;
        boolean useWriteAheadLogging;

        public MultiTableRecordWriter(Configuration conf, boolean useWriteAheadLogging) {
            LOG.debug("Created new MultiTableRecordReader with WAL " + (useWriteAheadLogging ? "on" : "off"));
            this.conf = conf;
            this.useWriteAheadLogging = useWriteAheadLogging;
        }

        BufferedMutator getBufferedMutator(ImmutableBytesWritable tableName) throws IOException {
            if (this.connection == null) {
                this.connection = ConnectionFactory.createConnection(this.conf);
            }
            if (!this.mutatorMap.containsKey(tableName)) {
                LOG.debug("Opening HTable \"" + Bytes.toString(tableName.get()) + "\" for writing");
                BufferedMutator mutator = this.connection.getBufferedMutator(TableName.valueOf(tableName.get()));
                this.mutatorMap.put(tableName, mutator);
            }
            return this.mutatorMap.get(tableName);
        }

        public void close(TaskAttemptContext context) throws IOException {
            for (BufferedMutator mutator : this.mutatorMap.values()) {
                mutator.flush();
            }
        }

        public void write(ImmutableBytesWritable tableName, Mutation action) throws IOException {
            BufferedMutator mutator = this.getBufferedMutator(tableName);
            if (action instanceof Put) {
                Put put = new Put((Put)action);
                put.setDurability(this.useWriteAheadLogging ? Durability.SYNC_WAL : Durability.SKIP_WAL);
                mutator.mutate(put);
            } else if (action instanceof Delete) {
                Delete delete = new Delete((Delete)action);
                mutator.mutate(delete);
            } else {
                throw new IllegalArgumentException("action must be either Delete or Put");
            }
        }
    }
}

