/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.SimpleRpcScheduler;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestSimpleRpcScheduler {
    public static final Log LOG = LogFactory.getLog(TestSimpleRpcScheduler.class);
    private final RpcScheduler.Context CONTEXT = new RpcScheduler.Context(){

        @Override
        public InetSocketAddress getListenerAddress() {
            return InetSocketAddress.createUnresolved("127.0.0.1", 1000);
        }
    };
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
    }

    @Test
    public void testBasic() throws IOException, InterruptedException {
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(this.conf, 10, 0, 0, qosFunction, 0);
        ((RpcScheduler)scheduler).init(this.CONTEXT);
        ((RpcScheduler)scheduler).start();
        CallRunner task = this.createMockTask();
        ((RpcScheduler)scheduler).dispatch(task);
        ((CallRunner)Mockito.verify((Object)task, (VerificationMode)Mockito.timeout((long)1000L))).run();
        ((RpcScheduler)scheduler).stop();
    }

    @Test
    public void testHandlerIsolation() throws IOException, InterruptedException {
        CallRunner generalTask = this.createMockTask();
        CallRunner priorityTask = this.createMockTask();
        CallRunner replicationTask = this.createMockTask();
        ImmutableList<CallRunner> tasks = ImmutableList.of(generalTask, priorityTask, replicationTask);
        ImmutableMap<CallRunner, Integer> qos = ImmutableMap.of(generalTask, 0, priorityTask, 201, replicationTask, 5);
        PriorityFunction qosFunction = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        final HashMap handlerThreads = Maps.newHashMap();
        final CountDownLatch countDownLatch = new CountDownLatch(tasks.size());
        Answer<Void> answerToRun = new Answer<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                Map map = handlerThreads;
                synchronized (map) {
                    handlerThreads.put((CallRunner)invocationOnMock.getMock(), Thread.currentThread());
                }
                countDownLatch.countDown();
                return null;
            }
        };
        for (CallRunner task : tasks) {
            ((CallRunner)Mockito.doAnswer((Answer)answerToRun).when((Object)task)).run();
        }
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(this.conf, 1, 1, 1, qosFunction, 200);
        ((RpcScheduler)scheduler).init(this.CONTEXT);
        ((RpcScheduler)scheduler).start();
        for (CallRunner task : tasks) {
            Mockito.when((Object)qosFunction.getPriority((RPCProtos.RequestHeader)Matchers.anyObject(), (Message)Matchers.anyObject())).thenReturn(qos.get(task));
            ((RpcScheduler)scheduler).dispatch(task);
        }
        for (CallRunner task : tasks) {
            ((CallRunner)Mockito.verify((Object)task, (VerificationMode)Mockito.timeout((long)1000L))).run();
        }
        ((RpcScheduler)scheduler).stop();
        countDownLatch.await();
        Assert.assertEquals((long)3L, (long)ImmutableSet.copyOf(handlerThreads.values()).size());
    }

    private CallRunner createMockTask() {
        RpcServer.Call call = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
        CallRunner task = (CallRunner)Mockito.mock(CallRunner.class);
        Mockito.when((Object)task.getCall()).thenReturn((Object)call);
        return task;
    }

    @Test
    public void testRpcScheduler() throws Exception {
        this.testRpcScheduler("deadline");
        this.testRpcScheduler("fifo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRpcScheduler(String queueType) throws Exception {
        Configuration schedConf = HBaseConfiguration.create();
        schedConf.set("hbase.ipc.server.callqueue.type", queueType);
        PriorityFunction priority = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        Mockito.when((Object)priority.getPriority((RPCProtos.RequestHeader)Matchers.any(RPCProtos.RequestHeader.class), (Message)Matchers.any(Message.class))).thenReturn((Object)0);
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(schedConf, 1, 1, 1, priority, 10);
        try {
            ((RpcScheduler)scheduler).start();
            CallRunner smallCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call smallCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            RPCProtos.RequestHeader smallHead = RPCProtos.RequestHeader.newBuilder().setCallId(1).build();
            Mockito.when((Object)smallCallTask.getCall()).thenReturn((Object)smallCall);
            Mockito.when((Object)smallCall.getHeader()).thenReturn((Object)smallHead);
            CallRunner largeCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call largeCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            RPCProtos.RequestHeader largeHead = RPCProtos.RequestHeader.newBuilder().setCallId(50).build();
            Mockito.when((Object)largeCallTask.getCall()).thenReturn((Object)largeCall);
            Mockito.when((Object)largeCall.getHeader()).thenReturn((Object)largeHead);
            CallRunner hugeCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call hugeCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            RPCProtos.RequestHeader hugeHead = RPCProtos.RequestHeader.newBuilder().setCallId(100).build();
            Mockito.when((Object)hugeCallTask.getCall()).thenReturn((Object)hugeCall);
            Mockito.when((Object)hugeCall.getHeader()).thenReturn((Object)hugeHead);
            Mockito.when((Object)priority.getDeadline((RPCProtos.RequestHeader)Matchers.eq((Object)smallHead), (Message)Matchers.any(Message.class))).thenReturn((Object)0L);
            Mockito.when((Object)priority.getDeadline((RPCProtos.RequestHeader)Matchers.eq((Object)largeHead), (Message)Matchers.any(Message.class))).thenReturn((Object)50L);
            Mockito.when((Object)priority.getDeadline((RPCProtos.RequestHeader)Matchers.eq((Object)hugeHead), (Message)Matchers.any(Message.class))).thenReturn((Object)100L);
            ArrayList<Integer> work = new ArrayList<Integer>();
            this.doAnswerTaskExecution(smallCallTask, work, 10, 250);
            this.doAnswerTaskExecution(largeCallTask, work, 50, 250);
            this.doAnswerTaskExecution(hugeCallTask, work, 100, 250);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            ((RpcScheduler)scheduler).dispatch(hugeCallTask);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            ((RpcScheduler)scheduler).dispatch(largeCallTask);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            ((RpcScheduler)scheduler).dispatch(smallCallTask);
            while (work.size() < 8) {
                Threads.sleepWithoutInterrupt(100L);
            }
            int seqSum = 0;
            int totalTime = 0;
            for (int i = 0; i < work.size(); ++i) {
                LOG.debug("Request i=" + i + " value=" + work.get(i));
                totalTime += (seqSum += work.get(i).intValue());
            }
            LOG.debug("Total Time: " + totalTime);
            if (queueType.equals("deadline")) {
                Assert.assertEquals((long)530L, (long)totalTime);
            } else {
                Assert.assertEquals((long)930L, (long)totalTime);
            }
        }
        finally {
            ((RpcScheduler)scheduler).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanQueues() throws Exception {
        Configuration schedConf = HBaseConfiguration.create();
        schedConf.setFloat("hbase.ipc.server.callqueue.handler.factor", 1.0f);
        schedConf.setFloat("hbase.ipc.server.callqueue.read.ratio", 0.7f);
        schedConf.setFloat("hbase.ipc.server.callqueue.scan.ratio", 0.5f);
        PriorityFunction priority = (PriorityFunction)Mockito.mock(PriorityFunction.class);
        Mockito.when((Object)priority.getPriority((RPCProtos.RequestHeader)Matchers.any(RPCProtos.RequestHeader.class), (Message)Matchers.any(Message.class))).thenReturn((Object)0);
        SimpleRpcScheduler scheduler = new SimpleRpcScheduler(schedConf, 3, 1, 1, priority, 10);
        try {
            ((RpcScheduler)scheduler).start();
            CallRunner putCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call putCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            RPCProtos.RequestHeader putHead = RPCProtos.RequestHeader.newBuilder().setMethodName("mutate").build();
            Mockito.when((Object)putCallTask.getCall()).thenReturn((Object)putCall);
            Mockito.when((Object)putCall.getHeader()).thenReturn((Object)putHead);
            CallRunner getCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call getCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            RPCProtos.RequestHeader getHead = RPCProtos.RequestHeader.newBuilder().setMethodName("get").build();
            Mockito.when((Object)getCallTask.getCall()).thenReturn((Object)getCall);
            Mockito.when((Object)getCall.getHeader()).thenReturn((Object)getHead);
            CallRunner scanCallTask = (CallRunner)Mockito.mock(CallRunner.class);
            RpcServer.Call scanCall = (RpcServer.Call)Mockito.mock(RpcServer.Call.class);
            scanCall.param = ClientProtos.ScanRequest.newBuilder().setScannerId(1L).build();
            RPCProtos.RequestHeader scanHead = RPCProtos.RequestHeader.newBuilder().setMethodName("scan").build();
            Mockito.when((Object)scanCallTask.getCall()).thenReturn((Object)scanCall);
            Mockito.when((Object)scanCall.getHeader()).thenReturn((Object)scanHead);
            ArrayList<Integer> work = new ArrayList<Integer>();
            this.doAnswerTaskExecution(putCallTask, work, 1, 1000);
            this.doAnswerTaskExecution(getCallTask, work, 2, 1000);
            this.doAnswerTaskExecution(scanCallTask, work, 3, 1000);
            ((RpcScheduler)scheduler).dispatch(putCallTask);
            ((RpcScheduler)scheduler).dispatch(putCallTask);
            ((RpcScheduler)scheduler).dispatch(putCallTask);
            ((RpcScheduler)scheduler).dispatch(getCallTask);
            ((RpcScheduler)scheduler).dispatch(getCallTask);
            ((RpcScheduler)scheduler).dispatch(getCallTask);
            ((RpcScheduler)scheduler).dispatch(scanCallTask);
            ((RpcScheduler)scheduler).dispatch(scanCallTask);
            ((RpcScheduler)scheduler).dispatch(scanCallTask);
            while (work.size() < 6) {
                Threads.sleepWithoutInterrupt(100L);
            }
            for (int i = 0; i < work.size() - 2; i += 3) {
                Assert.assertNotEquals((Object)work.get(i + 0), (Object)work.get(i + 1));
                Assert.assertNotEquals((Object)work.get(i + 0), (Object)work.get(i + 2));
                Assert.assertNotEquals((Object)work.get(i + 1), (Object)work.get(i + 2));
            }
        }
        finally {
            ((RpcScheduler)scheduler).stop();
        }
    }

    private void doAnswerTaskExecution(CallRunner callTask, final ArrayList<Integer> results, final int value, final int sleepInterval) {
        ((CallRunner)Mockito.doAnswer((Answer)new Answer<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object answer(InvocationOnMock invocation) {
                ArrayList arrayList = results;
                synchronized (arrayList) {
                    results.add(value);
                }
                Threads.sleepWithoutInterrupt(sleepInterval);
                return null;
            }
        }).when((Object)callTask)).run();
    }
}

