/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.BlockingService;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public abstract class AbstractTestIPC {
    private static final Log LOG = LogFactory.getLog(AbstractTestIPC.class);
    private static byte[] CELL_BYTES = Bytes.toBytes("xyz");
    private static KeyValue CELL = new KeyValue(CELL_BYTES, CELL_BYTES, CELL_BYTES, CELL_BYTES);
    static byte[] BIG_CELL_BYTES = new byte[10240];
    static KeyValue BIG_CELL = new KeyValue(CELL_BYTES, CELL_BYTES, CELL_BYTES, BIG_CELL_BYTES);
    static final Configuration CONF = HBaseConfiguration.create();
    static final BlockingService SERVICE = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService(new TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface(){

        @Override
        public TestProtos.EmptyResponseProto ping(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EmptyResponseProto error(RpcController controller, TestProtos.EmptyRequestProto request) throws ServiceException {
            return null;
        }

        @Override
        public TestProtos.EchoResponseProto echo(RpcController controller, TestProtos.EchoRequestProto request) throws ServiceException {
            if (controller instanceof PayloadCarryingRpcController) {
                PayloadCarryingRpcController pcrc = (PayloadCarryingRpcController)controller;
                CellScanner cellScanner = pcrc.cellScanner();
                ArrayList<Cell> list = null;
                if (cellScanner != null) {
                    list = new ArrayList<Cell>();
                    try {
                        while (cellScanner.advance()) {
                            list.add(cellScanner.current());
                        }
                    }
                    catch (IOException e) {
                        throw new ServiceException((Throwable)e);
                    }
                }
                cellScanner = CellUtil.createCellScanner(list);
                ((PayloadCarryingRpcController)controller).setCellScanner(cellScanner);
            }
            return TestProtos.EchoResponseProto.newBuilder().setMessage(request.getMessage()).build();
        }
    });

    protected abstract AbstractRpcClient createRpcClientNoCodec(Configuration var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoCodec() throws InterruptedException, IOException {
        Configuration conf = HBaseConfiguration.create();
        AbstractRpcClient client = this.createRpcClientNoCodec(conf);
        TestRpcServer rpcServer = new TestRpcServer();
        try {
            rpcServer.start();
            InetSocketAddress address = rpcServer.getListenerAddress();
            Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
            String message = "hello";
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            Pair<Message, CellScanner> r = client.call(null, md, (Message)param, (Message)md.getOutputType().toProto(), User.getCurrent(), address);
            Assert.assertTrue((r.getSecond() == null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)r.getFirst().toString().contains("hello"));
        }
        finally {
            client.close();
            rpcServer.stop();
        }
    }

    protected abstract AbstractRpcClient createRpcClient(Configuration var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressCellBlock() throws IOException, InterruptedException, SecurityException, NoSuchMethodException, ServiceException {
        Configuration conf = new Configuration(HBaseConfiguration.create());
        conf.set("hbase.client.rpc.compressor", GzipCodec.class.getCanonicalName());
        ArrayList<Cell> cells = new ArrayList<Cell>();
        int count = 3;
        for (int i = 0; i < count; ++i) {
            cells.add(CELL);
        }
        AbstractRpcClient client = this.createRpcClient(conf);
        TestRpcServer rpcServer = new TestRpcServer();
        try {
            rpcServer.start();
            InetSocketAddress address = rpcServer.getListenerAddress();
            Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            PayloadCarryingRpcController pcrc = new PayloadCarryingRpcController(CellUtil.createCellScanner(cells));
            Pair<Message, CellScanner> r = client.call(pcrc, md, (Message)param, (Message)md.getOutputType().toProto(), User.getCurrent(), address);
            int index = 0;
            while (r.getSecond().advance()) {
                Assert.assertTrue((boolean)CELL.equals(r.getSecond().current()));
                ++index;
            }
            Assert.assertEquals((long)count, (long)index);
        }
        finally {
            client.close();
            rpcServer.stop();
        }
    }

    protected abstract AbstractRpcClient createRpcClientRTEDuringConnectionSetup(Configuration var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRTEDuringConnectionSetup() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        TestRpcServer rpcServer = new TestRpcServer();
        AbstractRpcClient client = this.createRpcClientRTEDuringConnectionSetup(conf);
        try {
            rpcServer.start();
            InetSocketAddress address = rpcServer.getListenerAddress();
            Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            client.call(null, md, (Message)param, null, User.getCurrent(), address);
            Assert.fail((String)"Expected an exception to have been thrown!");
        }
        catch (Exception e) {
            LOG.info("Caught expected exception: " + e.toString());
            Assert.assertTrue((boolean)StringUtils.stringifyException((Throwable)e).contains("Injected fault"));
        }
        finally {
            client.close();
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcScheduler() throws IOException, InterruptedException {
        RpcScheduler scheduler = (RpcScheduler)Mockito.spy((Object)new FifoRpcScheduler(CONF, 1));
        TestRpcServer rpcServer = new TestRpcServer(scheduler);
        ((RpcScheduler)Mockito.verify((Object)scheduler)).init((RpcScheduler.Context)Matchers.anyObject());
        AbstractRpcClient client = this.createRpcClient(CONF);
        try {
            rpcServer.start();
            ((RpcScheduler)Mockito.verify((Object)scheduler)).start();
            Descriptors.MethodDescriptor md = SERVICE.getDescriptorForType().findMethodByName("echo");
            TestProtos.EchoRequestProto param = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
            for (int i = 0; i < 10; ++i) {
                client.call(new PayloadCarryingRpcController(CellUtil.createCellScanner(ImmutableList.of(CELL))), md, (Message)param, (Message)md.getOutputType().toProto(), User.getCurrent(), rpcServer.getListenerAddress());
            }
            ((RpcScheduler)Mockito.verify((Object)scheduler, (VerificationMode)VerificationModeFactory.times((int)10))).dispatch((CallRunner)Matchers.anyObject());
        }
        finally {
            rpcServer.stop();
            ((RpcScheduler)Mockito.verify((Object)scheduler)).stop();
        }
    }

    static class TestRpcServer
    extends RpcServer {
        TestRpcServer() throws IOException {
            this(new FifoRpcScheduler(CONF, 1));
        }

        TestRpcServer(RpcScheduler scheduler) throws IOException {
            super(null, "testRpcServer", Lists.newArrayList(new RpcServer.BlockingServiceAndInterface(SERVICE, null)), new InetSocketAddress("localhost", 0), CONF, scheduler);
        }

        @Override
        public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status2) throws IOException {
            return super.call(service, md, param, cellScanner, receiveTime, status2);
        }
    }
}

