/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.TestHFileBlock;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestHFileBlockCompatibility {
    private static final Log LOG = LogFactory.getLog(TestHFileBlockCompatibility.class);
    private static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private HFileSystem fs;
    private final boolean includesMemstoreTS;
    private final boolean includesTag;

    public TestHFileBlockCompatibility(boolean includesMemstoreTS, boolean includesTag) {
        this.includesMemstoreTS = includesMemstoreTS;
        this.includesTag = includesTag;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.MEMSTORETS_TAGS_PARAMETRIZED;
    }

    @Before
    public void setUp() throws IOException {
        this.fs = (HFileSystem)HFileSystem.get(TEST_UTIL.getConfiguration());
    }

    public byte[] createTestV1Block(Compression.Algorithm algo) throws IOException {
        Compressor compressor = algo.getCompressor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = algo.createCompressionStream(baos, compressor, 0);
        DataOutputStream dos = new DataOutputStream(os);
        BlockType.META.write(dos);
        TestHFileBlock.writeTestBlockContents(dos);
        dos.flush();
        algo.returnCompressor(compressor);
        return baos.toByteArray();
    }

    private Writer createTestV2Block(Compression.Algorithm algo) throws IOException {
        BlockType blockType = BlockType.DATA;
        Writer hbw = new Writer(algo, null, this.includesMemstoreTS, this.includesTag);
        DataOutputStream dos = hbw.startWriting(blockType);
        TestHFileBlock.writeTestBlockContents(dos);
        hbw.getHeaderAndData();
        Assert.assertEquals((long)4000L, (long)hbw.getUncompressedSizeWithoutHeader());
        hbw.releaseCompressor();
        return hbw;
    }

    private String createTestBlockStr(Compression.Algorithm algo, int correctLength) throws IOException {
        Writer hbw = this.createTestV2Block(algo);
        byte[] testV2Block = hbw.getHeaderAndData();
        int osOffset = 33;
        if (testV2Block.length == correctLength) {
            testV2Block[osOffset] = 3;
        }
        return Bytes.toStringBinary(testV2Block);
    }

    @Test
    public void testNoCompression() throws IOException {
        Assert.assertEquals((long)4000L, (long)this.createTestV2Block(Compression.Algorithm.NONE).getBlockForCaching().getUncompressedSizeWithoutHeader());
    }

    @Test
    public void testGzipCompression() throws IOException {
        String correctTestBlockStr = "DATABLK*\\x00\\x00\\x00:\\x00\\x00\\x0F\\xA0\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\x1F\\x8B\\x08\\x00\\x00\\x00\\x00\\x00\\x00\\x03\\xED\\xC3\\xC1\\x11\\x00 \\x08\\xC00DD\\xDD\\x7Fa\\xD6\\xE8\\xA3\\xB9K\\x84`\\x96Q\\xD3\\xA8\\xDB\\xA8e\\xD4c\\xD46\\xEA5\\xEA3\\xEA7\\xE7\\x00LI\\x5Cs\\xA0\\x0F\\x00\\x00";
        int correctGzipBlockLength = 82;
        String returnedStr = this.createTestBlockStr(Compression.Algorithm.GZ, 82);
        Assert.assertEquals((Object)"DATABLK*\\x00\\x00\\x00:\\x00\\x00\\x0F\\xA0\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\x1F\\x8B\\x08\\x00\\x00\\x00\\x00\\x00\\x00\\x03\\xED\\xC3\\xC1\\x11\\x00 \\x08\\xC00DD\\xDD\\x7Fa\\xD6\\xE8\\xA3\\xB9K\\x84`\\x96Q\\xD3\\xA8\\xDB\\xA8e\\xD4c\\xD46\\xEA5\\xEA3\\xEA7\\xE7\\x00LI\\x5Cs\\xA0\\x0F\\x00\\x00", (Object)returnedStr);
    }

    @Test
    public void testReaderV2() throws IOException {
        if (this.includesTag) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        }
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                LOG.info("testReaderV2: Compression algorithm: " + (Object)((Object)algo) + ", pread=" + pread);
                Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + (Object)((Object)algo));
                FSDataOutputStream os = this.fs.create(path);
                Writer hbw = new Writer(algo, null, this.includesMemstoreTS, this.includesTag);
                long totalSize = 0L;
                for (int blockId = 0; blockId < 2; ++blockId) {
                    DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                    }
                    hbw.writeHeaderAndData(os);
                    totalSize += (long)hbw.getOnDiskSizeWithHeader();
                }
                os.close();
                FSDataInputStream is = this.fs.open(path);
                HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(algo).build();
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(new FSDataInputStreamWrapper(is), totalSize, this.fs, path, meta);
                HFileBlock b = hbr.readBlockData(0L, -1L, -1, pread);
                is.close();
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                HFileBlock expected = b;
                if (algo != Compression.Algorithm.GZ) continue;
                is = this.fs.open(path);
                hbr = new HFileBlock.FSReaderImpl(new FSDataInputStreamWrapper(is), totalSize, this.fs, path, meta);
                b = hbr.readBlockData(0L, 2197 + b.totalChecksumBytes(), -1, pread);
                Assert.assertEquals((Object)expected, (Object)b);
                int wrongCompressedSize = 2172;
                try {
                    b = hbr.readBlockData(0L, wrongCompressedSize + 24, -1, pread);
                    Assert.fail((String)"Exception expected");
                }
                catch (IOException ex) {
                    String expectedPrefix = "On-disk size without header provided is " + wrongCompressedSize + ", but block header contains " + b.getOnDiskSizeWithoutHeader() + ".";
                    Assert.assertTrue((String)("Invalid exception message: '" + ex.getMessage() + "'.\nMessage is expected to start with: '" + expectedPrefix + "'"), (boolean)ex.getMessage().startsWith(expectedPrefix));
                }
                is.close();
            }
        }
    }

    @Test
    public void testDataBlockEncoding() throws IOException {
        if (this.includesTag) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        }
        int numBlocks = 5;
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
                    LOG.info("testDataBlockEncoding algo " + (Object)((Object)algo) + " pread = " + pread + " encoding " + (Object)((Object)encoding));
                    Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + (Object)((Object)algo) + "_" + encoding.toString());
                    FSDataOutputStream os = this.fs.create(path);
                    HFileDataBlockEncoder dataBlockEncoder = encoding != DataBlockEncoding.NONE ? new HFileDataBlockEncoderImpl(encoding) : NoOpDataBlockEncoder.INSTANCE;
                    Writer hbw = new Writer(algo, dataBlockEncoder, this.includesMemstoreTS, this.includesTag);
                    long totalSize = 0L;
                    ArrayList<Integer> encodedSizes = new ArrayList<Integer>();
                    ArrayList<ByteBuffer> encodedBlocks = new ArrayList<ByteBuffer>();
                    for (int blockId = 0; blockId < 5; ++blockId) {
                        hbw.startWriting(BlockType.DATA);
                        TestHFileBlock.writeTestKeyValues(hbw, blockId, pread, this.includesTag);
                        hbw.writeHeaderAndData(os);
                        int headerLen = 24;
                        byte[] encodedResultWithHeader = hbw.getUncompressedDataWithHeader();
                        int encodedSize = encodedResultWithHeader.length - headerLen;
                        if (encoding != DataBlockEncoding.NONE) {
                            headerLen += 2;
                        }
                        byte[] encodedDataSection = new byte[encodedResultWithHeader.length - headerLen];
                        System.arraycopy(encodedResultWithHeader, headerLen, encodedDataSection, 0, encodedDataSection.length);
                        ByteBuffer encodedBuf = ByteBuffer.wrap(encodedDataSection);
                        encodedSizes.add(encodedSize);
                        encodedBlocks.add(encodedBuf);
                        totalSize += (long)hbw.getOnDiskSizeWithHeader();
                    }
                    os.close();
                    FSDataInputStream is = this.fs.open(path);
                    HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(algo).build();
                    HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(new FSDataInputStreamWrapper(is), totalSize, this.fs, path, meta);
                    hbr.setDataBlockEncoder(dataBlockEncoder);
                    hbr.setIncludesMemstoreTS(this.includesMemstoreTS);
                    int pos = 0;
                    for (int blockId = 0; blockId < 5; ++blockId) {
                        HFileBlock b = hbr.readBlockData(pos, -1L, -1, pread);
                        b.sanityCheck();
                        if (meta.isCompressedOrEncrypted()) {
                            Assert.assertFalse((boolean)b.isUnpacked());
                            b = b.unpack(meta, hbr);
                        }
                        pos += b.getOnDiskSizeWithHeader();
                        Assert.assertEquals((long)((Integer)encodedSizes.get(blockId)).intValue(), (long)b.getUncompressedSizeWithoutHeader());
                        ByteBuffer actualBuffer = b.getBufferWithoutHeader();
                        if (encoding != DataBlockEncoding.NONE) {
                            Assert.assertEquals((long)0L, (long)actualBuffer.get(0));
                            Assert.assertEquals((long)encoding.getId(), (long)actualBuffer.get(1));
                            actualBuffer.position(2);
                            actualBuffer = actualBuffer.slice();
                        }
                        ByteBuffer expectedBuffer = (ByteBuffer)encodedBlocks.get(blockId);
                        expectedBuffer.rewind();
                        TestHFileBlock.assertBuffersEqual(expectedBuffer, actualBuffer, algo, encoding, pread);
                    }
                    is.close();
                }
            }
        }
    }

    public static final class Writer
    extends HFileBlock.Writer {
        private static final int HEADER_SIZE = 24;
        private static final boolean DONT_FILL_HEADER = false;
        private static final byte[] DUMMY_HEADER = HFileBlock.DUMMY_HEADER_NO_CHECKSUM;
        private State state = State.INIT;
        private final Compression.Algorithm compressAlgo;
        private final HFileDataBlockEncoder dataBlockEncoder;
        private HFileBlockEncodingContext dataBlockEncodingCtx;
        private HFileBlockDefaultEncodingContext defaultBlockEncodingCtx;
        private ByteArrayOutputStream baosInMemory;
        private Compressor compressor;
        private BlockType blockType;
        private DataOutputStream userDataStream;
        private byte[] onDiskBytesWithHeader;
        private byte[] uncompressedBytesWithHeader;
        private long startOffset;
        private long[] prevOffsetByType;
        private long prevOffset;
        private int unencodedDataSizeWritten;

        public Writer(Compression.Algorithm compressionAlgorithm, HFileDataBlockEncoder dataBlockEncoder, boolean includesMemstoreTS, boolean includesTag) {
            this(dataBlockEncoder, new HFileContextBuilder().withHBaseCheckSum(false).withIncludesMvcc(includesMemstoreTS).withIncludesTags(includesTag).withCompression(compressionAlgorithm).build());
        }

        public Writer(HFileDataBlockEncoder dataBlockEncoder, HFileContext meta) {
            super(dataBlockEncoder, meta);
            this.compressAlgo = meta.getCompression() == null ? Compression.Algorithm.NONE : meta.getCompression();
            this.dataBlockEncoder = dataBlockEncoder != null ? dataBlockEncoder : NoOpDataBlockEncoder.INSTANCE;
            this.defaultBlockEncodingCtx = new HFileBlockDefaultEncodingContext(null, DUMMY_HEADER, meta);
            this.dataBlockEncodingCtx = this.dataBlockEncoder.newDataBlockEncodingContext(DUMMY_HEADER, meta);
            this.baosInMemory = new ByteArrayOutputStream();
            this.prevOffsetByType = new long[BlockType.values().length];
            for (int i = 0; i < this.prevOffsetByType.length; ++i) {
                this.prevOffsetByType[i] = -1L;
            }
        }

        @Override
        public DataOutputStream startWriting(BlockType newBlockType) throws IOException {
            if (this.state == State.BLOCK_READY && this.startOffset != -1L) {
                this.prevOffsetByType[this.blockType.getId()] = this.startOffset;
            }
            this.startOffset = -1L;
            this.blockType = newBlockType;
            this.baosInMemory.reset();
            this.baosInMemory.write(DUMMY_HEADER);
            this.state = State.WRITING;
            this.userDataStream = new DataOutputStream(this.baosInMemory);
            if (newBlockType == BlockType.DATA) {
                this.dataBlockEncoder.startBlockEncoding(this.dataBlockEncodingCtx, this.userDataStream);
            }
            this.unencodedDataSizeWritten = 0;
            return this.userDataStream;
        }

        @Override
        public void write(Cell c) throws IOException {
            KeyValue kv = KeyValueUtil.ensureKeyValue(c);
            this.expectState(State.WRITING);
            this.dataBlockEncoder.encode(kv, this.dataBlockEncodingCtx, this.userDataStream);
            this.unencodedDataSizeWritten += kv.getLength();
            if (this.dataBlockEncodingCtx.getHFileContext().isIncludesMvcc()) {
                this.unencodedDataSizeWritten += WritableUtils.getVIntSize((long)kv.getMvccVersion());
            }
        }

        @Override
        DataOutputStream getUserDataStream() {
            this.expectState(State.WRITING);
            return this.userDataStream;
        }

        @Override
        void ensureBlockReady() throws IOException {
            Preconditions.checkState(this.state != State.INIT, "Unexpected state: " + (Object)((Object)this.state));
            if (this.state == State.BLOCK_READY) {
                return;
            }
            this.finishBlock();
        }

        void finishBlock() throws IOException {
            if (this.blockType == BlockType.DATA) {
                this.dataBlockEncoder.endBlockEncoding(this.dataBlockEncodingCtx, this.userDataStream, this.baosInMemory.toByteArray(), this.blockType);
                this.blockType = this.dataBlockEncodingCtx.getBlockType();
            }
            this.userDataStream.flush();
            this.uncompressedBytesWithHeader = this.baosInMemory.toByteArray();
            this.prevOffset = this.prevOffsetByType[this.blockType.getId()];
            this.state = State.BLOCK_READY;
            this.onDiskBytesWithHeader = this.blockType == BlockType.DATA || this.blockType == BlockType.ENCODED_DATA ? this.dataBlockEncodingCtx.compressAndEncrypt(this.uncompressedBytesWithHeader) : this.defaultBlockEncodingCtx.compressAndEncrypt(this.uncompressedBytesWithHeader);
            this.putHeader(this.onDiskBytesWithHeader, 0, this.onDiskBytesWithHeader.length, this.uncompressedBytesWithHeader.length);
            this.putHeader(this.uncompressedBytesWithHeader, 0, this.onDiskBytesWithHeader.length, this.uncompressedBytesWithHeader.length);
        }

        private void putHeader(byte[] dest, int offset, int onDiskSize, int uncompressedSize) {
            offset = this.blockType.put(dest, offset);
            offset = Bytes.putInt(dest, offset, onDiskSize - 24);
            offset = Bytes.putInt(dest, offset, uncompressedSize - 24);
            Bytes.putLong(dest, offset, this.prevOffset);
        }

        @Override
        public void writeHeaderAndData(FSDataOutputStream out) throws IOException {
            long offset = out.getPos();
            if (this.startOffset != -1L && offset != this.startOffset) {
                throw new IOException("A " + (Object)((Object)this.blockType) + " block written to a " + "stream twice, first at offset " + this.startOffset + ", then at " + offset);
            }
            this.startOffset = offset;
            this.writeHeaderAndData((DataOutputStream)out);
        }

        private void writeHeaderAndData(DataOutputStream out) throws IOException {
            this.ensureBlockReady();
            out.write(this.onDiskBytesWithHeader);
        }

        public byte[] getHeaderAndData() throws IOException {
            this.ensureBlockReady();
            return this.onDiskBytesWithHeader;
        }

        public void releaseCompressor() {
            if (this.compressor != null) {
                this.compressAlgo.returnCompressor(this.compressor);
                this.compressor = null;
            }
        }

        @Override
        public int getOnDiskSizeWithoutHeader() {
            this.expectState(State.BLOCK_READY);
            return this.onDiskBytesWithHeader.length - 24;
        }

        @Override
        public int getOnDiskSizeWithHeader() {
            this.expectState(State.BLOCK_READY);
            return this.onDiskBytesWithHeader.length;
        }

        @Override
        public int getUncompressedSizeWithoutHeader() {
            this.expectState(State.BLOCK_READY);
            return this.uncompressedBytesWithHeader.length - 24;
        }

        @Override
        public int getUncompressedSizeWithHeader() {
            this.expectState(State.BLOCK_READY);
            return this.uncompressedBytesWithHeader.length;
        }

        @Override
        public boolean isWriting() {
            return this.state == State.WRITING;
        }

        @Override
        public int blockSizeWritten() {
            if (this.state != State.WRITING) {
                return 0;
            }
            return this.unencodedDataSizeWritten;
        }

        private byte[] getUncompressedDataWithHeader() {
            this.expectState(State.BLOCK_READY);
            return this.uncompressedBytesWithHeader;
        }

        private void expectState(State expectedState) {
            if (this.state != expectedState) {
                throw new IllegalStateException("Expected state: " + (Object)((Object)expectedState) + ", actual state: " + (Object)((Object)this.state));
            }
        }

        @Override
        public ByteBuffer getUncompressedBufferWithHeader() {
            byte[] b = this.getUncompressedDataWithHeader();
            return ByteBuffer.wrap(b, 0, b.length);
        }

        @Override
        public void writeBlock(HFileBlock.BlockWritable bw, FSDataOutputStream out) throws IOException {
            bw.writeToBlock(this.startWriting(bw.getBlockType()));
            this.writeHeaderAndData(out);
        }

        public HFileBlock getBlockForCaching() {
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(false).withChecksumType(ChecksumType.NULL).withBytesPerCheckSum(0).build();
            return new HFileBlock(this.blockType, this.getOnDiskSizeWithoutHeader(), this.getUncompressedSizeWithoutHeader(), this.prevOffset, this.getUncompressedBufferWithHeader(), false, this.startOffset, this.getOnDiskSizeWithoutHeader(), meta);
        }

        private static enum State {
            INIT,
            WRITING,
            BLOCK_READY;

        }
    }
}

