/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.util.regex.Matcher;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileLink {
    @Test
    public void testValidLinkNames() {
        String[] validLinkNames;
        for (String name : validLinkNames = new String[]{"foo=fefefe-0123456", "ns=foo=abababa-fefefefe"}) {
            Assert.assertTrue((String)("Failed validating:" + name), (boolean)name.matches(HFileLink.LINK_NAME_REGEX));
        }
        for (String name : validLinkNames) {
            Assert.assertTrue((String)("Failed validating:" + name), (boolean)HFileLink.isHFileLink(name));
        }
        String testName = "foo=fefefe-0123456";
        Assert.assertEquals((Object)TableName.valueOf("foo"), (Object)HFileLink.getReferencedTableName(testName));
        Assert.assertEquals((Object)"fefefe", (Object)HFileLink.getReferencedRegionName(testName));
        Assert.assertEquals((Object)"0123456", (Object)HFileLink.getReferencedHFileName(testName));
        Assert.assertEquals((Object)testName, (Object)HFileLink.createHFileLinkName(TableName.valueOf("foo"), "fefefe", "0123456"));
        testName = "ns=foo=fefefe-0123456";
        Assert.assertEquals((Object)TableName.valueOf("ns", "foo"), (Object)HFileLink.getReferencedTableName(testName));
        Assert.assertEquals((Object)"fefefe", (Object)HFileLink.getReferencedRegionName(testName));
        Assert.assertEquals((Object)"0123456", (Object)HFileLink.getReferencedHFileName(testName));
        Assert.assertEquals((Object)testName, (Object)HFileLink.createHFileLinkName(TableName.valueOf("ns", "foo"), "fefefe", "0123456"));
        for (String name : validLinkNames) {
            Matcher m = HFileLink.LINK_NAME_PATTERN.matcher(name);
            Assert.assertTrue((boolean)m.matches());
            Assert.assertEquals((Object)HFileLink.getReferencedTableName(name), (Object)TableName.valueOf(m.group(1), m.group(2)));
            Assert.assertEquals((Object)HFileLink.getReferencedRegionName(name), (Object)m.group(3));
            Assert.assertEquals((Object)HFileLink.getReferencedHFileName(name), (Object)m.group(4));
        }
    }

    @Test
    public void testBackReference() {
        TableName[] refTables;
        Path rootDir = new Path("/root");
        Path archiveDir = new Path(rootDir, ".archive");
        String storeFileName = "121212";
        String linkDir = ".links-" + storeFileName;
        String encodedRegion = "FEFE";
        String cf = "cf1";
        for (TableName refTable : refTables = new TableName[]{TableName.valueOf("refTable"), TableName.valueOf("ns", "refTable")}) {
            TableName[] tableNames;
            Path refTableDir = FSUtils.getTableDir(archiveDir, refTable);
            Path refRegionDir = HRegion.getRegionDir(refTableDir, encodedRegion);
            Path refDir = new Path(refRegionDir, cf);
            Path refLinkDir = new Path(refDir, linkDir);
            String refStoreFileName = refTable.getNameAsString().replace(':', '=') + "=" + encodedRegion + "-" + storeFileName;
            for (TableName tableName : tableNames = new TableName[]{TableName.valueOf("tableName1"), TableName.valueOf("ns", "tableName2")}) {
                Path tableDir = FSUtils.getTableDir(rootDir, tableName);
                Path regionDir = HRegion.getRegionDir(tableDir, encodedRegion);
                Path cfDir = new Path(regionDir, cf);
                Assert.assertEquals((Object)(encodedRegion + "." + tableName.getNameAsString().replace(':', '=')), (Object)HFileLink.createBackReferenceName(tableName.getNameAsString(), encodedRegion));
                Pair<TableName, String> parsedRef = HFileLink.parseBackReferenceName(encodedRegion + "." + tableName.getNameAsString().replace(':', '='));
                Assert.assertEquals((Object)parsedRef.getFirst(), (Object)tableName);
                Assert.assertEquals((Object)parsedRef.getSecond(), (Object)encodedRegion);
                Path storeFileDir = new Path(refLinkDir, encodedRegion + "." + tableName.getNameAsString().replace(':', '='));
                Path linkPath = new Path(cfDir, refStoreFileName);
                Assert.assertEquals((Object)linkPath, (Object)HFileLink.getHFileFromBackReference(rootDir, storeFileDir));
            }
        }
    }
}

