/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;

public class FSDataInputStreamWrapper {
    private final HFileSystem hfs;
    private final Path path;
    private final FileLink link;
    private final boolean doCloseStreams;
    private volatile FSDataInputStream stream = null;
    private volatile FSDataInputStream streamNoFsChecksum = null;
    private Object streamNoFsChecksumFirstCreateLock = new Object();
    private boolean useHBaseChecksumConfigured;
    private volatile boolean useHBaseChecksum;
    private volatile int hbaseChecksumOffCount = -1;

    public FSDataInputStreamWrapper(FileSystem fs, Path path) throws IOException {
        this(fs, null, path);
    }

    public FSDataInputStreamWrapper(FileSystem fs, FileLink link) throws IOException {
        this(fs, link, null);
    }

    private FSDataInputStreamWrapper(FileSystem fs, FileLink link, Path path) throws IOException {
        assert (path == null != (link == null));
        this.path = path;
        this.link = link;
        this.doCloseStreams = true;
        this.hfs = fs instanceof HFileSystem ? (HFileSystem)fs : new HFileSystem(fs);
        this.useHBaseChecksum = false;
        this.useHBaseChecksumConfigured = false;
        this.stream = link != null ? link.open((FileSystem)this.hfs) : this.hfs.open(path);
    }

    public void prepareForBlockReader(boolean forceNoHBaseChecksum) throws IOException {
        boolean useHBaseChecksum;
        if (this.hfs == null) {
            return;
        }
        assert (this.stream != null && !this.useHBaseChecksumConfigured);
        boolean bl = useHBaseChecksum = !forceNoHBaseChecksum && this.hfs.useHBaseChecksum() && this.hfs.getNoChecksumFs() != this.hfs;
        if (useHBaseChecksum) {
            FileSystem fsNc = this.hfs.getNoChecksumFs();
            this.streamNoFsChecksum = this.link != null ? this.link.open(fsNc) : fsNc.open(this.path);
            this.useHBaseChecksumConfigured = this.useHBaseChecksum = useHBaseChecksum;
            this.stream.close();
            this.stream = null;
        }
    }

    @VisibleForTesting
    public FSDataInputStreamWrapper(FSDataInputStream fsdis) {
        this(fsdis, fsdis);
    }

    @VisibleForTesting
    public FSDataInputStreamWrapper(FSDataInputStream fsdis, FSDataInputStream noChecksum) {
        this.doCloseStreams = false;
        this.stream = fsdis;
        this.streamNoFsChecksum = noChecksum;
        this.path = null;
        this.link = null;
        this.hfs = null;
        this.useHBaseChecksum = false;
        this.useHBaseChecksumConfigured = false;
    }

    public boolean shouldUseHBaseChecksum() {
        return this.useHBaseChecksum;
    }

    public FSDataInputStream getStream(boolean useHBaseChecksum) {
        return useHBaseChecksum ? this.streamNoFsChecksum : this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream fallbackToFsChecksum(int offCount) throws IOException {
        boolean partOfConvoy = false;
        if (this.stream == null) {
            Object object = this.streamNoFsChecksumFirstCreateLock;
            synchronized (object) {
                boolean bl = partOfConvoy = this.stream != null;
                if (!partOfConvoy) {
                    this.stream = this.link != null ? this.link.open((FileSystem)this.hfs) : this.hfs.open(this.path);
                }
            }
        }
        if (!partOfConvoy) {
            this.useHBaseChecksum = false;
            this.hbaseChecksumOffCount = offCount;
        }
        return this.stream;
    }

    public void checksumOk() {
        if (this.useHBaseChecksumConfigured && !this.useHBaseChecksum && this.hbaseChecksumOffCount-- < 0) {
            assert (this.streamNoFsChecksum != null);
            this.useHBaseChecksum = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.doCloseStreams) {
            return;
        }
        try {
            if (this.stream != this.streamNoFsChecksum && this.streamNoFsChecksum != null) {
                this.streamNoFsChecksum.close();
                this.streamNoFsChecksum = null;
            }
        }
        finally {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }

    public HFileSystem getHfs() {
        return this.hfs;
    }
}

