/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.BoundedArrayQueue;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class BoundedByteBufferPool {
    private final Log LOG = LogFactory.getLog(this.getClass());
    @VisibleForTesting
    final Queue<ByteBuffer> buffers;
    private final int maxByteBufferSizeToCache;
    @VisibleForTesting
    volatile int runningAverage;
    private volatile int totalReservoirCapacity;
    private AtomicLong allocations = new AtomicLong(0L);
    private ReentrantLock lock = new ReentrantLock();

    public BoundedByteBufferPool(int maxByteBufferSizeToCache, int initialByteBufferSize, int maxToCache) {
        this.maxByteBufferSizeToCache = maxByteBufferSizeToCache;
        this.runningAverage = initialByteBufferSize;
        this.buffers = new BoundedArrayQueue<ByteBuffer>(maxToCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuffer() {
        ByteBuffer bb = null;
        this.lock.lock();
        try {
            bb = this.buffers.poll();
            if (bb != null) {
                this.totalReservoirCapacity -= bb.capacity();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (bb != null) {
            bb.clear();
        } else {
            bb = ByteBuffer.allocate(this.runningAverage);
            this.allocations.incrementAndGet();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("runningAverage=" + this.runningAverage + ", totalCapacity=" + this.totalReservoirCapacity + ", count=" + this.buffers.size() + ", alloctions=" + this.allocations.get());
        }
        return bb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBuffer(ByteBuffer bb) {
        if (bb.capacity() > this.maxByteBufferSizeToCache) {
            return;
        }
        boolean success = false;
        int average = 0;
        this.lock.lock();
        try {
            success = this.buffers.offer(bb);
            if (success) {
                this.totalReservoirCapacity += bb.capacity();
                average = this.totalReservoirCapacity / this.buffers.size();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!success) {
            this.LOG.warn("At capacity: " + this.buffers.size());
        } else if (average > this.runningAverage && average < this.maxByteBufferSizeToCache) {
            this.runningAverage = average;
        }
    }
}

