/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.http.AdminAuthorizedServlet;
import org.apache.hadoop.hbase.http.FilterContainer;
import org.apache.hadoop.hbase.http.FilterInitializer;
import org.apache.hadoop.hbase.http.HtmlQuoting;
import org.apache.hadoop.hbase.http.HttpRequestLog;
import org.apache.hadoop.hbase.http.NoCacheFilter;
import org.apache.hadoop.hbase.http.SslSocketConnectorSecure;
import org.apache.hadoop.hbase.http.conf.ConfServlet;
import org.apache.hadoop.hbase.http.jmx.JMXJsonServlet;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.metrics.MetricsServlet;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.MultiException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HttpServer
implements FilterContainer {
    public static final Log LOG = LogFactory.getLog(HttpServer.class);
    static final String FILTER_INITIALIZERS_PROPERTY = "hbase.http.filter.initializers";
    static final String HTTP_MAX_THREADS = "hbase.http.max.threads";
    public static final String CONF_CONTEXT_ATTRIBUTE = "hbase.conf";
    public static final String ADMINS_ACL = "admins.acl";
    public static final String BIND_ADDRESS = "bind.address";
    public static final String SPNEGO_FILTER = "SpnegoFilter";
    public static final String NO_CACHE_FILTER = "NoCacheFilter";
    public static final String APP_DIR = "webapps";
    private final AccessControlList adminsAcl;
    protected final Server webServer;
    protected String appDir;
    protected String logDir;
    private final List<ListenerInfo> listeners = Lists.newArrayList();
    protected final WebAppContext webAppContext;
    protected final boolean findPort;
    protected final Map<Context, Boolean> defaultContexts = new HashMap<Context, Boolean>();
    protected final List<String> filterNames = new ArrayList<String>();
    static final String STATE_DESCRIPTION_ALIVE = " - alive";
    static final String STATE_DESCRIPTION_NOT_LIVE = " - not live";

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort) throws IOException {
        this(name, bindAddress, port, findPort, new Configuration());
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, Connector connector) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, connector, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, String[] pathSpecs) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null, pathSpecs);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf) throws IOException {
        this(name, bindAddress, port, findPort, conf, null, null, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, null, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, Connector connector) throws IOException {
        this(name, bindAddress, port, findPort, conf, adminsAcl, connector, null);
    }

    @Deprecated
    public HttpServer(String name, String bindAddress, int port, boolean findPort, Configuration conf, AccessControlList adminsAcl, Connector connector, String[] pathSpecs) throws IOException {
        this(new Builder().setName(name).addEndpoint(URI.create("http://" + bindAddress + ":" + port)).setFindPort(findPort).setConf(conf).setACL(adminsAcl).setConnector(connector).setPathSpec(pathSpecs));
    }

    private HttpServer(Builder b) throws IOException {
        this.appDir = b.appDir;
        this.logDir = b.logDir;
        String appDir = this.getWebAppsPath(b.name);
        this.webServer = new Server();
        this.adminsAcl = b.adminsAcl;
        this.webAppContext = HttpServer.createWebAppContext(b.name, b.conf, this.adminsAcl, appDir);
        this.findPort = b.findPort;
        this.initializeWebServer(b.name, b.hostName, b.conf, b.pathSpecs);
    }

    private void initializeWebServer(String name, String hostName, Configuration conf, String[] pathSpecs) throws FileNotFoundException, IOException {
        Preconditions.checkNotNull(this.webAppContext);
        int maxThreads = conf.getInt(HTTP_MAX_THREADS, -1);
        QueuedThreadPool threadPool = maxThreads == -1 ? new QueuedThreadPool() : new QueuedThreadPool(maxThreads);
        threadPool.setDaemon(true);
        this.webServer.setThreadPool((ThreadPool)threadPool);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLog requestLog = HttpRequestLog.getRequestLog(name);
        if (requestLog != null) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog(requestLog);
            HandlerCollection handlers = new HandlerCollection();
            handlers.setHandlers(new Handler[]{requestLogHandler, contexts});
            this.webServer.setHandler((Handler)handlers);
        } else {
            this.webServer.setHandler((Handler)contexts);
        }
        String appDir = this.getWebAppsPath(name);
        this.webServer.addHandler((Handler)this.webAppContext);
        this.addDefaultApps(contexts, appDir, conf);
        this.addGlobalFilter("safety", QuotingInputFilter.class.getName(), null);
        FilterInitializer[] initializers = HttpServer.getFilterInitializers(conf);
        if (initializers != null) {
            conf = new Configuration(conf);
            conf.set(BIND_ADDRESS, hostName);
            for (FilterInitializer c : initializers) {
                c.initFilter(this, conf);
            }
        }
        this.addDefaultServlets();
        if (pathSpecs != null) {
            for (String path : pathSpecs) {
                LOG.info("adding path spec: " + (String)path);
                this.addFilterPathMapping(path, (Context)this.webAppContext);
            }
        }
    }

    private void addUnmanagedListener(Connector connector) {
        this.listeners.add(new ListenerInfo(false, connector));
    }

    private void addManagedListener(Connector connector) {
        this.listeners.add(new ListenerInfo(true, connector));
    }

    private static WebAppContext createWebAppContext(String name, Configuration conf, AccessControlList adminsAcl, String appDir) {
        WebAppContext ctx = new WebAppContext();
        ctx.setDisplayName(name);
        ctx.setContextPath("/");
        ctx.setWar(appDir + "/" + name);
        ctx.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        ctx.getServletContext().setAttribute(ADMINS_ACL, (Object)adminsAcl);
        HttpServer.addNoCacheFilter(ctx);
        return ctx;
    }

    private static void addNoCacheFilter(WebAppContext ctxt) {
        HttpServer.defineFilter((Context)ctxt, NO_CACHE_FILTER, NoCacheFilter.class.getName(), Collections.emptyMap(), new String[]{"/*"});
    }

    public Connector createBaseListener(Configuration conf) throws IOException {
        return HttpServer.createDefaultChannelConnector();
    }

    @InterfaceAudience.Private
    public static Connector createDefaultChannelConnector() {
        SelectChannelConnector ret = new SelectChannelConnector();
        ret.setLowResourceMaxIdleTime(10000);
        ret.setAcceptQueueSize(128);
        ret.setResolveNames(false);
        ret.setUseDirectBuffers(false);
        if (Shell.WINDOWS) {
            ret.setReuseAddress(false);
        }
        ret.setHeaderBufferSize(65536);
        return ret;
    }

    private static FilterInitializer[] getFilterInitializers(Configuration conf) {
        if (conf == null) {
            return null;
        }
        Class[] classes = conf.getClasses(FILTER_INITIALIZERS_PROPERTY, new Class[0]);
        if (classes == null) {
            return null;
        }
        FilterInitializer[] initializers = new FilterInitializer[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            initializers[i] = (FilterInitializer)ReflectionUtils.newInstance((Class)classes[i], (Configuration)conf);
        }
        return initializers;
    }

    protected void addDefaultApps(ContextHandlerCollection parent, String appDir, Configuration conf) throws IOException {
        String logDir = this.logDir;
        if (logDir == null) {
            logDir = System.getProperty("hadoop.log.dir");
        }
        if (logDir != null) {
            Context logContext = new Context((HandlerContainer)parent, "/logs");
            logContext.setResourceBase(logDir);
            logContext.addServlet(AdminAuthorizedServlet.class, "/*");
            if (conf.getBoolean("hbase.jetty.logs.serve.aliases", true)) {
                Map params = logContext.getInitParams();
                params.put("org.mortbay.jetty.servlet.Default.aliases", "true");
            }
            logContext.setDisplayName("logs");
            this.setContextAttributes(logContext, conf);
            HttpServer.addNoCacheFilter(this.webAppContext);
            this.defaultContexts.put(logContext, true);
        }
        Context staticContext = new Context((HandlerContainer)parent, "/static");
        staticContext.setResourceBase(appDir + "/static");
        staticContext.addServlet(DefaultServlet.class, "/*");
        staticContext.setDisplayName("static");
        this.setContextAttributes(staticContext, conf);
        this.defaultContexts.put(staticContext, true);
    }

    private void setContextAttributes(Context context, Configuration conf) {
        context.getServletContext().setAttribute(CONF_CONTEXT_ATTRIBUTE, (Object)conf);
        context.getServletContext().setAttribute(ADMINS_ACL, (Object)this.adminsAcl);
    }

    protected void addDefaultServlets() {
        this.addServlet("stacks", "/stacks", StackServlet.class);
        this.addServlet("logLevel", "/logLevel", LogLevel.Servlet.class);
        this.addServlet("metrics", "/metrics", MetricsServlet.class);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
    }

    public void addContext(Context ctxt, boolean isFiltered) throws IOException {
        this.webServer.addHandler((Handler)ctxt);
        HttpServer.addNoCacheFilter(this.webAppContext);
        this.defaultContexts.put(ctxt, isFiltered);
    }

    protected void addContext(String pathSpec, String dir, boolean isFiltered) throws IOException {
        if (0 == this.webServer.getHandlers().length) {
            throw new RuntimeException("Couldn't find handler");
        }
        WebAppContext webAppCtx = new WebAppContext();
        webAppCtx.setContextPath(pathSpec);
        webAppCtx.setWar(dir);
        this.addContext((Context)webAppCtx, true);
    }

    public void setAttribute(String name, Object value) {
        this.webAppContext.setAttribute(name, value);
    }

    public void addJerseyResourcePackage(String packageName, String pathSpec) {
        LOG.info("addJerseyResourcePackage: packageName=" + packageName + ", pathSpec=" + pathSpec);
        ServletHolder sh = new ServletHolder(ServletContainer.class);
        sh.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        sh.setInitParameter("com.sun.jersey.config.property.packages", packageName);
        this.webAppContext.addServlet(sh, pathSpec);
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
        this.addFilterPathMapping(pathSpec, (Context)this.webAppContext);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        this.addInternalServlet(name, pathSpec, clazz, false);
    }

    public void addInternalServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz, boolean requireAuth) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
        if (requireAuth && UserGroupInformation.isSecurityEnabled()) {
            LOG.info("Adding Kerberos (SPNEGO) filter to " + name);
            ServletHandler handler = this.webAppContext.getServletHandler();
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(SPNEGO_FILTER);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    @Override
    public void addFilter(String name, String classname, Map<String, String> parameters) {
        String[] USER_FACING_URLS = new String[]{"*.html", "*.jsp"};
        HttpServer.defineFilter((Context)this.webAppContext, name, classname, parameters, USER_FACING_URLS);
        LOG.info("Added filter " + name + " (class=" + classname + ") to context " + this.webAppContext.getDisplayName());
        String[] ALL_URLS = new String[]{"/*"};
        for (Map.Entry<Context, Boolean> e : this.defaultContexts.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            Context ctx = e.getKey();
            HttpServer.defineFilter(ctx, name, classname, parameters, ALL_URLS);
            LOG.info("Added filter " + name + " (class=" + classname + ") to context " + ctx.getDisplayName());
        }
        this.filterNames.add(name);
    }

    @Override
    public void addGlobalFilter(String name, String classname, Map<String, String> parameters) {
        String[] ALL_URLS = new String[]{"/*"};
        HttpServer.defineFilter((Context)this.webAppContext, name, classname, parameters, ALL_URLS);
        for (Context ctx : this.defaultContexts.keySet()) {
            HttpServer.defineFilter(ctx, name, classname, parameters, ALL_URLS);
        }
        LOG.info("Added global filter '" + name + "' (class=" + classname + ")");
    }

    public static void defineFilter(Context ctx, String name, String classname, Map<String, String> parameters, String[] urls) {
        FilterHolder holder = new FilterHolder();
        holder.setName(name);
        holder.setClassName(classname);
        holder.setInitParameters(parameters);
        FilterMapping fmap = new FilterMapping();
        fmap.setPathSpecs(urls);
        fmap.setDispatches(15);
        fmap.setFilterName(name);
        ServletHandler handler = ctx.getServletHandler();
        handler.addFilter(holder, fmap);
    }

    protected void addFilterPathMapping(String pathSpec, Context webAppCtx) {
        ServletHandler handler = webAppCtx.getServletHandler();
        for (String name : this.filterNames) {
            FilterMapping fmap = new FilterMapping();
            fmap.setPathSpec(pathSpec);
            fmap.setFilterName(name);
            fmap.setDispatches(15);
            handler.addFilterMapping(fmap);
        }
    }

    public Object getAttribute(String name) {
        return this.webAppContext.getAttribute(name);
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public String getWebAppsPath(String appName) throws FileNotFoundException {
        return this.getWebAppsPath(this.appDir, appName);
    }

    protected String getWebAppsPath(String webapps, String appName) throws FileNotFoundException {
        URL url = this.getClass().getClassLoader().getResource(webapps + "/" + appName);
        if (url == null) {
            throw new FileNotFoundException(webapps + "/" + appName + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    @Deprecated
    public int getPort() {
        return this.webServer.getConnectors()[0].getLocalPort();
    }

    public InetSocketAddress getConnectorAddress(int index) {
        Preconditions.checkArgument(index >= 0);
        if (index > this.webServer.getConnectors().length) {
            return null;
        }
        Connector c = this.webServer.getConnectors()[index];
        if (c.getLocalPort() == -1) {
            return null;
        }
        return new InetSocketAddress(c.getHost(), c.getLocalPort());
    }

    public void setThreads(int min, int max) {
        QueuedThreadPool pool = (QueuedThreadPool)this.webServer.getThreadPool();
        pool.setMinThreads(min);
        pool.setMaxThreads(max);
    }

    private void initSpnego(Configuration conf, String hostName, String usernameConfKey, String keytabConfKey) throws IOException {
        String httpKeytab;
        HashMap<String, String> params = new HashMap<String, String>();
        String principalInConf = conf.get(usernameConfKey);
        if (principalInConf != null && !principalInConf.isEmpty()) {
            params.put("kerberos.principal", SecurityUtil.getServerPrincipal((String)principalInConf, (String)hostName));
        }
        if ((httpKeytab = conf.get(keytabConfKey)) != null && !httpKeytab.isEmpty()) {
            params.put("kerberos.keytab", httpKeytab);
        }
        params.put("type", "kerberos");
        HttpServer.defineFilter((Context)this.webAppContext, SPNEGO_FILTER, AuthenticationFilter.class.getName(), params, null);
    }

    public void start() throws IOException {
        try {
            try {
                this.openListeners();
                this.webServer.start();
            }
            catch (IOException ex) {
                LOG.info("HttpServer.start() threw a non Bind IOException", ex);
                throw ex;
            }
            catch (MultiException ex) {
                LOG.info("HttpServer.start() threw a MultiException", ex);
                throw ex;
            }
            Handler[] handlers = this.webServer.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!handlers[i].isFailed()) continue;
                throw new IOException("Problem in starting http server. Server handlers failed");
            }
            Throwable unavailableException = this.webAppContext.getUnavailableException();
            if (unavailableException != null) {
                this.webServer.stop();
                throw new IOException("Unable to initialize WebAppContext", unavailableException);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException("Interrupted while starting HTTP server").initCause(e);
        }
        catch (Exception e) {
            throw new IOException("Problem starting http server", e);
        }
    }

    private void loadListeners() {
        for (ListenerInfo li : this.listeners) {
            this.webServer.addConnector(li.listener);
        }
    }

    void openListeners() throws Exception {
        block2: for (ListenerInfo li : this.listeners) {
            Connector listener = li.listener;
            if (!li.isManaged || li.listener.getLocalPort() != -1) continue;
            int port = listener.getPort();
            while (true) {
                try {
                    listener.close();
                    listener.open();
                    LOG.info("Jetty bound to port " + listener.getLocalPort());
                    continue block2;
                }
                catch (BindException ex) {
                    if (port == 0 || !this.findPort) {
                        BindException be = new BindException("Port in use: " + listener.getHost() + ":" + listener.getPort());
                        be.initCause(ex);
                        throw be;
                    }
                    listener.setPort(++port);
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
    }

    public void stop() throws Exception {
        MultiException exception = null;
        for (ListenerInfo li : this.listeners) {
            if (!li.isManaged) continue;
            try {
                li.listener.close();
            }
            catch (Exception e) {
                LOG.error("Error while stopping listener for webapp" + this.webAppContext.getDisplayName(), e);
                exception = this.addMultiException(exception, e);
            }
        }
        try {
            this.webAppContext.clearAttributes();
            this.webAppContext.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web app context for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        try {
            this.webServer.stop();
        }
        catch (Exception e) {
            LOG.error("Error while stopping web server for webapp " + this.webAppContext.getDisplayName(), e);
            exception = this.addMultiException(exception, e);
        }
        if (exception != null) {
            exception.ifExceptionThrow();
        }
    }

    private MultiException addMultiException(MultiException exception, Exception e) {
        if (exception == null) {
            exception = new MultiException();
        }
        exception.add((Throwable)e);
        return exception;
    }

    public void join() throws InterruptedException {
        this.webServer.join();
    }

    public boolean isAlive() {
        return this.webServer != null && this.webServer.isStarted();
    }

    public String toString() {
        if (this.listeners.size() == 0) {
            return "Inactive HttpServer";
        }
        StringBuilder sb = new StringBuilder("HttpServer (").append(this.isAlive() ? STATE_DESCRIPTION_ALIVE : STATE_DESCRIPTION_NOT_LIVE).append("), listening at:");
        for (ListenerInfo li : this.listeners) {
            Connector l = li.listener;
            sb.append(l.getHost()).append(":").append(l.getPort()).append("/,");
        }
        return sb.toString();
    }

    public static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    public static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer.userHasAdministratorAccess(servletContext, remoteUser)) {
            response.sendError(401, "User " + remoteUser + " is unauthorized to access this page.");
            return false;
        }
        return true;
    }

    public static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    public static class QuotingInputFilter
    implements Filter {
        private FilterConfig config;

        @Override
        public void init(FilterConfig config) throws ServletException {
            this.config = config;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            RequestQuoter quoted = new RequestQuoter((HttpServletRequest)request);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String mime = this.inferMimeType(request);
            if (mime == null) {
                httpResponse.setContentType("text/plain; charset=utf-8");
            } else if (mime.startsWith("text/html")) {
                httpResponse.setContentType("text/html; charset=utf-8");
            } else if (mime.startsWith("application/xml")) {
                httpResponse.setContentType("text/xml; charset=utf-8");
            }
            chain.doFilter(quoted, httpResponse);
        }

        private String inferMimeType(ServletRequest request) {
            String path = ((HttpServletRequest)request).getRequestURI();
            ContextHandler.SContext sContext = (ContextHandler.SContext)this.config.getServletContext();
            MimeTypes mimes = sContext.getContextHandler().getMimeTypes();
            Buffer mimeBuffer = mimes.getMimeByExtension(path);
            return mimeBuffer == null ? null : mimeBuffer.toString();
        }

        public static class RequestQuoter
        extends HttpServletRequestWrapper {
            private final HttpServletRequest rawRequest;

            public RequestQuoter(HttpServletRequest rawRequest) {
                super(rawRequest);
                this.rawRequest = rawRequest;
            }

            @Override
            public Enumeration<String> getParameterNames() {
                return new Enumeration<String>(){
                    private Enumeration<String> rawIterator;
                    {
                        this.rawIterator = RequestQuoter.this.rawRequest.getParameterNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.rawIterator.hasMoreElements();
                    }

                    @Override
                    public String nextElement() {
                        return HtmlQuoting.quoteHtmlChars(this.rawIterator.nextElement());
                    }
                };
            }

            @Override
            public String getParameter(String name) {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getParameter(HtmlQuoting.unquoteHtmlChars(name)));
            }

            @Override
            public String[] getParameterValues(String name) {
                String unquoteName = HtmlQuoting.unquoteHtmlChars(name);
                String[] unquoteValue = this.rawRequest.getParameterValues(unquoteName);
                if (unquoteValue == null) {
                    return null;
                }
                String[] result = new String[unquoteValue.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = HtmlQuoting.quoteHtmlChars(unquoteValue[i]);
                }
                return result;
            }

            @Override
            public Map<String, String[]> getParameterMap() {
                HashMap<String, String[]> result = new HashMap<String, String[]>();
                Map<String, String[]> raw = this.rawRequest.getParameterMap();
                for (Map.Entry<String, String[]> item : raw.entrySet()) {
                    String[] rawValue = item.getValue();
                    String[] cookedValue = new String[rawValue.length];
                    for (int i = 0; i < rawValue.length; ++i) {
                        cookedValue[i] = HtmlQuoting.quoteHtmlChars(rawValue[i]);
                    }
                    result.put(HtmlQuoting.quoteHtmlChars(item.getKey()), cookedValue);
                }
                return result;
            }

            @Override
            public StringBuffer getRequestURL() {
                String url = this.rawRequest.getRequestURL().toString();
                return new StringBuffer(HtmlQuoting.quoteHtmlChars(url));
            }

            @Override
            public String getServerName() {
                return HtmlQuoting.quoteHtmlChars(this.rawRequest.getServerName());
            }
        }
    }

    public static class StackServlet
    extends HttpServlet {
        private static final long serialVersionUID = -6284183679759467039L;

        @Override
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            response.setContentType("text/plain; charset=UTF-8");
            try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
                Threads.printThreadInfo(out, "");
                out.flush();
            }
            ReflectionUtils.logThreadInfo((Log)LOG, (String)"jsp requested", (long)1L);
        }
    }

    public static class Builder {
        private ArrayList<URI> endpoints = Lists.newArrayList();
        private Connector connector;
        private Configuration conf;
        private String[] pathSpecs;
        private AccessControlList adminsAcl;
        private boolean securityEnabled = false;
        private String usernameConfKey;
        private String keytabConfKey;
        private boolean needsClientAuth;
        private String hostName;
        private String appDir = "webapps";
        private String logDir;
        private boolean findPort;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStore;
        private String keyStorePassword;
        private String keyStoreType;
        private String keyPassword;
        @Deprecated
        private String name;
        @Deprecated
        private String bindAddress;
        @Deprecated
        private int port = -1;

        public Builder addEndpoint(URI endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder trustStore(String location, String password, String type) {
            this.trustStore = location;
            this.trustStorePassword = password;
            this.trustStoreType = type;
            return this;
        }

        public Builder keyStore(String location, String password, String type) {
            this.keyStore = location;
            this.keyStorePassword = password;
            this.keyStoreType = type;
            return this;
        }

        public Builder keyPassword(String password) {
            this.keyPassword = password;
            return this;
        }

        public Builder needsClientAuth(boolean value) {
            this.needsClientAuth = value;
            return this;
        }

        @Deprecated
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Deprecated
        public Builder setBindAddress(String bindAddress) {
            this.bindAddress = bindAddress;
            return this;
        }

        @Deprecated
        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setFindPort(boolean findPort) {
            this.findPort = findPort;
            return this;
        }

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setConnector(Connector connector) {
            this.connector = connector;
            return this;
        }

        public Builder setPathSpec(String[] pathSpec) {
            this.pathSpecs = pathSpec;
            return this;
        }

        public Builder setACL(AccessControlList acl) {
            this.adminsAcl = acl;
            return this;
        }

        public Builder setSecurityEnabled(boolean securityEnabled) {
            this.securityEnabled = securityEnabled;
            return this;
        }

        public Builder setUsernameConfKey(String usernameConfKey) {
            this.usernameConfKey = usernameConfKey;
            return this;
        }

        public Builder setKeytabConfKey(String keytabConfKey) {
            this.keytabConfKey = keytabConfKey;
            return this;
        }

        public Builder setAppDir(String appDir) {
            this.appDir = appDir;
            return this;
        }

        public Builder setLogDir(String logDir) {
            this.logDir = logDir;
            return this;
        }

        public HttpServer build() throws IOException {
            if (this.name == null) {
                throw new HadoopIllegalArgumentException("name is not set");
            }
            if (this.bindAddress != null && this.port != -1) {
                try {
                    this.endpoints.add(0, new URI("http", "", this.bindAddress, this.port, "", "", ""));
                }
                catch (URISyntaxException e) {
                    throw new HadoopIllegalArgumentException("Invalid endpoint: " + e);
                }
            }
            if (this.endpoints.size() == 0 && this.connector == null) {
                throw new HadoopIllegalArgumentException("No endpoints specified");
            }
            if (this.hostName == null) {
                String string = this.hostName = this.endpoints.size() == 0 ? this.connector.getHost() : this.endpoints.get(0).getHost();
            }
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            HttpServer server = new HttpServer(this);
            if (this.securityEnabled) {
                server.initSpnego(this.conf, this.hostName, this.usernameConfKey, this.keytabConfKey);
            }
            if (this.connector != null) {
                server.addUnmanagedListener(this.connector);
            }
            for (URI ep : this.endpoints) {
                Object listener = null;
                String scheme = ep.getScheme();
                if ("http".equals(scheme)) {
                    listener = HttpServer.createDefaultChannelConnector();
                } else if ("https".equals(scheme)) {
                    SslSocketConnectorSecure c = new SslSocketConnectorSecure();
                    c.setNeedClientAuth(this.needsClientAuth);
                    c.setKeyPassword(this.keyPassword);
                    if (this.keyStore != null) {
                        c.setKeystore(this.keyStore);
                        c.setKeystoreType(this.keyStoreType);
                        c.setPassword(this.keyStorePassword);
                    }
                    if (this.trustStore != null) {
                        c.setTruststore(this.trustStore);
                        c.setTruststoreType(this.trustStoreType);
                        c.setTrustPassword(this.trustStorePassword);
                    }
                    listener = c;
                } else {
                    throw new HadoopIllegalArgumentException("unknown scheme for endpoint:" + ep);
                }
                listener.setHost(ep.getHost());
                listener.setPort(ep.getPort() == -1 ? 0 : ep.getPort());
                server.addManagedListener(listener);
            }
            server.loadListeners();
            return server;
        }
    }

    private static class ListenerInfo {
        private final boolean isManaged;
        private final Connector listener;

        private ListenerInfo(boolean isManaged, Connector listener) {
            this.isManaged = isManaged;
            this.listener = listener;
        }
    }
}

