/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestInclusiveStopFilter {
    private final byte[] STOP_ROW = Bytes.toBytes("stop_row");
    private final byte[] GOOD_ROW = Bytes.toBytes("good_row");
    private final byte[] PAST_STOP_ROW = Bytes.toBytes("zzzzzz");
    Filter mainFilter;

    @Before
    public void setUp() throws Exception {
        this.mainFilter = new InclusiveStopFilter(this.STOP_ROW);
    }

    @Test
    public void testStopRowIdentification() throws Exception {
        this.stopRowTests(this.mainFilter);
    }

    @Test
    public void testSerialization() throws Exception {
        byte[] buffer = this.mainFilter.toByteArray();
        InclusiveStopFilter newFilter = InclusiveStopFilter.parseFrom(buffer);
        this.stopRowTests(newFilter);
    }

    private void stopRowTests(Filter filter) throws Exception {
        Assert.assertFalse((String)("Filtering on " + Bytes.toString(this.GOOD_ROW)), (boolean)filter.filterRowKey(this.GOOD_ROW, 0, this.GOOD_ROW.length));
        Assert.assertFalse((String)("Filtering on " + Bytes.toString(this.STOP_ROW)), (boolean)filter.filterRowKey(this.STOP_ROW, 0, this.STOP_ROW.length));
        Assert.assertTrue((String)("Filtering on " + Bytes.toString(this.PAST_STOP_ROW)), (boolean)filter.filterRowKey(this.PAST_STOP_ROW, 0, this.PAST_STOP_ROW.length));
        Assert.assertTrue((String)"FilterAllRemaining", (boolean)filter.filterAllRemaining());
        Assert.assertFalse((String)"FilterNotNull", (boolean)filter.filterRow());
        Assert.assertFalse((String)"Filter a null", (boolean)filter.filterRowKey(null, 0, 0));
    }
}

