/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFuzzyRowFilter {
    @Test
    public void testSatisfiesNoUnsafeForward() {
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, -128, 1, 0, 1}, 0, 5, new byte[]{1, 0, 1}, new byte[]{0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, -128, 2, 0, 1}, 0, 5, new byte[]{1, 0, 1}, new byte[]{0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, 2, 1, 3, 3}, 0, 5, new byte[]{1, 2, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, 1, 1, 3, 0}, 0, 5, new byte[]{1, 2, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, 1, 1, 3, 0}, 0, 5, new byte[]{1, -11, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(false, new byte[]{1, 2, 1, 0, 1}, 0, 5, new byte[]{0, 1, 2}, new byte[]{1, 0, 0})));
    }

    @Test
    public void testSatisfiesForward() {
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, -128, 1, 0, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, 2, 1, 3, 3}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, 1, 1, 3, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, 1, 1, 3, 0}, new byte[]{1, -11, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(false, new byte[]{1, 2, 1, 0, 1}, new byte[]{0, 1, 2}, new byte[]{0, -1, -1})));
    }

    @Test
    public void testSatisfiesReverse() {
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, -128, 1, 0, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{2, 3, 1, 1, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, 2, 1, 3, 3}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, -11, 1, 3, 0}, new byte[]{1, 1, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, 3, 1, 3, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{2, 1, 1, 1, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfies(true, new byte[]{1, 2, 1, 0, 1}, new byte[]{0, 1, 2}, new byte[]{0, -1, -1})));
    }

    @Test
    public void testSatisfiesNoUnsafeReverse() {
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, -128, 1, 0, 1}, 0, 5, new byte[]{1, 0, 1}, new byte[]{0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, -128, 2, 0, 1}, 0, 5, new byte[]{1, 0, 1}, new byte[]{0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{2, 3, 1, 1, 1}, 0, 5, new byte[]{1, 0, 1}, new byte[]{0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.YES), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, 2, 1, 3, 3}, 0, 5, new byte[]{1, 2, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, -11, 1, 3, 0}, 0, 5, new byte[]{1, 1, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, 3, 1, 3, 0}, 0, 5, new byte[]{1, 2, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{2, 1, 1, 1, 0}, 0, 5, new byte[]{1, 2, 0, 3}, new byte[]{0, 0, 1, 0})));
        Assert.assertEquals((Object)((Object)FuzzyRowFilter.SatisfiesCode.NEXT_EXISTS), (Object)((Object)FuzzyRowFilter.satisfiesNoUnsafe(true, new byte[]{1, 2, 1, 0, 1}, 0, 5, new byte[]{0, 1, 2}, new byte[]{1, 0, 0})));
    }

    @Test
    public void testGetNextForFuzzyRuleForward() {
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{2, 1, 2, 0, 0});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 1, 2, 0, 1}, new byte[]{1, 1, 2, 0, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 0, 2, 0, 1}, new byte[]{1, 1, 0, 2, 0});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -127, 1, 0, 0});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{5, 1, 1, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1, 1}, new byte[]{5, 1, 0, 1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 1}, new byte[]{6, 1, 0, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -1, 1});
        TestFuzzyRowFilter.assertNext(false, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 4});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilter.assertNext(false, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{0, 1, 3, 2}, new byte[]{1, 1, 0, 0});
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule(new byte[]{2, 3, 1, 1, 1}, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule(new byte[]{1, -11, 1, 3, 0}, new byte[]{1, 1, 0, 3}, new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule(new byte[]{1, 3, 1, 3, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule(new byte[]{2, 1, 1, 1, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}));
    }

    @Test
    public void testGetNextForFuzzyRuleReverse() {
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{1, 1, 2, -1, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 2, 1, 3, 1}, new byte[]{1, 1, 0, 2, 0});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -128, 1, -1, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2, 1}, new byte[]{5, 1, 0, 1, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 0});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{4, 1, -1, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -2, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{2, 1, 3, 2}, new byte[]{1, 1, 0, 0});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{2, 3, 1, 1, 1}, new byte[]{1, 0, 1, -1, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, -11, 1, 3, 0}, new byte[]{1, 1, 0, 3, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, 3, 1, 3, 0}, new byte[]{1, 2, 0, 3, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{2, 1, 1, 1, 0}, new byte[]{1, 2, 0, 3, -1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2}, new byte[]{1, -128, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2}, new byte[]{5, 1, 0, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 0});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 1});
        TestFuzzyRowFilter.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 2});
        Assert.assertNull((Object)FuzzyRowFilter.getNextForFuzzyRule(true, new byte[]{1, 1, 1, 3, 0}, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}));
    }

    private static void assertNext(boolean reverse, byte[] fuzzyRow, byte[] mask, byte[] current, byte[] expected) {
        KeyValue kv = KeyValueUtil.createFirstOnRow(current);
        byte[] nextForFuzzyRule = FuzzyRowFilter.getNextForFuzzyRule(reverse, kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), fuzzyRow, mask);
        Assert.assertEquals((Object)Bytes.toStringBinary(expected), (Object)Bytes.toStringBinary(nextForFuzzyRule));
    }
}

