/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.executor;

import java.io.IOException;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestExecutorService {
    private static final Log LOG = LogFactory.getLog(TestExecutorService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorService() throws Exception {
        int tries;
        int maxThreads = 5;
        int maxTries = 10;
        int sleepInterval = 10;
        Server mockedServer = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)mockedServer.getConfiguration()).thenReturn((Object)HBaseConfiguration.create());
        ExecutorService executorService = new ExecutorService("unit_test");
        executorService.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, maxThreads);
        ExecutorService.Executor executor = executorService.getExecutor(ExecutorType.MASTER_SERVER_OPERATIONS);
        ExecutorService.TrackingThreadPoolExecutor pool = executor.threadPoolExecutor;
        Assert.assertEquals((long)0L, (long)pool.getPoolSize());
        AtomicBoolean lock2 = new AtomicBoolean(true);
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < maxThreads; ++i) {
            executorService.submit(new TestEventHandler(mockedServer, EventType.M_SERVER_SHUTDOWN, lock2, counter));
        }
        for (tries = 0; counter.get() < maxThreads && tries < maxTries; ++tries) {
            LOG.info("Waiting for all event handlers to start...");
            Thread.sleep(sleepInterval);
        }
        Assert.assertEquals((long)maxThreads, (long)counter.get());
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
        ExecutorService.ExecutorStatus status2 = executor.getStatus();
        Assert.assertTrue((boolean)status2.queuedEvents.isEmpty());
        Assert.assertEquals((long)5L, (long)status2.running.size());
        this.checkStatusDump(status2);
        AtomicBoolean atomicBoolean = lock2;
        synchronized (atomicBoolean) {
            lock2.set(false);
            lock2.notifyAll();
        }
        while (counter.get() < maxThreads * 2 && tries < maxTries) {
            System.out.println("Waiting for all event handlers to finish...");
            Thread.sleep(sleepInterval);
            ++tries;
        }
        Assert.assertEquals((long)(maxThreads * 2), (long)counter.get());
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
        for (int i = 0; i < 2 * maxThreads; ++i) {
            executorService.submit(new TestEventHandler(mockedServer, EventType.M_SERVER_SHUTDOWN, lock2, counter));
        }
        AtomicBoolean atomicBoolean2 = lock2;
        synchronized (atomicBoolean2) {
            lock2.set(false);
            lock2.notifyAll();
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)maxThreads, (long)pool.getPoolSize());
        executorService.shutdown();
        Assert.assertEquals((long)0L, (long)executorService.getAllExecutorStatuses().size());
        executorService.submit(new TestEventHandler(mockedServer, EventType.M_SERVER_SHUTDOWN, lock2, counter));
    }

    private void checkStatusDump(ExecutorService.ExecutorStatus status2) throws IOException {
        StringWriter sw = new StringWriter();
        status2.dumpTo(sw, "");
        String dump = sw.toString();
        LOG.info("Got status dump:\n" + dump);
        Assert.assertTrue((boolean)dump.contains("Waiting on java.util.concurrent.atomic.AtomicBoolean"));
    }

    public static class TestEventHandler
    extends EventHandler {
        private AtomicBoolean lock;
        private AtomicInteger counter;

        public TestEventHandler(Server server, EventType eventType, AtomicBoolean lock2, AtomicInteger counter) {
            super(server, eventType);
            this.lock = lock2;
            this.counter = counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() throws IOException {
            int num = this.counter.incrementAndGet();
            LOG.info("Running process #" + num + ", threadName=" + Thread.currentThread().getName());
            AtomicBoolean atomicBoolean = this.lock;
            synchronized (atomicBoolean) {
                while (this.lock.get()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.counter.incrementAndGet();
        }
    }
}

