/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.errorhandling;

import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionListener;
import org.apache.hadoop.hbase.errorhandling.TimeoutExceptionInjector;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestForeignExceptionDispatcher {
    private static final Log LOG = LogFactory.getLog(TestForeignExceptionDispatcher.class);
    final ForeignException EXTEXN = new ForeignException("FORTEST", new IllegalArgumentException("FORTEST"));
    final ForeignException EXTEXN2 = new ForeignException("FORTEST2", new IllegalArgumentException("FORTEST2"));

    @Test
    public void testErrorPropagation() {
        ForeignExceptionListener listener1 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionListener listener2 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionDispatcher dispatcher = new ForeignExceptionDispatcher();
        dispatcher.addListener(listener1);
        dispatcher.addListener(listener2);
        dispatcher.receive(this.EXTEXN);
        ((ForeignExceptionListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.times((int)1))).receive(this.EXTEXN);
        ((ForeignExceptionListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).receive(this.EXTEXN);
        try {
            dispatcher.rethrowException();
            Assert.fail((String)"Monitor should have thrown an exception after getting error.");
        }
        catch (ForeignException ex) {
            Assert.assertTrue((String)("Got an unexpected exception:" + ex), (ex.getCause() == this.EXTEXN.getCause() ? 1 : 0) != 0);
            LOG.debug("Got the testing exception!");
        }
        dispatcher.receive(this.EXTEXN2);
        ((ForeignExceptionListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.never())).receive(this.EXTEXN2);
        ((ForeignExceptionListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.never())).receive(this.EXTEXN2);
    }

    @Test
    public void testSingleDispatcherWithTimer() {
        ForeignExceptionListener listener1 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionListener listener2 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher();
        monitor.addListener(listener1);
        monitor.addListener(listener2);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(monitor, 1000L);
        timer.start();
        timer.trigger();
        Assert.assertTrue((String)"Monitor didn't get timeout", (boolean)monitor.hasException());
        ((ForeignExceptionListener)Mockito.verify((Object)listener1)).receive((ForeignException)Mockito.any(ForeignException.class));
        ((ForeignExceptionListener)Mockito.verify((Object)listener2)).receive((ForeignException)Mockito.any(ForeignException.class));
    }

    @Test
    public void testAttemptTimer() {
        ForeignExceptionListener listener1 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionListener listener2 = (ForeignExceptionListener)Mockito.mock(ForeignExceptionListener.class);
        ForeignExceptionDispatcher orchestrator = new ForeignExceptionDispatcher();
        orchestrator.addListener(listener1);
        orchestrator.addListener(listener2);
        TimeoutExceptionInjector timer = new TimeoutExceptionInjector(orchestrator, 1000L);
        timer.start();
        timer.trigger();
        ((ForeignExceptionListener)Mockito.verify((Object)listener1, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)Mockito.any(ForeignException.class));
        ((ForeignExceptionListener)Mockito.verify((Object)listener2, (VerificationMode)Mockito.times((int)1))).receive((ForeignException)Mockito.any(ForeignException.class));
    }
}

