/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerCoprocessorExceptionWithAbort {
    static final Log LOG = LogFactory.getLog(TestRegionServerCoprocessorExceptionWithAbort.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf("observed_table");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExceptionDuringInitialization() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 2);
        conf.setBoolean("hbase.coprocessor.abortonerror", true);
        conf.set("hbase.coprocessor.region.classes", "");
        TEST_UTIL.startMiniCluster(2);
        try {
            MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
            final HRegionServer regionServer = cluster.getRegionServer(0);
            conf.set("hbase.coprocessor.region.classes", FailedInitializationObserver.class.getName());
            regionServer.getRegionServerCoprocessorHost().loadSystemCoprocessors(conf, "hbase.coprocessor.region.classes");
            TEST_UTIL.waitFor(10000L, 1000L, new Waiter.Predicate<Exception>(){

                @Override
                public boolean evaluate() throws Exception {
                    return regionServer.isAborted();
                }
            });
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testExceptionFromCoprocessorDuringPut() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 2);
        conf.set("hbase.coprocessor.region.classes", BuggyRegionObserver.class.getName());
        conf.setBoolean("hbase.coprocessor.abortonerror", true);
        TEST_UTIL.startMiniCluster(2);
        try {
            byte[] TEST_FAMILY = Bytes.toBytes("aaa");
            HTable table = TEST_UTIL.createMultiRegionTable(TABLE_NAME, TEST_FAMILY);
            TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
            HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
            try {
                byte[] ROW = Bytes.toBytes("aaa");
                Put put = new Put(ROW);
                put.add(TEST_FAMILY, ROW, ROW);
                table.put(put);
                table.flushCommits();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean aborted = false;
            for (int i = 0; i < 10 && !(aborted = regionServer.isAborted()); ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Assert.fail((String)"InterruptedException while waiting for regionserver zk node to be deleted.");
                }
            }
            Assert.assertTrue((String)"The region server should have aborted", (boolean)aborted);
            table.close();
        }
        finally {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    public static class BuggyRegionObserver
    extends SimpleRegionObserver {
        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
            String tableName = c.getEnvironment().getRegion().getRegionInfo().getTable().getNameAsString();
            if (tableName.equals("observed_table")) {
                Integer i = null;
                i = i + 1;
            }
        }
    }

    public static class FailedInitializationObserver
    extends SimpleRegionObserver {
        @Override
        public void start(CoprocessorEnvironment e) throws IOException {
            Integer i = null;
            i = i + 1;
        }
    }
}

