/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.WALObserver;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class SampleRegionWALObserver
extends BaseRegionObserver
implements WALObserver {
    private static final Log LOG = LogFactory.getLog(SampleRegionWALObserver.class);
    private byte[] tableName;
    private byte[] row;
    private byte[] ignoredFamily;
    private byte[] ignoredQualifier;
    private byte[] addedFamily;
    private byte[] addedQualifier;
    private byte[] changedFamily;
    private byte[] changedQualifier;
    private boolean preWALWriteCalled = false;
    private boolean postWALWriteCalled = false;
    private boolean preWALRestoreCalled = false;
    private boolean postWALRestoreCalled = false;
    private boolean preWALWriteDeprecatedCalled = false;
    private boolean postWALWriteDeprecatedCalled = false;
    private boolean preWALRestoreDeprecatedCalled = false;
    private boolean postWALRestoreDeprecatedCalled = false;

    public void setTestValues(byte[] tableName, byte[] row, byte[] igf, byte[] igq, byte[] chf, byte[] chq, byte[] addf, byte[] addq) {
        this.row = row;
        this.tableName = tableName;
        this.ignoredFamily = igf;
        this.ignoredQualifier = igq;
        this.addedFamily = addf;
        this.addedQualifier = addq;
        this.changedFamily = chf;
        this.changedQualifier = chq;
        this.preWALWriteCalled = false;
        this.postWALWriteCalled = false;
        this.preWALRestoreCalled = false;
        this.postWALRestoreCalled = false;
        this.preWALWriteDeprecatedCalled = false;
        this.postWALWriteDeprecatedCalled = false;
        this.preWALRestoreDeprecatedCalled = false;
        this.postWALRestoreDeprecatedCalled = false;
    }

    @Override
    public void postWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> env, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.postWALWriteCalled = true;
    }

    @Override
    public void postWALWrite(ObserverContext<WALCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.postWALWriteDeprecatedCalled = true;
        this.postWALWrite(env, info, (WALKey)logKey, logEdit);
    }

    @Override
    public boolean preWALWrite(ObserverContext<? extends WALCoprocessorEnvironment> env, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        boolean bypass = false;
        if (!Bytes.equals(info.getTableName(), this.tableName)) {
            return bypass;
        }
        this.preWALWriteCalled = true;
        ArrayList<Cell> cells = logEdit.getCells();
        Cell deletedCell = null;
        for (Cell cell : cells) {
            byte[] family = cell.getFamily();
            byte[] qulifier = cell.getQualifier();
            if (Arrays.equals(family, this.ignoredFamily) && Arrays.equals(qulifier, this.ignoredQualifier)) {
                LOG.debug("Found the KeyValue from WALEdit which should be ignored.");
                deletedCell = cell;
            }
            if (!Arrays.equals(family, this.changedFamily) || !Arrays.equals(qulifier, this.changedQualifier)) continue;
            LOG.debug("Found the KeyValue from WALEdit which should be changed.");
            byte[] byArray = cell.getValueArray();
            int n = cell.getValueOffset();
            byArray[n] = (byte)(byArray[n] + 1);
        }
        if (null != this.row) {
            cells.add(new KeyValue(this.row, this.addedFamily, this.addedQualifier));
        }
        if (deletedCell != null) {
            LOG.debug("About to delete a KeyValue from WALEdit.");
            cells.remove(deletedCell);
        }
        return bypass;
    }

    @Override
    public boolean preWALWrite(ObserverContext<WALCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.preWALWriteDeprecatedCalled = true;
        return this.preWALWrite(env, info, (WALKey)logKey, logEdit);
    }

    @Override
    public void preWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.preWALRestoreCalled = true;
    }

    @Override
    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.preWALRestoreDeprecatedCalled = true;
        this.preWALRestore(env, info, (WALKey)logKey, logEdit);
    }

    @Override
    public void postWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.postWALRestoreCalled = true;
    }

    @Override
    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> env, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.postWALRestoreDeprecatedCalled = true;
        this.postWALRestore(env, info, (WALKey)logKey, logEdit);
    }

    public boolean isPreWALWriteCalled() {
        return this.preWALWriteCalled;
    }

    public boolean isPostWALWriteCalled() {
        return this.postWALWriteCalled;
    }

    public boolean isPreWALRestoreCalled() {
        LOG.debug(SampleRegionWALObserver.class.getName() + ".isPreWALRestoreCalled is called.");
        return this.preWALRestoreCalled;
    }

    public boolean isPostWALRestoreCalled() {
        LOG.debug(SampleRegionWALObserver.class.getName() + ".isPostWALRestoreCalled is called.");
        return this.postWALRestoreCalled;
    }

    public boolean isPreWALWriteDeprecatedCalled() {
        return this.preWALWriteDeprecatedCalled;
    }

    public boolean isPostWALWriteDeprecatedCalled() {
        return this.postWALWriteDeprecatedCalled;
    }

    public boolean isPreWALRestoreDeprecatedCalled() {
        return this.preWALRestoreDeprecatedCalled;
    }

    public boolean isPostWALRestoreDeprecatedCalled() {
        return this.postWALRestoreDeprecatedCalled;
    }

    static class Legacy
    extends SampleRegionWALObserver {
        Legacy() {
        }
    }
}

