/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class AggregateImplementation<T, S, P extends Message, Q extends Message, R extends Message>
extends AggregateProtos.AggregateService
implements CoprocessorService,
Coprocessor {
    protected static final Log log = LogFactory.getLog(AggregateImplementation.class);
    private RegionCoprocessorEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMax(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        InternalScanner scanner = null;
        AggregateProtos.AggregateResponse response = null;
        Object max = null;
        try {
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            ArrayList<Cell> results = new ArrayList<Cell>();
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    T temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                    max = max == null || temp != null && ci.compare(temp, max) > 0 ? temp : max;
                }
                results.clear();
            } while (hasMoreRows);
            if (max != null) {
                AggregateProtos.AggregateResponse.Builder builder = AggregateProtos.AggregateResponse.newBuilder();
                builder.addFirstPart(ci.getProtoForCellType(max).toByteString());
                response = builder.build();
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        log.info("Maximum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + max);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMin(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response = null;
        InternalScanner scanner = null;
        Object min = null;
        try {
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            ArrayList<Cell> results = new ArrayList<Cell>();
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    T temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                    min = min == null || temp != null && ci.compare(temp, min) < 0 ? temp : min;
                }
                results.clear();
            } while (hasMoreRows);
            if (min != null) {
                response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForCellType(min).toByteString()).build();
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        log.info("Minimum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + min);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getSum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response = null;
        InternalScanner scanner = null;
        long sum = 0L;
        try {
            ColumnInterpreter<T, Object, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Object sumVal = null;
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            ArrayList<Cell> results = new ArrayList<Cell>();
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    T temp = ci.getValue(colFamily, qualifier, (Cell)results.get(i));
                    if (temp == null) continue;
                    sumVal = ci.add(sumVal, ci.castToReturnType(temp));
                }
                results.clear();
            } while (hasMoreRows);
            if (sumVal != null) {
                response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ci.getProtoForPromotedType(sumVal).toByteString()).build();
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        log.debug("Sum from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + sum);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRowNum(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response = null;
        long counter = 0L;
        ArrayList<Cell> results = new ArrayList<Cell>();
        InternalScanner scanner = null;
        try {
            Scan scan = ProtobufUtil.toScan(request.getScan());
            byte[][] colFamilies = scan.getFamilies();
            byte[] colFamily = colFamilies != null ? colFamilies[0] : null;
            NavigableSet<byte[]> qualifiers = colFamilies != null ? scan.getFamilyMap().get(colFamily) : null;
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            if (scan.getFilter() == null && qualifier == null) {
                scan.setFilter(new FirstKeyOnlyFilter());
            }
            scanner = this.env.getRegion().getScanner(scan);
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                if (results.size() > 0) {
                    ++counter;
                }
                results.clear();
            } while (hasMoreRows);
            ByteBuffer bb = ByteBuffer.allocate(8).putLong(counter);
            bb.rewind();
            response = AggregateProtos.AggregateResponse.newBuilder().addFirstPart(ByteString.copyFrom((ByteBuffer)bb)).build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        log.info("Row counter from this region is " + this.env.getRegion().getRegionInfo().getRegionNameAsString() + ": " + counter);
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAvg(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response = null;
        InternalScanner scanner = null;
        try {
            ColumnInterpreter<T, S, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Object sumVal = null;
            Long rowCountVal = 0L;
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            ArrayList<Cell> results = new ArrayList<Cell>();
            boolean hasMoreRows = false;
            do {
                results.clear();
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    sumVal = ci.add(sumVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                }
                Long i = rowCountVal;
                Long l = rowCountVal = Long.valueOf(rowCountVal + 1L);
            } while (hasMoreRows);
            if (sumVal != null) {
                ByteString first = ci.getProtoForPromotedType(sumVal).toByteString();
                AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                pair.addFirstPart(first);
                ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                bb.rewind();
                pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                response = pair.build();
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStd(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        InternalScanner scanner = null;
        AggregateProtos.AggregateResponse response = null;
        try {
            ColumnInterpreter<T, Object, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Object sumVal = null;
            Object sumSqVal = null;
            Object tempVal = null;
            long rowCountVal = 0L;
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] qualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                qualifier = qualifiers.pollFirst();
            }
            ArrayList<Cell> results = new ArrayList<Cell>();
            boolean hasMoreRows = false;
            do {
                tempVal = null;
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, (Cell)results.get(i))));
                }
                results.clear();
                sumVal = ci.add(sumVal, tempVal);
                sumSqVal = ci.add(sumSqVal, ci.multiply(tempVal, tempVal));
                ++rowCountVal;
            } while (hasMoreRows);
            if (sumVal != null) {
                ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
                ByteString first_sumSqVal = ci.getProtoForPromotedType(sumSqVal).toByteString();
                AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
                pair.addFirstPart(first_sumVal);
                pair.addFirstPart(first_sumSqVal);
                ByteBuffer bb = ByteBuffer.allocate(8).putLong(rowCountVal);
                bb.rewind();
                pair.setSecondPart(ByteString.copyFrom((ByteBuffer)bb));
                response = pair.build();
            }
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        done.run(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMedian(RpcController controller, AggregateProtos.AggregateRequest request, RpcCallback<AggregateProtos.AggregateResponse> done) {
        AggregateProtos.AggregateResponse response = null;
        InternalScanner scanner = null;
        try {
            ColumnInterpreter<T, Object, P, Q, R> ci = this.constructColumnInterpreterFromRequest(request);
            Object sumVal = null;
            Object sumWeights = null;
            Object tempVal = null;
            Object tempWeight = null;
            Scan scan = ProtobufUtil.toScan(request.getScan());
            scanner = this.env.getRegion().getScanner(scan);
            byte[] colFamily = scan.getFamilies()[0];
            NavigableSet<byte[]> qualifiers = scan.getFamilyMap().get(colFamily);
            byte[] valQualifier = null;
            byte[] weightQualifier = null;
            if (qualifiers != null && !qualifiers.isEmpty()) {
                valQualifier = qualifiers.pollFirst();
                weightQualifier = qualifiers.pollLast();
            }
            ArrayList<Cell> results = new ArrayList<Cell>();
            boolean hasMoreRows = false;
            do {
                tempVal = null;
                tempWeight = null;
                hasMoreRows = scanner.next(results);
                int listSize = results.size();
                for (int i = 0; i < listSize; ++i) {
                    Cell kv = (Cell)results.get(i);
                    tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, valQualifier, kv)));
                    if (weightQualifier == null) continue;
                    tempWeight = ci.add(tempWeight, ci.castToReturnType(ci.getValue(colFamily, weightQualifier, kv)));
                }
                results.clear();
                sumVal = ci.add(sumVal, tempVal);
                sumWeights = ci.add(sumWeights, tempWeight);
            } while (hasMoreRows);
            ByteString first_sumVal = ci.getProtoForPromotedType(sumVal).toByteString();
            Object s = sumWeights == null ? (Object)ci.castToReturnType(ci.getMinValue()) : sumWeights;
            ByteString first_sumWeights = ci.getProtoForPromotedType(s).toByteString();
            AggregateProtos.AggregateResponse.Builder pair = AggregateProtos.AggregateResponse.newBuilder();
            pair.addFirstPart(first_sumVal);
            pair.addFirstPart(first_sumWeights);
            response = pair.build();
        }
        catch (IOException e) {
            ResponseConverter.setControllerException(controller, e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException ignored) {}
            }
        }
        done.run(response);
    }

    ColumnInterpreter<T, S, P, Q, R> constructColumnInterpreterFromRequest(AggregateProtos.AggregateRequest request) throws IOException {
        String className = request.getInterpreterClassName();
        try {
            Class<?> cls = Class.forName(className);
            ColumnInterpreter ci = (ColumnInterpreter)cls.newInstance();
            if (request.hasInterpreterSpecificBytes()) {
                ByteString b = request.getInterpreterSpecificBytes();
                Object initMsg = ProtobufUtil.getParsedGenericInstance(ci.getClass(), 2, b);
                ci.initialize(initMsg);
            }
            return ci;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Service getService() {
        return this;
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }
}

