/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.MessageCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.com.google.common.io.CountingInputStream;
import org.apache.hive.com.google.common.io.CountingOutputStream;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellMessageCodec {
    public static final Log LOG = LogFactory.getLog(TestCellMessageCodec.class);

    @Test
    public void testEmptyWorks() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder(dos);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)0L, (long)offset);
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = cmc.getDecoder(dis);
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)0L, (long)cis.getCount());
    }

    @Test
    public void testOne() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder(dos);
        KeyValue kv = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("q"), Bytes.toBytes("v"));
        encoder.write(kv);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = cmc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder.advance());
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }

    @Test
    public void testThree() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(baos);
        DataOutputStream dos = new DataOutputStream(cos);
        MessageCodec cmc = new MessageCodec();
        Codec.Encoder encoder = cmc.getEncoder(dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("1"), Bytes.toBytes("1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("2"), Bytes.toBytes("2"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("3"), Bytes.toBytes("3"));
        encoder.write(kv1);
        encoder.write(kv2);
        encoder.write(kv3);
        encoder.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream(cis);
        Codec.Decoder decoder = cmc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder.advance());
        Cell c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv1));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv2));
        Assert.assertTrue((boolean)decoder.advance());
        c = decoder.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv3));
        Assert.assertFalse((boolean)decoder.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }
}

