/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.codec.CellCodec;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.codec.MessageCodec;
import org.apache.hadoop.hbase.io.CellOutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.Assert;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CodecPerformance {
    public static final Log LOG = LogFactory.getLog(CodecPerformance.class);

    static Cell[] getCells(int howMany) {
        Cell[] cells = new Cell[howMany];
        for (int i = 0; i < howMany; ++i) {
            byte[] index = Bytes.toBytes(i);
            KeyValue kv = new KeyValue(index, Bytes.toBytes("f"), index, index);
            cells[i] = kv;
        }
        return cells;
    }

    static int getRoughSize(Cell[] cells) {
        int size = 0;
        for (Cell c : cells) {
            size += c.getRowLength() + c.getFamilyLength() + c.getQualifierLength() + c.getValueLength();
            size += 9;
        }
        return size;
    }

    static byte[] runEncoderTest(int index, int initialBufferSize, ByteArrayOutputStream baos, CellOutputStream encoder, Cell[] cells) throws IOException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < cells.length; ++i) {
            encoder.write(cells[i]);
        }
        encoder.flush();
        LOG.info("" + index + " encoded count=" + cells.length + " in " + (System.currentTimeMillis() - startTime) + "ms for encoder " + encoder);
        Assert.assertTrue((baos.size() < initialBufferSize ? 1 : 0) != 0);
        return baos.toByteArray();
    }

    static Cell[] runDecoderTest(int index, int count, CellScanner decoder) throws IOException {
        Cell[] cells = new Cell[count];
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (decoder.advance()) {
            cells[i] = decoder.current();
            ++i;
        }
        LOG.info("" + index + " decoded count=" + cells.length + " in " + (System.currentTimeMillis() - startTime) + "ms for decoder " + decoder);
        Assert.assertTrue((cells.length == count ? 1 : 0) != 0);
        return cells;
    }

    static void verifyCells(Cell[] input, Cell[] output) {
        Assert.assertEquals((long)input.length, (long)output.length);
        for (int i = 0; i < input.length; ++i) {
            input[i].equals(output[i]);
        }
    }

    static void doCodec(Codec codec, Cell[] cells, int cycles, int count, int initialBufferSize) throws IOException {
        int i;
        byte[] bytes = null;
        Cell[] cellsDecoded = null;
        for (i = 0; i < cycles; ++i) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(initialBufferSize);
            Codec.Encoder encoder = codec.getEncoder(baos);
            bytes = CodecPerformance.runEncoderTest(i, initialBufferSize, baos, encoder, cells);
        }
        for (i = 0; i < cycles; ++i) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            Codec.Decoder decoder = codec.getDecoder(bais);
            cellsDecoded = CodecPerformance.runDecoderTest(i, count, decoder);
        }
        CodecPerformance.verifyCells(cells, cellsDecoded);
    }

    public static void main(String[] args) throws IOException {
        int count = 100000;
        int cycles = 30;
        Cell[] cells = CodecPerformance.getCells(100000);
        int size = CodecPerformance.getRoughSize(cells);
        int initialBufferSize = 2 * size;
        CodecPerformance.doCodec(new KeyValueCodec(), cells, 30, 100000, initialBufferSize);
        CodecPerformance.doCodec(new CellCodec(), cells, 30, 100000, initialBufferSize);
        CodecPerformance.doCodec(new MessageCodec(), cells, 30, 100000, initialBufferSize);
    }
}

