/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableSnapshotScanner;
import org.apache.hadoop.hbase.mapreduce.TestTableSnapshotInputFormat;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestTableSnapshotScanner {
    private static final Log LOG = LogFactory.getLog(TestTableSnapshotInputFormat.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_REGION_SERVERS = 2;
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes("f1"), Bytes.toBytes("f2")};
    public static byte[] bbb = Bytes.toBytes("bbb");
    public static byte[] yyy = Bytes.toBytes("yyy");
    private FileSystem fs;
    private Path rootDir;

    public void setupCluster() throws Exception {
        TestTableSnapshotScanner.setupConf(this.UTIL.getConfiguration());
        this.UTIL.startMiniCluster(2, true);
        this.rootDir = this.UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.fs = this.rootDir.getFileSystem(this.UTIL.getConfiguration());
    }

    public void tearDownCluster() throws Exception {
        this.UTIL.shutdownMiniCluster();
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void createTableAndSnapshot(HBaseTestingUtility util, TableName tableName, String snapshotName, int numRegions) throws Exception {
        try {
            util.deleteTable(tableName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (numRegions > 1) {
            util.createTable(tableName, FAMILIES, 1, bbb, yyy, numRegions);
        } else {
            util.createTable(tableName, FAMILIES);
        }
        HBaseAdmin admin = util.getHBaseAdmin();
        HTable table = new HTable(util.getConfiguration(), tableName);
        util.loadTable((Table)table, FAMILIES);
        Path rootDir = FSUtils.getRootDir(util.getConfiguration());
        FileSystem fs = rootDir.getFileSystem(util.getConfiguration());
        SnapshotTestingUtils.createSnapshotAndValidate(admin, tableName, Arrays.asList(FAMILIES), null, snapshotName, rootDir, fs, true);
        byte[] value = Bytes.toBytes("after_snapshot_value");
        util.loadTable((Table)table, FAMILIES, value);
        admin.flush(tableName);
        table.close();
    }

    @Test
    public void testWithSingleRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithSingleRegion", 1, false);
    }

    @Test
    public void testWithMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 10, false);
    }

    @Test
    public void testWithOfflineHBaseMultiRegion() throws Exception {
        this.testScanner(this.UTIL, "testWithMultiRegion", 20, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testScanner(HBaseTestingUtility util, String snapshotName, int numRegions, boolean shutdownCluster) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf("testScanner");
        try {
            TestTableSnapshotScanner.createTableAndSnapshot(util, tableName, snapshotName, numRegions);
            if (shutdownCluster) {
                util.shutdownMiniHBaseCluster();
            }
            Path restoreDir = util.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbb, yyy);
            TableSnapshotScanner scanner = new TableSnapshotScanner(this.UTIL.getConfiguration(), restoreDir, snapshotName, scan);
            this.verifyScanner(scanner, bbb, yyy);
            scanner.close();
        }
        finally {
            if (!shutdownCluster) {
                util.getHBaseAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
                this.tearDownCluster();
            }
        }
    }

    private void verifyScanner(ResultScanner scanner, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        Result result;
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow);
        while ((result = scanner.next()) != null) {
            TestTableSnapshotScanner.verifyRow(result);
            rowTracker.addRow(result.getRow());
        }
        rowTracker.validate();
    }

    private static void verifyRow(Result result) throws IOException {
        byte[] row = result.getRow();
        CellScanner scanner = result.cellScanner();
        while (scanner.advance()) {
            Cell cell = scanner.current();
            Assert.assertEquals((long)0L, (long)Bytes.compareTo(row, 0, row.length, cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        }
        for (int j = 0; j < FAMILIES.length; ++j) {
            byte[] actual = result.getValue(FAMILIES[j], null);
            Assert.assertArrayEquals((String)("Row in snapshot does not match, expected:" + Bytes.toString(row) + " ,actual:" + Bytes.toString(actual)), (byte[])row, (byte[])actual);
        }
    }
}

