/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestSnapshotCloneIndependence {
    private static final Log LOG = LogFactory.getLog(TestSnapshotCloneIndependence.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "test";
    private static final String TEST_FAM_STR = "fam";
    private static final byte[] TEST_FAM = Bytes.toBytes("fam");
    private static final TableName TABLE_NAME = TableName.valueOf("test");
    private static final int CLEANER_INTERVAL = 10;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotCloneIndependence.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    private static void setupConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setInt("hbase.master.cleaner.interval", 10);
        conf.setInt("hbase.master.hfilecleaner.plugins.snapshot.period", 10);
        conf.setInt("hbase.master.hfilecleaner.ttl", 10);
    }

    @Before
    public void setup() throws Exception {
        UTIL.createTable(TABLE_NAME, TEST_FAM);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", e);
        }
    }

    @Test(timeout=300000L)
    public void testOnlineSnapshotAppendIndependent() throws Exception {
        this.runTestSnapshotAppendIndependent(true);
    }

    @Test(timeout=300000L)
    public void testOfflineSnapshotAppendIndependent() throws Exception {
        this.runTestSnapshotAppendIndependent(false);
    }

    @Test(timeout=300000L)
    public void testOnlineSnapshotMetadataChangesIndependent() throws Exception {
        this.runTestSnapshotMetadataChangesIndependent(true);
    }

    @Test(timeout=300000L)
    public void testOfflineSnapshotMetadataChangesIndependent() throws Exception {
        this.runTestSnapshotMetadataChangesIndependent(false);
    }

    @Test(timeout=300000L)
    public void testOfflineSnapshotRegionOperationsIndependent() throws Exception {
        this.runTestRegionOperationsIndependent(false);
    }

    @Test(timeout=300000L)
    public void testOnlineSnapshotRegionOperationsIndependent() throws Exception {
        this.runTestRegionOperationsIndependent(true);
    }

    @Test(timeout=300000L)
    public void testOfflineSnapshotDeleteIndependent() throws Exception {
        this.runTestSnapshotDeleteIndependent(false);
    }

    @Test(timeout=300000L)
    public void testOnlineSnapshotDeleteIndependent() throws Exception {
        this.runTestSnapshotDeleteIndependent(true);
    }

    private static void waitOnSplit(HTable t, int originalCount) throws Exception {
        for (int i = 0; i < 200; ++i) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (t.getAllRegionLocations().size() <= originalCount) continue;
            return;
        }
        throw new Exception("Split did not increase the number of regions");
    }

    private void runTestSnapshotAppendIndependent(boolean online) throws Exception {
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        long startTime = System.currentTimeMillis();
        TableName localTableName = TableName.valueOf(STRING_TABLE_NAME + startTime);
        try (HTable original = UTIL.createTable(localTableName, TEST_FAM);){
            UTIL.loadTable((Table)original, TEST_FAM);
            int origTableRowCount = UTIL.countRows(original);
            String snapshotNameAsString = "snapshot_" + localTableName;
            byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
            SnapshotTestingUtils.createSnapshotAndValidate(admin, localTableName, TEST_FAM_STR, snapshotNameAsString, rootDir, fs, online);
            if (!online) {
                admin.enableTable(localTableName);
            }
            TableName cloneTableName = TableName.valueOf("test-clone-" + localTableName);
            admin.cloneSnapshot(snapshotName, cloneTableName);
            try (HTable clonedTable = new HTable(UTIL.getConfiguration(), cloneTableName);){
                int clonedTableRowCount = UTIL.countRows(clonedTable);
                Assert.assertEquals((String)"The line counts of original and cloned tables do not match after clone. ", (long)origTableRowCount, (long)clonedTableRowCount);
                String rowKey = "new-row-" + System.currentTimeMillis();
                Put p = new Put(Bytes.toBytes(rowKey));
                p.add(TEST_FAM, Bytes.toBytes("someQualifier"), Bytes.toBytes("someString"));
                original.put(p);
                Assert.assertEquals((String)"The row count of the original table was not modified by the put", (long)(origTableRowCount + 1), (long)UTIL.countRows(original));
                Assert.assertEquals((String)"The row count of the cloned table changed as a result of addition to the original", (long)clonedTableRowCount, (long)UTIL.countRows(clonedTable));
                p = new Put(Bytes.toBytes(rowKey));
                p.add(TEST_FAM, Bytes.toBytes("someQualifier"), Bytes.toBytes("someString"));
                clonedTable.put(p);
                Assert.assertEquals((String)"The row count of the original table was modified by the put to the clone", (long)(origTableRowCount + 1), (long)UTIL.countRows(original));
                Assert.assertEquals((String)"The row count of the cloned table was not modified by the put", (long)(clonedTableRowCount + 1), (long)UTIL.countRows(clonedTable));
            }
        }
    }

    private void runTestRegionOperationsIndependent(boolean online) throws Exception {
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        long startTime = System.currentTimeMillis();
        TableName localTableName = TableName.valueOf(STRING_TABLE_NAME + startTime);
        HTable original = UTIL.createTable(localTableName, TEST_FAM);
        UTIL.loadTable((Table)original, TEST_FAM);
        int loadedTableCount = UTIL.countRows(original);
        System.out.println("Original table has: " + loadedTableCount + " rows");
        String snapshotNameAsString = "snapshot_" + localTableName;
        SnapshotTestingUtils.createSnapshotAndValidate(admin, localTableName, TEST_FAM_STR, snapshotNameAsString, rootDir, fs, online);
        if (!online) {
            admin.enableTable(localTableName);
        }
        TableName cloneTableName = TableName.valueOf("test-clone-" + localTableName);
        byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
        admin.cloneSnapshot(snapshotName, cloneTableName);
        original.clearRegionCache();
        List<HRegionInfo> originalTableHRegions = admin.getTableRegions(localTableName);
        int originalRegionCount = originalTableHRegions.size();
        int cloneTableRegionCount = admin.getTableRegions(cloneTableName).size();
        Assert.assertEquals((String)"The number of regions in the cloned table is different than in the original table.", (long)originalRegionCount, (long)cloneTableRegionCount);
        admin.splitRegion(originalTableHRegions.get(0).getRegionName());
        TestSnapshotCloneIndependence.waitOnSplit(original, originalRegionCount);
        int cloneTableRegionCount2 = admin.getTableRegions(cloneTableName).size();
        Assert.assertEquals((String)"The number of regions in the cloned table changed though none of its regions were split.", (long)cloneTableRegionCount, (long)cloneTableRegionCount2);
    }

    private void runTestSnapshotMetadataChangesIndependent(boolean online) throws Exception {
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        long startTime = System.currentTimeMillis();
        TableName localTableName = TableName.valueOf(STRING_TABLE_NAME + startTime);
        HTable original = UTIL.createTable(localTableName, TEST_FAM);
        UTIL.loadTable((Table)original, TEST_FAM);
        String snapshotNameAsString = "snapshot_" + localTableName;
        SnapshotTestingUtils.createSnapshotAndValidate(admin, localTableName, TEST_FAM_STR, snapshotNameAsString, rootDir, fs, online);
        if (!online) {
            admin.enableTable(localTableName);
        }
        TableName cloneTableName = TableName.valueOf("test-clone-" + localTableName);
        byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
        admin.cloneSnapshot(snapshotName, cloneTableName);
        byte[] TEST_FAM_2 = Bytes.toBytes("fam2");
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAM_2);
        admin.disableTable(localTableName);
        admin.addColumn(localTableName, hcd);
        admin.enableTable(localTableName);
        HTableDescriptor originalTableDescriptor = original.getTableDescriptor();
        HTableDescriptor clonedTableDescriptor = admin.getTableDescriptor(cloneTableName);
        Assert.assertTrue((String)"The original family was not found. There is something wrong. ", (boolean)originalTableDescriptor.hasFamily(TEST_FAM));
        Assert.assertTrue((String)"The original family was not found in the clone. There is something wrong. ", (boolean)clonedTableDescriptor.hasFamily(TEST_FAM));
        Assert.assertTrue((String)"The new family was not found. ", (boolean)originalTableDescriptor.hasFamily(TEST_FAM_2));
        Assert.assertTrue((String)"The new family was not found. ", (!clonedTableDescriptor.hasFamily(TEST_FAM_2) ? 1 : 0) != 0);
    }

    private void runTestSnapshotDeleteIndependent(boolean online) throws Exception {
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        long startTime = System.currentTimeMillis();
        TableName localTableName = TableName.valueOf(STRING_TABLE_NAME + startTime);
        try (HTable original = UTIL.createTable(localTableName, TEST_FAM);){
            UTIL.loadTable((Table)original, TEST_FAM);
        }
        String snapshotNameAsString = "snapshot_" + localTableName;
        byte[] snapshotName = Bytes.toBytes(snapshotNameAsString);
        SnapshotTestingUtils.createSnapshotAndValidate(admin, localTableName, TEST_FAM_STR, snapshotNameAsString, rootDir, fs, online);
        if (!online) {
            admin.enableTable(localTableName);
        }
        TableName cloneTableName = TableName.valueOf("test-clone-" + localTableName);
        admin.cloneSnapshot(snapshotName, cloneTableName);
        admin.majorCompact(localTableName);
        admin.deleteSnapshot(snapshotName);
        Thread.sleep(10000L);
        try (Table original = UTIL.getConnection().getTable(localTableName);
             Table clonedTable = UTIL.getConnection().getTable(cloneTableName);){
            int origTableRowCount = UTIL.countRows(original);
            int clonedTableRowCount = UTIL.countRows(clonedTable);
            Assert.assertEquals((long)origTableRowCount, (long)clonedTableRowCount);
        }
    }
}

