/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestScannerTimeout {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final byte[] SOME_BYTES = Bytes.toBytes("f");
    private static final TableName TABLE_NAME = TableName.valueOf("t");
    private static final int NB_ROWS = 10;
    private static final int THREAD_WAKE_FREQUENCY = 1000;
    private static final int SCANNER_TIMEOUT = 15000;
    private static final int SCANNER_CACHING = 5;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        c.setInt("hbase.client.scanner.timeout.period", 15000);
        c.setInt("hbase.server.thread.wakefrequency", 1000);
        c.set("hbase.balancer.tablesOnMaster", "hbase:meta");
        TEST_UTIL.startMiniCluster(2);
        HTable table = TEST_UTIL.createTable(TABLE_NAME, SOME_BYTES);
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes(i));
            put.add(SOME_BYTES, SOME_BYTES, SOME_BYTES);
            table.put(put);
        }
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.ensureSomeNonStoppedRegionServersAvailable(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void test2481() throws Exception {
        this.LOG.info("START ************ test2481");
        Scan scan = new Scan();
        scan.setCaching(1);
        HTable table = new HTable(new Configuration(TEST_UTIL.getConfiguration()), TABLE_NAME);
        ResultScanner r = table.getScanner(scan);
        int count = 0;
        try {
            Result res = r.next();
            while (res != null) {
                if (++count == 5) {
                    Thread.sleep(16100L);
                }
                res = r.next();
            }
        }
        catch (ScannerTimeoutException e) {
            this.LOG.info("Got the timeout " + e.getMessage(), e);
            return;
        }
        finally {
            table.close();
        }
        Assert.fail((String)"We should be timing out");
        this.LOG.info("END ************ test2481");
    }

    @Test(timeout=300000L)
    public void test2772() throws Exception {
        this.LOG.info("START************ test2772");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        Scan scan = new Scan();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        HTable higherScanTimeoutTable = new HTable(conf, TABLE_NAME);
        ResultScanner r = higherScanTimeoutTable.getScanner(scan);
        rs.abort("die!");
        Result[] results = r.next(10);
        Assert.assertEquals((long)10L, (long)results.length);
        r.close();
        higherScanTimeoutTable.close();
        this.LOG.info("END ************ test2772");
    }

    @Test(timeout=300000L)
    public void test3686a() throws Exception {
        this.LOG.info("START ************ TEST3686A---1");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        this.LOG.info("START ************ TEST3686A---1111");
        Scan scan = new Scan();
        scan.setCaching(5);
        this.LOG.info("************ TEST3686A");
        MetaTableAccessor.fullScanMetaAndPrint(TEST_UTIL.getHBaseAdmin().getConnection());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        HTable table = new HTable(conf, TABLE_NAME);
        this.LOG.info("START ************ TEST3686A---22");
        ResultScanner r = table.getScanner(scan);
        this.LOG.info("START ************ TEST3686A---33");
        int count = 1;
        r.next();
        this.LOG.info("START ************ TEST3686A---44");
        rs.abort("die!");
        while (r.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        r.close();
        table.close();
        this.LOG.info("************ END TEST3686A");
    }

    @Test(timeout=300000L)
    public void test3686b() throws Exception {
        this.LOG.info("START ************ test3686b");
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        Scan scan = new Scan();
        scan.setCaching(5);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.scanner.timeout.period", 1500000);
        HTable higherScanTimeoutTable = new HTable(conf, TABLE_NAME);
        ResultScanner r = higherScanTimeoutTable.getScanner(scan);
        int count = 1;
        r.next();
        Thread.sleep(17000L);
        while (r.next() != null) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        r.close();
        higherScanTimeoutTable.close();
        this.LOG.info("END ************ END test3686b");
    }
}

