/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ProtobufCoprocessorService;
import org.apache.hadoop.hbase.ipc.DelegatingPayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRpcControllerFactory {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", ProtobufCoprocessorService.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCountController() throws Exception {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.controllerfactory.class", StaticRpcControllerFactory.class.getName());
        TableName name = TableName.valueOf("testcustomcontroller");
        UTIL.createTable(name, HBaseTestingUtility.fam1).close();
        conf.setInt("hbase.rpc.timeout", 60001);
        Connection connection = ConnectionFactory.createConnection(conf);
        Table table = connection.getTable(name);
        byte[] row = Bytes.toBytes("row");
        Put p = new Put(row);
        p.add(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1, Bytes.toBytes("val0"));
        table.put(p);
        Integer counter = 1;
        counter = this.verifyCount(counter);
        Delete d = new Delete(row);
        d.addColumn(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1);
        table.delete(d);
        counter = this.verifyCount(counter);
        Put p2 = new Put(row);
        p2.add(HBaseTestingUtility.fam1, Bytes.toBytes("qual"), Bytes.toBytes("val1"));
        table.batch(Lists.newArrayList(p, p2), new Object[2]);
        counter = this.verifyCount(counter);
        Append append = new Append(row);
        append.add(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1, Bytes.toBytes("val2"));
        table.append(append);
        counter = this.verifyCount(counter);
        Get g = new Get(row);
        table.get(g);
        counter = this.verifyCount(counter);
        ResultScanner scan = table.getScanner(HBaseTestingUtility.fam1);
        scan.next();
        scan.close();
        counter = this.verifyCount(counter);
        Get g2 = new Get(row);
        table.get(Lists.newArrayList(g, g2));
        counter = this.verifyCount(counter);
        Scan scanInfo = new Scan(row);
        scanInfo.setSmall(true);
        counter = this.doScan(table, scanInfo, counter);
        scanInfo.setReversed(true);
        counter = this.doScan(table, scanInfo, counter);
        scanInfo.setSmall(false);
        counter = this.doScan(table, scanInfo, counter);
        table.close();
    }

    int doScan(Table table, Scan scan, int expectedCount) throws IOException {
        ResultScanner results = table.getScanner(scan);
        results.next();
        results.close();
        return this.verifyCount(expectedCount);
    }

    int verifyCount(Integer counter) {
        Assert.assertEquals((long)counter.intValue(), (long)CountingRpcController.TABLE_PRIORITY.get());
        Assert.assertEquals((long)0L, (long)CountingRpcController.INT_PRIORITY.get());
        return counter + 1;
    }

    public static class CountingRpcController
    extends DelegatingPayloadCarryingRpcController {
        private static AtomicInteger INT_PRIORITY = new AtomicInteger();
        private static AtomicInteger TABLE_PRIORITY = new AtomicInteger();

        public CountingRpcController(PayloadCarryingRpcController delegate) {
            super(delegate);
        }

        @Override
        public void setPriority(int priority) {
            super.setPriority(priority);
            INT_PRIORITY.incrementAndGet();
        }

        @Override
        public void setPriority(TableName tn) {
            super.setPriority(tn);
            if (!tn.isSystemTable()) {
                TABLE_PRIORITY.incrementAndGet();
            }
        }
    }

    public static class StaticRpcControllerFactory
    extends RpcControllerFactory {
        public StaticRpcControllerFactory(Configuration conf) {
            super(conf);
        }

        @Override
        public PayloadCarryingRpcController newController() {
            return new CountingRpcController(super.newController());
        }

        @Override
        public PayloadCarryingRpcController newController(CellScanner cellScanner) {
            return new CountingRpcController(super.newController(cellScanner));
        }

        @Override
        public PayloadCarryingRpcController newController(List<CellScannable> cellIterables) {
            return new CountingRpcController(super.newController(cellIterables));
        }
    }
}

