/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.TreeSet;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestConnectionUtils {
    @Test
    public void testRetryTimeJitter() {
        long[] retries = new long[200];
        long baseTime = 1000000L;
        long maxTimeExpected = (long)((float)baseTime * 1.01f);
        for (int i = 0; i < retries.length; ++i) {
            retries[i] = ConnectionUtils.getPauseTime(baseTime, 0);
        }
        TreeSet<Long> retyTimeSet = new TreeSet<Long>();
        for (long l : retries) {
            Assert.assertTrue((l >= baseTime ? 1 : 0) != 0);
            Assert.assertTrue((l <= maxTimeExpected ? 1 : 0) != 0);
            retyTimeSet.add(l);
        }
        Assert.assertTrue(((double)retyTimeSet.size() > (double)retries.length * 0.8 ? 1 : 0) != 0);
    }
}

