/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hive.org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientScannerRPCTimeout {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes("testFamily");
    private static final byte[] QUALIFIER = Bytes.toBytes("testQualifier");
    private static final byte[] VALUE = Bytes.toBytes("testValue");
    private static final int rpcTimeout = 2000;
    private static final int CLIENT_RETRIES_NUMBER = 3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ((Log4JLogger)RpcServer.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)AbstractRpcClient.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)ScannerCallable.LOG).getLogger().setLevel(Level.ALL);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.msginterval", 30000);
        conf.setInt("hbase.rpc.timeout", 2000);
        conf.setStrings("hbase.regionserver.impl", new String[]{RegionServerWithScanTimeout.class.getName()});
        conf.setInt("hbase.client.retries.number", 3);
        conf.setInt("hbase.client.pause", 1000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testScannerNextRPCTimesout() throws Exception {
        TableName TABLE_NAME = TableName.valueOf("testScannerNextRPCTimesout");
        HTable ht = TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        byte[] r1 = Bytes.toBytes("row-1");
        byte[] r2 = Bytes.toBytes("row-2");
        byte[] r3 = Bytes.toBytes("row-3");
        this.putToTable(ht, r1);
        this.putToTable(ht, r2);
        this.putToTable(ht, r3);
        this.LOG.info("Wrote our three values");
        RSRpcServicesWithScanTimeout.seqNoToSleepOn = 1L;
        Scan scan = new Scan();
        scan.setCaching(1);
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        Assert.assertTrue((String)"Expected row: row-1", (boolean)Bytes.equals(r1, result.getRow()));
        this.LOG.info("Got expected first row");
        long t1 = System.currentTimeMillis();
        result = scanner.next();
        Assert.assertTrue((System.currentTimeMillis() - t1 > 2000L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected row: row-2", (boolean)Bytes.equals(r2, result.getRow()));
        RSRpcServicesWithScanTimeout.seqNoToSleepOn = -1L;
        result = scanner.next();
        Assert.assertTrue((String)"Expected row: row-3", (boolean)Bytes.equals(r3, result.getRow()));
        scanner.close();
        scanner = ht.getScanner(scan);
        RSRpcServicesWithScanTimeout.sleepAlways = true;
        RSRpcServicesWithScanTimeout.tryNumber = 0;
        try {
            result = scanner.next();
        }
        catch (IOException ioe) {
            this.LOG.info("Failed after maximal attempts=3", ioe);
        }
        Assert.assertTrue((String)("Expected maximal try number=3, actual =" + RSRpcServicesWithScanTimeout.tryNumber), (RSRpcServicesWithScanTimeout.tryNumber <= 3 ? 1 : 0) != 0);
    }

    private void putToTable(Table ht, byte[] rowkey) throws IOException {
        Put put = new Put(rowkey);
        put.add(FAMILY, QUALIFIER, VALUE);
        ht.put(put);
    }

    private static class RSRpcServicesWithScanTimeout
    extends RSRpcServices {
        private long tableScannerId;
        private boolean slept;
        private static long seqNoToSleepOn = -1L;
        private static boolean sleepAlways = false;
        private static int tryNumber = 0;

        public RSRpcServicesWithScanTimeout(HRegionServer rs) throws IOException {
            super(rs);
        }

        @Override
        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            if (request.hasScannerId()) {
                ClientProtos.ScanResponse scanResponse = super.scan(controller, request);
                if (this.tableScannerId == request.getScannerId() && (sleepAlways || !this.slept && seqNoToSleepOn == request.getNextCallSeq())) {
                    try {
                        LOG.info("SLEEPING 2500");
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.slept = true;
                    if (++tryNumber > 6) {
                        sleepAlways = false;
                    }
                }
                return scanResponse;
            }
            ClientProtos.ScanResponse scanRes = super.scan(controller, request);
            String regionName = Bytes.toString(request.getRegion().getValue().toByteArray());
            if (!regionName.contains(TableName.META_TABLE_NAME.getNameAsString())) {
                this.tableScannerId = scanRes.getScannerId();
            }
            return scanRes;
        }
    }

    private static class RegionServerWithScanTimeout
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public RegionServerWithScanTimeout(Configuration conf, CoordinatedStateManager cp) throws IOException, InterruptedException {
            super(conf, cp);
        }

        @Override
        protected RSRpcServices createRpcServices() throws IOException {
            return new RSRpcServicesWithScanTimeout(this);
        }
    }
}

