/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ExponentialClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientPushback {
    private static final Log LOG = LogFactory.getLog(TestClientPushback.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] tableName = Bytes.toBytes("client-pushback");
    private static final byte[] family = Bytes.toBytes("f");
    private static final byte[] qualifier = Bytes.toBytes("q");
    private static long flushSizeBytes = 1024L;

    @BeforeClass
    public static void setupCluster() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setBoolean("hbase.client.backpressure.enabled", true);
        conf.setClass("hbase.client.statistics.backoff-policy", ExponentialClientBackoffPolicy.class, ClientBackoffPolicy.class);
        conf.setLong("hbase.hregion.memstore.flush.size", flushSizeBytes);
        conf.setLong("hbase.hregion.memstore.block.multiplier", 2L);
        UTIL.startMiniCluster();
        UTIL.createTable(tableName, family);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test(timeout=60000L)
    public void testClientTracksServerPushback() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        TableName tablename = TableName.valueOf(tableName);
        Connection conn = ConnectionFactory.createConnection(conf);
        HTable table = (HTable)conn.getTable(tablename);
        table.setAutoFlushTo(true);
        Put p = new Put(Bytes.toBytes("row"));
        p.add(family, qualifier, Bytes.toBytes("value1"));
        table.put(p);
        ClusterConnection connection = table.connection;
        ClientBackoffPolicy backoffPolicy = connection.getBackoffPolicy();
        Assert.assertTrue((String)"Backoff policy is not correctly configured", (boolean)(backoffPolicy instanceof ExponentialClientBackoffPolicy));
        ServerStatisticTracker stats = connection.getStatisticsTracker();
        Assert.assertNotNull((String)"No stats configured for the client!", (Object)stats);
        Region region = UTIL.getHBaseCluster().getRegionServer(0).getOnlineRegions(tablename).get(0);
        ServerName server = UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        byte[] regionName = region.getRegionInfo().getRegionName();
        ServerStatistics serverStats = stats.getServerStatsForTesting(server);
        ServerStatistics.RegionStatistics regionStats = serverStats.getStatsForRegion(regionName);
        int load = regionStats.getMemstoreLoadPercent();
        if (load < 11) {
            Assert.assertEquals((String)"Load on memstore too low", (long)11L, (long)load);
        }
        long backoffTime = backoffPolicy.getBackoffTime(server, regionName, serverStats);
        Assert.assertNotEquals((String)"Reported load does not produce a backoff", (long)backoffTime, (long)0L);
        LOG.debug("Backoff calculated for " + region.getRegionInfo().getRegionNameAsString() + " @ " + server + " is " + backoffTime);
        ArrayList<Put> ops = new ArrayList<Put>(1);
        ops.add(p);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong endTime = new AtomicLong();
        long startTime = EnvironmentEdgeManager.currentTime();
        table.mutator.ap.submit(tablename, ops, true, new Batch.Callback<Result>(){

            @Override
            public void update(byte[] region, byte[] row, Result result) {
                endTime.set(EnvironmentEdgeManager.currentTime());
                latch.countDown();
            }
        }, true);
        latch.await(backoffTime * 2L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((String)"AsyncProcess did not submit the work time", (long)endTime.get(), (long)0L);
        Assert.assertTrue((String)"AsyncProcess did not delay long enough", (endTime.get() - startTime >= backoffTime ? 1 : 0) != 0);
    }
}

