/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestClientOperationInterrupt {
    private static final Log LOG = LogFactory.getLog(TestClientOperationInterrupt.class);
    private static HBaseTestingUtility util;
    private static final TableName tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] test;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessor.class.getName()});
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
        HBaseAdmin admin = util.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        util.createTable(tableName, (byte[][])new byte[][]{dummy, test});
        HTable ht = new HTable(conf, tableName);
        Put p = new Put(row1);
        p.add(dummy, dummy, dummy);
        ht.put(p);
    }

    @Test
    public void testInterrupt50Percent() throws IOException, InterruptedException {
        int i;
        final AtomicInteger noEx = new AtomicInteger(0);
        final AtomicInteger badEx = new AtomicInteger(0);
        final AtomicInteger noInt = new AtomicInteger(0);
        final AtomicInteger done = new AtomicInteger(0);
        ArrayList<1> threads = new ArrayList<1>();
        int nbThread = 100;
        for (i = 0; i < 100; ++i) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HTable ht = new HTable(conf, tableName);
                        Result r = ht.get(new Get(row1));
                        noEx.incrementAndGet();
                    }
                    catch (IOException e) {
                        LOG.info("exception", e);
                        if (!(e instanceof InterruptedIOException) || e instanceof SocketTimeoutException) {
                            badEx.incrementAndGet();
                        } else if (Thread.currentThread().isInterrupted()) {
                            noInt.incrementAndGet();
                            LOG.info("The thread should NOT be with the 'interrupt' status.");
                        }
                    }
                    finally {
                        done.incrementAndGet();
                    }
                }
            };
            t.setName("TestClientOperationInterrupt #" + i);
            threads.add(t);
            t.start();
        }
        for (i = 0; i < 50; ++i) {
            ((Thread)threads.get(i)).interrupt();
        }
        boolean stillAlive = true;
        while (stillAlive) {
            stillAlive = false;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                stillAlive = true;
            }
            Threads.sleep(10L);
        }
        Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
        Assert.assertTrue((String)(" noEx: " + noEx.get() + ", badEx=" + badEx.get() + ", noInt=" + noInt.get()), (noEx.get() == 50 && badEx.get() == 0 ? 1 : 0) != 0);
        while (done.get() != 100) {
            Thread.sleep(1L);
        }
        HTable ht = new HTable(conf, tableName);
        Result result = ht.get(new Get(row1));
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    static {
        tableName = TableName.valueOf("test");
        dummy = Bytes.toBytes("dummy");
        row1 = Bytes.toBytes("r1");
        test = Bytes.toBytes("test");
    }

    public static class TestCoprocessor
    extends BaseRegionObserver {
        @Override
        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep(2500L);
        }
    }
}

