/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class MetaCache {
    private static final Log LOG = LogFactory.getLog(MetaCache.class);
    private final ConcurrentMap<TableName, ConcurrentSkipListMap<byte[], RegionLocations>> cachedRegionLocations = new ConcurrentHashMap<TableName, ConcurrentSkipListMap<byte[], RegionLocations>>();
    private final Set<ServerName> cachedServers = new ConcurrentSkipListSet<ServerName>();

    public RegionLocations getCachedLocation(TableName tableName, byte[] row) {
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        Map.Entry<byte[], RegionLocations> e = tableLocations.floorEntry(row);
        if (e == null) {
            return null;
        }
        RegionLocations possibleRegion = e.getValue();
        byte[] endKey = possibleRegion.getRegionLocation().getRegionInfo().getEndKey();
        if (Bytes.equals(endKey, HConstants.EMPTY_END_ROW) || this.getRowComparator(tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0) {
            return possibleRegion;
        }
        return null;
    }

    private KeyValue.KVComparator getRowComparator(TableName tableName) {
        return TableName.META_TABLE_NAME.equals(tableName) ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR;
    }

    public void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
        boolean isNewCacheEntry;
        assert (source != null);
        byte[] startKey = location.getRegionInfo().getStartKey();
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations locations = new RegionLocations(location);
        RegionLocations oldLocations = tableLocations.putIfAbsent(startKey, locations);
        boolean bl = isNewCacheEntry = oldLocations == null;
        if (isNewCacheEntry) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cached location: " + location);
            }
            this.addToCachedServers(locations);
            return;
        }
        HRegionLocation oldLocation = oldLocations.getRegionLocation(location.getRegionInfo().getReplicaId());
        boolean force = oldLocation != null && oldLocation.getServerName() != null && oldLocation.getServerName().equals(source);
        RegionLocations updatedLocations = oldLocations.updateLocation(location, false, force);
        if (oldLocations != updatedLocations) {
            boolean replaced = tableLocations.replace(startKey, oldLocations, updatedLocations);
            if (replaced && LOG.isTraceEnabled()) {
                LOG.trace("Changed cached location to: " + location);
            }
            this.addToCachedServers(updatedLocations);
        }
    }

    public void cacheLocation(TableName tableName, RegionLocations locations) {
        boolean isNewCacheEntry;
        byte[] startKey = locations.getRegionLocation().getRegionInfo().getStartKey();
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations oldLocation = tableLocations.putIfAbsent(startKey, locations);
        boolean bl = isNewCacheEntry = oldLocation == null;
        if (isNewCacheEntry) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cached location: " + locations);
            }
            this.addToCachedServers(locations);
            return;
        }
        RegionLocations mergedLocation = oldLocation.mergeLocations(locations);
        boolean replaced = tableLocations.replace(startKey, oldLocation, mergedLocation);
        if (replaced && LOG.isTraceEnabled()) {
            LOG.trace("Merged cached locations: " + mergedLocation);
        }
        this.addToCachedServers(locations);
    }

    private void addToCachedServers(RegionLocations locations) {
        for (HRegionLocation loc : locations.getRegionLocations()) {
            if (loc == null) continue;
            this.cachedServers.add(loc.getServerName());
        }
    }

    private ConcurrentSkipListMap<byte[], RegionLocations> getTableLocations(TableName tableName) {
        ConcurrentSkipListMap<byte[], RegionLocations> old;
        ConcurrentSkipListMap result = (ConcurrentSkipListMap)this.cachedRegionLocations.get(tableName);
        if (result == null && (old = this.cachedRegionLocations.putIfAbsent(tableName, result = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR))) != null) {
            return old;
        }
        return result;
    }

    public boolean isRegionCached(TableName tableName, byte[] row) {
        RegionLocations location = this.getCachedLocation(tableName, row);
        return location != null;
    }

    public int getNumberOfCachedRegionLocations(TableName tableName) {
        Map tableLocs = (Map)this.cachedRegionLocations.get(tableName);
        if (tableLocs == null) {
            return 0;
        }
        int numRegions = 0;
        for (RegionLocations tableLoc : tableLocs.values()) {
            numRegions += tableLoc.numNonNullElements();
        }
        return numRegions;
    }

    public void clearCache() {
        this.cachedRegionLocations.clear();
        this.cachedServers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ServerName serverName) {
        if (!this.cachedServers.contains(serverName)) {
            return;
        }
        boolean deletedSomething = false;
        Set<ServerName> set = this.cachedServers;
        synchronized (set) {
            if (!this.cachedServers.contains(serverName)) {
                return;
            }
            for (ConcurrentMap tableLocations : this.cachedRegionLocations.values()) {
                for (Map.Entry e : tableLocations.entrySet()) {
                    RegionLocations updatedLocations;
                    RegionLocations regionLocations = (RegionLocations)e.getValue();
                    if (regionLocations == null || (updatedLocations = regionLocations.removeByServer(serverName)) == regionLocations) continue;
                    if (updatedLocations.isEmpty()) {
                        deletedSomething |= tableLocations.remove(e.getKey(), regionLocations);
                        continue;
                    }
                    deletedSomething |= tableLocations.replace(e.getKey(), regionLocations, updatedLocations);
                }
            }
            this.cachedServers.remove(serverName);
        }
        if (deletedSomething && LOG.isTraceEnabled()) {
            LOG.trace("Removed all cached region locations that map to " + serverName);
        }
    }

    public void clearCache(TableName tableName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removed all cached region locations for table " + tableName);
        }
        this.cachedRegionLocations.remove(tableName);
    }

    public void clearCache(TableName tableName, byte[] row, int replicaId) {
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        boolean removed = false;
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null) {
            HRegionLocation toBeRemoved = regionLocations.getRegionLocation(replicaId);
            RegionLocations updatedLocations = regionLocations.remove(replicaId);
            if (updatedLocations != regionLocations) {
                byte[] startKey = regionLocations.getRegionLocation().getRegionInfo().getStartKey();
                removed = updatedLocations.isEmpty() ? tableLocations.remove(startKey, regionLocations) : tableLocations.replace(startKey, regionLocations, updatedLocations);
            }
            if (removed && LOG.isTraceEnabled() && toBeRemoved != null) {
                LOG.trace("Removed " + toBeRemoved + " from cache");
            }
        }
    }

    public void clearCache(TableName tableName, byte[] row) {
        byte[] startKey;
        boolean removed;
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null && (removed = tableLocations.remove(startKey = regionLocations.getRegionLocation().getRegionInfo().getStartKey(), regionLocations)) && LOG.isTraceEnabled()) {
            LOG.trace("Removed " + regionLocations + " from cache");
        }
    }

    public void clearCache(TableName tableName, byte[] row, ServerName serverName) {
        RegionLocations updatedLocations;
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = this.getCachedLocation(tableName, row);
        if (regionLocations != null && (updatedLocations = regionLocations.removeByServer(serverName)) != regionLocations) {
            byte[] startKey = regionLocations.getRegionLocation().getRegionInfo().getStartKey();
            boolean removed = false;
            removed = updatedLocations.isEmpty() ? tableLocations.remove(startKey, regionLocations) : tableLocations.replace(startKey, regionLocations, updatedLocations);
            if (removed && LOG.isTraceEnabled()) {
                LOG.trace("Removed locations of table: " + tableName + " ,row: " + Bytes.toString(row) + " mapping to server: " + serverName + " from cache");
            }
        }
    }

    public void clearCache(HRegionInfo hri) {
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(hri.getTable());
        RegionLocations regionLocations = (RegionLocations)tableLocations.get(hri.getStartKey());
        if (regionLocations != null) {
            HRegionLocation oldLocation = regionLocations.getRegionLocation(hri.getReplicaId());
            if (oldLocation == null) {
                return;
            }
            RegionLocations updatedLocations = regionLocations.remove(oldLocation);
            boolean removed = false;
            if (updatedLocations != regionLocations && (removed = updatedLocations.isEmpty() ? tableLocations.remove(hri.getStartKey(), regionLocations) : tableLocations.replace(hri.getStartKey(), regionLocations, updatedLocations)) && LOG.isTraceEnabled()) {
                LOG.trace("Removed " + oldLocation + " from cache");
            }
        }
    }

    public void clearCache(HRegionLocation location) {
        if (location == null) {
            return;
        }
        TableName tableName = location.getRegionInfo().getTable();
        ConcurrentSkipListMap<byte[], RegionLocations> tableLocations = this.getTableLocations(tableName);
        RegionLocations regionLocations = (RegionLocations)tableLocations.get(location.getRegionInfo().getStartKey());
        if (regionLocations != null) {
            RegionLocations updatedLocations = regionLocations.remove(location);
            boolean removed = false;
            if (updatedLocations != regionLocations && (removed = updatedLocations.isEmpty() ? tableLocations.remove(location.getRegionInfo().getStartKey(), regionLocations) : tableLocations.replace(location.getRegionInfo().getStartKey(), regionLocations, updatedLocations)) && LOG.isTraceEnabled()) {
                LOG.trace("Removed " + location + " from cache");
            }
        }
    }
}

