/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;

@InterfaceAudience.Private
abstract class ConnectionAdapter
implements ClusterConnection {
    private final ClusterConnection wrappedConnection;

    public ConnectionAdapter(Connection c) {
        this.wrappedConnection = (ClusterConnection)c;
    }

    @Override
    public void abort(String why, Throwable e) {
        this.wrappedConnection.abort(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.wrappedConnection.isAborted();
    }

    @Override
    public void close() throws IOException {
        this.wrappedConnection.close();
    }

    @Override
    public Configuration getConfiguration() {
        return this.wrappedConnection.getConfiguration();
    }

    @Override
    public HTableInterface getTable(String tableName) throws IOException {
        return this.wrappedConnection.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(byte[] tableName) throws IOException {
        return this.wrappedConnection.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(TableName tableName) throws IOException {
        return this.wrappedConnection.getTable(tableName);
    }

    @Override
    public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
        return this.wrappedConnection.getTable(tableName, pool);
    }

    @Override
    public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
        return this.wrappedConnection.getTable(tableName, pool);
    }

    @Override
    public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.wrappedConnection.getTable(tableName, pool);
    }

    @Override
    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        return this.wrappedConnection.getBufferedMutator(params);
    }

    @Override
    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.wrappedConnection.getBufferedMutator(tableName);
    }

    @Override
    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return this.wrappedConnection.getRegionLocator(tableName);
    }

    @Override
    public Admin getAdmin() throws IOException {
        return this.wrappedConnection.getAdmin();
    }

    @Override
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.wrappedConnection.isMasterRunning();
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.wrappedConnection.isTableEnabled(tableName);
    }

    @Override
    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.wrappedConnection.isTableEnabled(tableName);
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.wrappedConnection.isTableDisabled(tableName);
    }

    @Override
    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.wrappedConnection.isTableDisabled(tableName);
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.wrappedConnection.isTableAvailable(tableName);
    }

    @Override
    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.wrappedConnection.isTableAvailable(tableName);
    }

    @Override
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.wrappedConnection.isTableAvailable(tableName, splitKeys);
    }

    @Override
    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.wrappedConnection.isTableAvailable(tableName, splitKeys);
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        return this.wrappedConnection.listTables();
    }

    @Override
    public String[] getTableNames() throws IOException {
        return this.wrappedConnection.getTableNames();
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        return this.wrappedConnection.listTableNames();
    }

    @Override
    public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
        return this.wrappedConnection.getHTableDescriptor(tableName);
    }

    @Override
    public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
        return this.wrappedConnection.getHTableDescriptor(tableName);
    }

    @Override
    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        return this.wrappedConnection.locateRegion(tableName, row);
    }

    @Override
    public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.wrappedConnection.locateRegion(tableName, row);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.wrappedConnection.locateRegion(tableName, row, useCache, retry);
    }

    @Override
    public void clearRegionCache() {
        this.wrappedConnection.clearRegionCache();
    }

    @Override
    public void clearRegionCache(TableName tableName) {
        this.wrappedConnection.clearRegionCache(tableName);
    }

    @Override
    public void clearRegionCache(byte[] tableName) {
        this.wrappedConnection.clearRegionCache(tableName);
    }

    @Override
    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.wrappedConnection.deleteCachedRegionLocation(location);
    }

    @Override
    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.wrappedConnection.relocateRegion(tableName, row);
    }

    @Override
    public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
        return this.wrappedConnection.relocateRegion(tableName, row);
    }

    @Override
    public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.wrappedConnection.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Override
    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        this.wrappedConnection.updateCachedLocations(tableName, regionName, rowkey, exception, source);
    }

    @Override
    public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
        this.wrappedConnection.updateCachedLocations(tableName, rowkey, exception, source);
    }

    @Override
    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        return this.wrappedConnection.locateRegion(regionName);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.wrappedConnection.locateRegions(tableName);
    }

    @Override
    public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
        return this.wrappedConnection.locateRegions(tableName);
    }

    @Override
    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.wrappedConnection.locateRegions(tableName, useCache, offlined);
    }

    @Override
    public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
        return this.wrappedConnection.locateRegions(tableName, useCache, offlined);
    }

    @Override
    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.wrappedConnection.locateRegion(tableName, row, useCache, retry, replicaId);
    }

    @Override
    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        return this.wrappedConnection.relocateRegion(tableName, row, replicaId);
    }

    @Override
    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException {
        return this.wrappedConnection.getMaster();
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return this.wrappedConnection.getAdmin(serverName);
    }

    @Override
    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        return this.wrappedConnection.getClient(serverName);
    }

    @Override
    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean getMaster) throws IOException {
        return this.wrappedConnection.getAdmin(serverName, getMaster);
    }

    @Override
    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.wrappedConnection.getRegionLocation(tableName, row, reload);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
        return this.wrappedConnection.getRegionLocation(tableName, row, reload);
    }

    @Override
    public void processBatch(List<? extends Row> actions2, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.wrappedConnection.processBatch(actions2, tableName, pool, results);
    }

    @Override
    public void processBatch(List<? extends Row> actions2, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
        this.wrappedConnection.processBatch(actions2, tableName, pool, results);
    }

    @Override
    public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.wrappedConnection.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Override
    public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.wrappedConnection.processBatchCallback(list, tableName, pool, results, callback);
    }

    @Override
    public void setRegionCachePrefetch(TableName tableName, boolean enable) {
        this.wrappedConnection.setRegionCachePrefetch(tableName, enable);
    }

    @Override
    public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
        this.wrappedConnection.setRegionCachePrefetch(tableName, enable);
    }

    @Override
    public boolean getRegionCachePrefetch(TableName tableName) {
        return this.wrappedConnection.getRegionCachePrefetch(tableName);
    }

    @Override
    public boolean getRegionCachePrefetch(byte[] tableName) {
        return this.wrappedConnection.getRegionCachePrefetch(tableName);
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        return this.wrappedConnection.getCurrentNrHRS();
    }

    @Override
    public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.wrappedConnection.getHTableDescriptorsByTableName(tableNames);
    }

    @Override
    public HTableDescriptor[] getHTableDescriptors(List<String> tableNames) throws IOException {
        return this.wrappedConnection.getHTableDescriptors(tableNames);
    }

    @Override
    public boolean isClosed() {
        return this.wrappedConnection.isClosed();
    }

    @Override
    public void clearCaches(ServerName sn) {
        this.wrappedConnection.clearCaches(sn);
    }

    @Override
    public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
        return this.wrappedConnection.getKeepAliveMasterService();
    }

    @Override
    public boolean isDeadServer(ServerName serverName) {
        return this.wrappedConnection.isDeadServer(serverName);
    }

    @Override
    public NonceGenerator getNonceGenerator() {
        return this.wrappedConnection.getNonceGenerator();
    }

    @Override
    public AsyncProcess getAsyncProcess() {
        return this.wrappedConnection.getAsyncProcess();
    }

    @Override
    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return this.wrappedConnection.getNewRpcRetryingCallerFactory(conf);
    }

    @Override
    public boolean isManaged() {
        return this.wrappedConnection.isManaged();
    }

    @Override
    public ServerStatisticTracker getStatisticsTracker() {
        return this.wrappedConnection.getStatisticsTracker();
    }

    @Override
    public ClientBackoffPolicy getBackoffPolicy() {
        return this.wrappedConnection.getBackoffPolicy();
    }
}

