/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.backup.example.LongTermArchivingHFileCleaner;
import org.apache.hadoop.hbase.backup.example.ZKTableArchiveClient;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MediumTests.class})
public class TestZooKeeperTableArchiveClient {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperTableArchiveClient.class);
    private static final HBaseTestingUtility UTIL = HBaseTestingUtility.createLocalHTU();
    private static final String STRING_TABLE_NAME = "test";
    private static final byte[] TEST_FAM = Bytes.toBytes("fam");
    private static final byte[] TABLE_NAME = Bytes.toBytes("test");
    private static ZKTableArchiveClient archivingClient;
    private final List<Path> toCleanup = new ArrayList<Path>();
    private static ClusterConnection CONNECTION;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestZooKeeperTableArchiveClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniZKCluster();
        CONNECTION = (ClusterConnection)ConnectionFactory.createConnection(UTIL.getConfiguration());
        archivingClient = new ZKTableArchiveClient(UTIL.getConfiguration(), CONNECTION);
        ZooKeeperWatcher watcher = UTIL.getZooKeeperWatcher();
        String archivingZNode = ZKTableArchiveClient.getArchiveZNode(UTIL.getConfiguration(), watcher);
        ZKUtil.createWithParents(watcher, archivingZNode);
    }

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.hstore.compaction.min", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            FileSystem fs = UTIL.getTestFileSystem();
            for (Path file : this.toCleanup) {
                FSUtils.delete(fs, file, true);
            }
        }
        catch (IOException e) {
            LOG.warn("Failure to delete archive directory", e);
        }
        finally {
            this.toCleanup.clear();
        }
        archivingClient.disableHFileBackup();
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            CONNECTION.close();
            UTIL.shutdownMiniZKCluster();
        }
        catch (Exception e) {
            LOG.warn("problem shutting down cluster", e);
        }
    }

    @Test(timeout=300000L)
    public void testArchivingEnableDisable() throws Exception {
        LOG.debug("----Starting archiving");
        archivingClient.enableHFileBackupAsync(TABLE_NAME);
        Assert.assertTrue((String)"Archving didn't get turned on", (boolean)archivingClient.getArchivingEnabled(TABLE_NAME));
        archivingClient.disableHFileBackup();
        Assert.assertFalse((String)"Archving didn't get turned off.", (boolean)archivingClient.getArchivingEnabled(TABLE_NAME));
        archivingClient.enableHFileBackupAsync(TABLE_NAME);
        Assert.assertTrue((String)"Archving didn't get turned on", (boolean)archivingClient.getArchivingEnabled(TABLE_NAME));
        archivingClient.disableHFileBackup(TABLE_NAME);
        Assert.assertFalse((String)"Archving didn't get turned off for test", (boolean)archivingClient.getArchivingEnabled(TABLE_NAME));
    }

    @Test(timeout=300000L)
    public void testArchivingOnSingleTable() throws Exception {
        this.createArchiveDirectory();
        FileSystem fs = UTIL.getTestFileSystem();
        Path archiveDir = this.getArchiveDir();
        Path tableDir = this.getTableDir(STRING_TABLE_NAME);
        this.toCleanup.add(archiveDir);
        this.toCleanup.add(tableDir);
        Configuration conf = UTIL.getConfiguration();
        StoppableImplementation stop = new StoppableImplementation();
        HFileCleaner cleaner = this.setupAndCreateCleaner(conf, fs, archiveDir, stop);
        List<BaseHFileCleanerDelegate> cleaners = this.turnOnArchiving(STRING_TABLE_NAME, cleaner);
        LongTermArchivingHFileCleaner delegate = (LongTermArchivingHFileCleaner)cleaners.get(0);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAM);
        HRegion region = UTIL.createTestRegion(STRING_TABLE_NAME, hcd);
        this.loadFlushAndCompact(region, TEST_FAM);
        List<Path> files = this.getAllFiles(fs, archiveDir);
        if (files == null) {
            FSUtils.logFileSystemState(fs, UTIL.getDataTestDir(), LOG);
            throw new RuntimeException("Didn't archive any files!");
        }
        CountDownLatch finished = this.setupCleanerWatching(delegate, cleaners, files.size());
        this.runCleaner(cleaner, finished, stop);
        List<Path> archivedFiles = this.getAllFiles(fs, archiveDir);
        Assert.assertEquals((String)"Archived files changed after running archive cleaner.", files, archivedFiles);
        Assert.assertTrue((boolean)fs.exists(HFileArchiveUtil.getArchivePath(UTIL.getConfiguration())));
    }

    @Test(timeout=300000L)
    public void testMultipleTables() throws Exception {
        this.createArchiveDirectory();
        String otherTable = "otherTable";
        FileSystem fs = UTIL.getTestFileSystem();
        Path archiveDir = this.getArchiveDir();
        Path tableDir = this.getTableDir(STRING_TABLE_NAME);
        Path otherTableDir = this.getTableDir(otherTable);
        this.toCleanup.add(archiveDir);
        this.toCleanup.add(tableDir);
        this.toCleanup.add(otherTableDir);
        Configuration conf = UTIL.getConfiguration();
        StoppableImplementation stop = new StoppableImplementation();
        ChoreService choreService = new ChoreService("TEST_SERVER_NAME");
        HFileCleaner cleaner = this.setupAndCreateCleaner(conf, fs, archiveDir, stop);
        List<BaseHFileCleanerDelegate> cleaners = this.turnOnArchiving(STRING_TABLE_NAME, cleaner);
        LongTermArchivingHFileCleaner delegate = (LongTermArchivingHFileCleaner)cleaners.get(0);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAM);
        HRegion region = UTIL.createTestRegion(STRING_TABLE_NAME, hcd);
        this.loadFlushAndCompact(region, TEST_FAM);
        hcd = new HColumnDescriptor(TEST_FAM);
        HRegion otherRegion = UTIL.createTestRegion(otherTable, hcd);
        this.loadFlushAndCompact(otherRegion, TEST_FAM);
        List<Path> files = this.getAllFiles(fs, archiveDir);
        if (files == null) {
            FSUtils.logFileSystemState(fs, archiveDir, LOG);
            throw new RuntimeException("Didn't load archive any files!");
        }
        int initialCountForPrimary = 0;
        int initialCountForOtherTable = 0;
        for (Path file : files) {
            String tableName = file.getParent().getParent().getParent().getName();
            if (tableName.equals(otherTable)) {
                ++initialCountForOtherTable;
                continue;
            }
            if (!tableName.equals(STRING_TABLE_NAME)) continue;
            ++initialCountForPrimary;
        }
        Assert.assertTrue((String)"Didn't archive files for:test", (initialCountForPrimary > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Didn't archive files for:" + otherTable), (initialCountForOtherTable > 0 ? 1 : 0) != 0);
        CountDownLatch finished = this.setupCleanerWatching(delegate, cleaners, files.size() + 3);
        choreService.scheduleChore(cleaner);
        finished.await();
        stop.stop("");
        List<Path> archivedFiles = this.getAllFiles(fs, archiveDir);
        int archivedForPrimary = 0;
        for (Path file : archivedFiles) {
            String tableName = file.getParent().getParent().getParent().getName();
            Assert.assertFalse((String)("Have a file from the non-archived table: " + file), (boolean)tableName.equals(otherTable));
            if (!tableName.equals(STRING_TABLE_NAME)) continue;
            ++archivedForPrimary;
        }
        Assert.assertEquals((String)"Not all archived files for the primary table were retained.", (long)initialCountForPrimary, (long)archivedForPrimary);
        Assert.assertTrue((String)"Archive directory was deleted via archiver", (boolean)fs.exists(archiveDir));
    }

    private void createArchiveDirectory() throws IOException {
        FileSystem fs = UTIL.getTestFileSystem();
        Path archiveDir = this.getArchiveDir();
        fs.mkdirs(archiveDir);
    }

    private Path getArchiveDir() throws IOException {
        return new Path(UTIL.getDataTestDir(), "archive");
    }

    private Path getTableDir(String tableName) throws IOException {
        Path testDataDir = UTIL.getDataTestDir();
        FSUtils.setRootDir(UTIL.getConfiguration(), testDataDir);
        return new Path(testDataDir, tableName);
    }

    private HFileCleaner setupAndCreateCleaner(Configuration conf, FileSystem fs, Path archiveDir, Stoppable stop) {
        conf.setStrings("hbase.master.hfilecleaner.plugins", new String[]{LongTermArchivingHFileCleaner.class.getCanonicalName()});
        return new HFileCleaner(1000, stop, conf, fs, archiveDir);
    }

    private List<BaseHFileCleanerDelegate> turnOnArchiving(String tableName, HFileCleaner cleaner) throws IOException, KeeperException {
        LOG.debug("----Starting archiving for table:" + tableName);
        archivingClient.enableHFileBackupAsync(Bytes.toBytes(tableName));
        Assert.assertTrue((String)"Archving didn't get turned on", (boolean)archivingClient.getArchivingEnabled(tableName));
        List<BaseHFileCleanerDelegate> cleaners = cleaner.getDelegatesForTesting();
        LongTermArchivingHFileCleaner delegate = (LongTermArchivingHFileCleaner)cleaners.get(0);
        while (!delegate.archiveTracker.keepHFiles(STRING_TABLE_NAME)) {
        }
        return cleaners;
    }

    private CountDownLatch setupCleanerWatching(LongTermArchivingHFileCleaner cleaner, List<BaseHFileCleanerDelegate> cleaners, final int expected) {
        BaseHFileCleanerDelegate delegateSpy = (BaseHFileCleanerDelegate)Mockito.spy((Object)cleaner);
        final int[] counter = new int[]{0};
        final CountDownLatch finished = new CountDownLatch(1);
        ((BaseHFileCleanerDelegate)Mockito.doAnswer((Answer)new Answer<Iterable<FileStatus>>(){

            public Iterable<FileStatus> answer(InvocationOnMock invocation) throws Throwable {
                counter[0] = counter[0] + 1;
                LOG.debug(counter[0] + "/ " + expected + ") Wrapping call to getDeletableFiles for files: " + invocation.getArguments()[0]);
                Iterable ret = (Iterable)invocation.callRealMethod();
                if (counter[0] >= expected) {
                    finished.countDown();
                }
                return ret;
            }
        }).when((Object)delegateSpy)).getDeletableFiles(Mockito.anyListOf(FileStatus.class));
        cleaners.set(0, delegateSpy);
        return finished;
    }

    private List<Path> getAllFiles(FileSystem fs, Path dir) throws IOException {
        FileStatus[] files = FSUtils.listStatus(fs, dir, null);
        if (files == null) {
            LOG.warn("No files under:" + dir);
            return null;
        }
        ArrayList<Path> allFiles = new ArrayList<Path>();
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                List<Path> subFiles = this.getAllFiles(fs, file.getPath());
                if (subFiles == null) continue;
                allFiles.addAll(subFiles);
                continue;
            }
            allFiles.add(file.getPath());
        }
        return allFiles;
    }

    private void loadFlushAndCompact(Region region, byte[] family) throws IOException {
        this.createHFileInRegion(region, family);
        this.createHFileInRegion(region, family);
        Store s = region.getStore(family);
        int count = s.getStorefilesCount();
        Assert.assertTrue((String)("Don't have the expected store files, wanted >= 2 store files, but was:" + count), (count >= 2 ? 1 : 0) != 0);
        LOG.debug("Compacting stores");
        region.compact(true);
    }

    private void createHFileInRegion(Region region, byte[] columnFamily) throws IOException {
        Put p = new Put(Bytes.toBytes("row"));
        p.add(columnFamily, Bytes.toBytes("Qual"), Bytes.toBytes("v1"));
        region.put(p);
        region.flush(true);
    }

    private void runCleaner(HFileCleaner cleaner, CountDownLatch finished, Stoppable stop) throws InterruptedException {
        ChoreService choreService = new ChoreService("CLEANER_SERVER_NAME");
        choreService.scheduleChore(cleaner);
        finished.await();
        stop.stop("");
    }
}

