/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.ConnectException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMetaTableLocator {
    private static final Log LOG = LogFactory.getLog(TestMetaTableLocator.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final ServerName SN = ServerName.valueOf("example.org", 1234, System.currentTimeMillis());
    private ZooKeeperWatcher watcher;
    private Abortable abortable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                LOG.info(why, e);
            }

            @Override
            public boolean isAborted() {
                return false;
            }
        };
        this.watcher = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable, true);
    }

    @After
    public void after() {
        try {
            new MetaTableLocator().deleteMetaLocation(this.watcher);
        }
        catch (KeeperException e) {
            LOG.warn("Unable to delete hbase:meta location", e);
        }
        this.watcher.close();
    }

    @Test
    public void testMetaLookup() throws IOException, InterruptedException, ServiceException, KeeperException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        MetaTableLocator mtl = new MetaTableLocator();
        Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
        for (RegionState.State state : RegionState.State.values()) {
            if (state.equals((Object)RegionState.State.OPEN)) continue;
            MetaTableLocator.setMetaLocation(this.watcher, SN, state);
            Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
            Assert.assertEquals((Object)((Object)state), (Object)((Object)MetaTableLocator.getMetaRegionState(this.watcher).getState()));
        }
        MetaTableLocator.setMetaLocation(this.watcher, SN, RegionState.State.OPEN);
        Assert.assertEquals((Object)mtl.getMetaRegionLocation(this.watcher), (Object)SN);
        Assert.assertEquals((Object)((Object)RegionState.State.OPEN), (Object)((Object)MetaTableLocator.getMetaRegionState(this.watcher).getState()));
        mtl.deleteMetaLocation(this.watcher);
        Assert.assertNull((Object)MetaTableLocator.getMetaRegionState(this.watcher).getServerName());
        Assert.assertEquals((Object)((Object)MetaTableLocator.getMetaRegionState(this.watcher).getState()), (Object)((Object)RegionState.State.OFFLINE));
        Assert.assertNull((Object)mtl.getMetaRegionLocation(this.watcher));
    }

    @Test
    public void testInterruptWaitOnMeta() throws IOException, InterruptedException, ServiceException {
        ClientProtos.ClientService.BlockingInterface client = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)client.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenReturn((Object)ClientProtos.GetResponse.newBuilder().build());
        final MetaTableLocator mtl = new MetaTableLocator();
        ServerName meta = new MetaTableLocator().getMetaRegionLocation(this.watcher);
        Assert.assertNull((Object)meta);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    mtl.waitMetaRegionLocation(TestMetaTableLocator.this.watcher);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep(1L);
        }
        Threads.sleep(1L);
        Assert.assertTrue((boolean)t.isAlive());
        mtl.stop();
        t.join();
    }

    private void testVerifyMetaRegionLocationWithException(Exception ex) throws IOException, InterruptedException, KeeperException, ServiceException {
        ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        ClusterConnection connection = this.mockConnection(null, implementation);
        Mockito.when((Object)implementation.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)ex)});
        long timeout = UTIL.getConfiguration().getLong("hbase.catalog.verification.timeout", 1000L);
        MetaTableLocator.setMetaLocation(this.watcher, SN, RegionState.State.OPENING);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, timeout));
        MetaTableLocator.setMetaLocation(this.watcher, SN, RegionState.State.OPEN);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, timeout));
    }

    @Test
    public void testGetMetaServerConnectionFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException(new ConnectException("Connection refused"));
    }

    @Test
    public void testVerifyMetaRegionServerNotRunning() throws IOException, InterruptedException, KeeperException, ServiceException {
        this.testVerifyMetaRegionLocationWithException(new ServerNotRunningYetException("mock"));
    }

    @Test
    public void testVerifyMetaRegionLocationFails() throws IOException, InterruptedException, KeeperException, ServiceException {
        ClusterConnection connection = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        ServiceException connectException = new ServiceException((Throwable)new ConnectException("Connection refused"));
        AdminProtos.AdminService.BlockingInterface implementation = (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class);
        Mockito.when((Object)implementation.getRegionInfo((RpcController)Mockito.any(), (AdminProtos.GetRegionInfoRequest)Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)implementation);
        ServerName sn = ServerName.valueOf("example.com", 1234, System.currentTimeMillis());
        MetaTableLocator.setMetaLocation(this.watcher, sn, RegionState.State.OPENING);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, 100L));
        MetaTableLocator.setMetaLocation(this.watcher, sn, RegionState.State.OPEN);
        Assert.assertFalse((boolean)new MetaTableLocator().verifyMetaRegionLocation(connection, this.watcher, 100L));
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        new MetaTableLocator().waitMetaRegionLocation(this.watcher, 100L);
    }

    @Test
    public void testNoTimeoutWaitForMeta() throws IOException, InterruptedException, KeeperException {
        MetaTableLocator mtl = new MetaTableLocator();
        ServerName hsa = mtl.getMetaRegionLocation(this.watcher);
        Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread();
        this.startWaitAliveThenWaitItLives(t, 1);
        MetaTableLocator.setMetaLocation(this.watcher, SN, RegionState.State.OPEN);
        hsa = SN;
        t.join();
        Assert.assertTrue((boolean)mtl.getMetaRegionLocation(this.watcher).equals(hsa));
    }

    private ClusterConnection mockConnection(AdminProtos.AdminService.BlockingInterface admin, ClientProtos.ClientService.BlockingInterface client) throws IOException {
        ClusterConnection connection = HConnectionTestingUtility.getMockedConnection(UTIL.getConfiguration());
        ((ClusterConnection)Mockito.doNothing().when((Object)connection)).close();
        HRegionLocation anyLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, SN);
        Mockito.when((Object)connection.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)anyLocation);
        Mockito.when((Object)connection.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)anyLocation);
        if (admin != null) {
            Mockito.when((Object)connection.getAdmin((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)admin);
        }
        if (client != null) {
            Mockito.when((Object)connection.getClient((ServerName)Mockito.any(ServerName.class))).thenReturn((Object)client);
        }
        return connection;
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        while (!t.isAlive()) {
        }
        Threads.sleep(ms);
        Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        WaitOnMetaThread() {
            super("WaitOnMeta");
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info("Exiting " + this.getName());
        }

        void doWaiting() throws InterruptedException {
            try {
                while (new MetaTableLocator().waitMetaRegionLocation(TestMetaTableLocator.this.watcher, 10000L) == null) {
                }
            }
            catch (NotAllMetaRegionsOnlineException notAllMetaRegionsOnlineException) {
                // empty catch block
            }
        }
    }
}

