/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestMetaTableAccessorNoCluster {
    private static final Log LOG = LogFactory.getLog(TestMetaTableAccessorNoCluster.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Abortable ABORTABLE = new Abortable(){
        boolean aborted = false;

        @Override
        public void abort(String why, Throwable e) {
            LOG.info(why, e);
            this.aborted = true;
            throw new RuntimeException(e);
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }
    };

    @Before
    public void before() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @After
    public void after() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testGetHRegionInfo() throws IOException {
        Assert.assertNull((Object)HRegionInfo.getHRegionInfo(new Result()));
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        Result r = Result.create(kvs);
        Assert.assertNull((Object)HRegionInfo.getHRegionInfo(r));
        byte[] f = HConstants.CATALOG_FAMILY;
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.SERVER_QUALIFIER, f));
        r = Result.create(kvs);
        Assert.assertNull((Object)HRegionInfo.getHRegionInfo(r));
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, f));
        HRegionInfo hri = HRegionInfo.getHRegionInfo(Result.create(kvs));
        Assert.assertTrue((hri == null ? 1 : 0) != 0);
        kvs.clear();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, f, HConstants.REGIONINFO_QUALIFIER, HRegionInfo.FIRST_META_REGIONINFO.toByteArray()));
        hri = HRegionInfo.getHRegionInfo(Result.create(kvs));
        Assert.assertNotNull((Object)hri);
        Assert.assertTrue((boolean)hri.equals(HRegionInfo.FIRST_META_REGIONINFO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRideOverServerNotRunning() throws IOException, InterruptedException, ServiceException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), ABORTABLE, true);
        ServerName sn = ServerName.valueOf("example.com", 1234, System.currentTimeMillis());
        HConnection connection = null;
        try {
            ClientProtos.ClientService.BlockingInterface implementation = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
            ArrayList<Cell> kvs = new ArrayList<Cell>();
            byte[] rowToVerify = Bytes.toBytes("rowToVerify");
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, HRegionInfo.FIRST_META_REGIONINFO.toByteArray()));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes(sn.getHostAndPort())));
            kvs.add(new KeyValue(rowToVerify, HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes(sn.getStartcode())));
            final ArrayList<Result> cellScannables = new ArrayList<Result>(1);
            cellScannables.add(Result.create(kvs));
            final ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
            for (CellScannable cellScannable : cellScannables) {
                builder.addCellsPerResult(((Result)cellScannable).size());
            }
            Mockito.when((Object)implementation.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException("Server not running (1 of 3)")}).thenThrow(new Throwable[]{new ServiceException("Server not running (2 of 3)")}).thenThrow(new Throwable[]{new ServiceException("Server not running (3 of 3)")}).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(1234567890L).build()).thenAnswer((Answer)new Answer<ClientProtos.ScanResponse>(){

                public ClientProtos.ScanResponse answer(InvocationOnMock invocation) throws Throwable {
                    ((PayloadCarryingRpcController)invocation.getArguments()[0]).setCellScanner(CellUtil.createCellScanner(cellScannables));
                    return builder.build();
                }
            }).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setMoreResults(false).build());
            connection = HConnectionTestingUtility.getSpiedConnection(UTIL.getConfiguration());
            HRegionLocation anyLocation = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, sn);
            RegionLocations regionLocations = new RegionLocations(anyLocation);
            ClusterConnection cConnection = HConnectionTestingUtility.getSpiedClusterConnection(UTIL.getConfiguration());
            ((ClusterConnection)Mockito.doReturn((Object)regionLocations).when((Object)cConnection)).locateRegion((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyInt());
            ((ClusterConnection)Mockito.doReturn((Object)implementation).when((Object)connection)).getClient((ServerName)Mockito.any(ServerName.class));
            NavigableMap<HRegionInfo, Result> hris = MetaTableAccessor.getServerUserRegions(connection, sn);
            Assert.assertEquals((long)1L, (long)hris.size());
            Assert.assertTrue((boolean)hris.firstEntry().getKey().equals(HRegionInfo.FIRST_META_REGIONINFO));
            Assert.assertTrue((boolean)Bytes.equals(rowToVerify, hris.firstEntry().getValue().getRow()));
            ((ClientProtos.ClientService.BlockingInterface)Mockito.verify((Object)implementation, (VerificationMode)Mockito.times((int)6))).scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any());
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
            zkw.close();
        }
    }
}

